/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.util;

import cn.win_trust_erpc.ConfigIt;
import cn.win_trust_erpc.bouncycastle.jsse.BCSNIHostName;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLSocket;
import cn.win_trust_erpc.bouncycastle.jsse.util.CustomSSLSocketFactory;
import cn.win_trust_erpc.bouncycastle.jsse.util.SNIUtil;
import java.net.Socket;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SNISocketFactory
extends CustomSSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(SNISocketFactory.class.getName());
    protected static final ThreadLocal<SNISocketFactory> threadLocal = new ThreadLocal();
    protected final URL url;

    public static SocketFactory getDefault() {
        SSLSocketFactory sslSocketFactory = threadLocal.get();
        if (sslSocketFactory != null) {
            return sslSocketFactory;
        }
        return SSLSocketFactory.getDefault();
    }

    public SNISocketFactory(SSLSocketFactory delegate, URL url) {
        super(delegate);
        this.url = url;
    }

    public <V> V call(Callable<V> callable) throws Exception {
        try {
            threadLocal.set(this);
            V v = callable.call();
            return v;
        }
        finally {
            threadLocal.remove();
        }
    }

    @Override
    protected Socket configureSocket(Socket s) {
        if (s instanceof BCSSLSocket) {
            BCSSLSocket ssl = (BCSSLSocket)((Object)s);
            BCSNIHostName sniHostName = this.getBCSNIHostName();
            if (sniHostName != null) {
                LOG.fine("Setting SNI on socket: " + sniHostName);
                BCSSLParameters sslParameters = new BCSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(sniHostName));
                ssl.setParameters(sslParameters);
            }
            String httpUrl = new String();
            httpUrl = String.valueOf(httpUrl) + this.url.getProtocol();
            httpUrl = String.valueOf(httpUrl) + "://";
            httpUrl = String.valueOf(httpUrl) + this.url.getHost();
            httpUrl = String.valueOf(httpUrl) + ":";
            if (ConfigIt.whitelist.contains(httpUrl = String.valueOf(httpUrl) + (this.url.getPort() == -1 ? "443" : Integer.valueOf(this.url.getPort())))) {
                String[] cipherSuites = new String[]{"TLS_ECDH_SM2_WITH_SM4_128_CBC_SM3"};
                String[] protocols = new String[]{"SMv1.1"};
                BCSSLParameters sslParameters = new BCSSLParameters(cipherSuites, protocols);
                ssl.setParameters(sslParameters);
            }
        }
        return s;
    }

    protected BCSNIHostName getBCSNIHostName() {
        return SNIUtil.getBCSNIHostName(this.url);
    }
}

