/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.math.ec;

import cn.win_trust_erpc.bouncycastle.math.ec.AbstractECMultiplier;
import cn.win_trust_erpc.bouncycastle.math.ec.ECAlgorithms;
import cn.win_trust_erpc.bouncycastle.math.ec.ECCurve;
import cn.win_trust_erpc.bouncycastle.math.ec.ECPoint;
import cn.win_trust_erpc.bouncycastle.math.ec.endo.EndoUtil;
import cn.win_trust_erpc.bouncycastle.math.ec.endo.GLVEndomorphism;
import java.math.BigInteger;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve curve, GLVEndomorphism glvEndomorphism) {
        if (curve == null || curve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = curve;
        this.glvEndomorphism = glvEndomorphism;
    }

    @Override
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        if (!this.curve.equals(p.getCurve())) {
            throw new IllegalStateException();
        }
        BigInteger n = p.getCurve().getOrder();
        BigInteger[] ab = this.glvEndomorphism.decomposeScalar(k.mod(n));
        BigInteger a = ab[0];
        BigInteger b = ab[1];
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implShamirsTrickWNaf(this.glvEndomorphism, p, a, b);
        }
        ECPoint q = EndoUtil.mapPoint(this.glvEndomorphism, p);
        return ECAlgorithms.implShamirsTrickWNaf(p, a, q, b);
    }
}

