/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.math.ec.tools;

import cn.win_trust_erpc.bouncycastle.asn1.x9.ECNamedCurveTable;
import cn.win_trust_erpc.bouncycastle.asn1.x9.X9ECParameters;
import cn.win_trust_erpc.bouncycastle.crypto.ec.CustomNamedCurves;
import cn.win_trust_erpc.bouncycastle.math.ec.ECAlgorithms;
import cn.win_trust_erpc.bouncycastle.math.ec.ECCurve;
import cn.win_trust_erpc.bouncycastle.math.ec.ECFieldElement;
import cn.win_trust_erpc.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;

public class TraceOptimizer {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final SecureRandom R = new SecureRandom();

    public static void main(String[] args) {
        TreeSet names = new TreeSet(TraceOptimizer.enumToList(ECNamedCurveTable.getNames()));
        names.addAll(TraceOptimizer.enumToList(CustomNamedCurves.getNames()));
        for (String name : names) {
            X9ECParameters x9 = CustomNamedCurves.getByName(name);
            if (x9 == null) {
                x9 = ECNamedCurveTable.getByName(name);
            }
            if (x9 == null || !ECAlgorithms.isF2mCurve(x9.getCurve())) continue;
            System.out.print(String.valueOf(name) + ":");
            TraceOptimizer.implPrintNonZeroTraceBits(x9);
        }
    }

    public static void printNonZeroTraceBits(X9ECParameters x9) {
        if (!ECAlgorithms.isF2mCurve(x9.getCurve())) {
            throw new IllegalArgumentException("Trace only defined over characteristic-2 fields");
        }
        TraceOptimizer.implPrintNonZeroTraceBits(x9);
    }

    public static void implPrintNonZeroTraceBits(X9ECParameters x9) {
        ECFieldElement fe;
        ECCurve c = x9.getCurve();
        int m = c.getFieldSize();
        ArrayList<Integer> nonZeroTraceBits = new ArrayList<Integer>();
        int i = 0;
        while (i < m) {
            if ((i & 1) == 0 && i != 0) {
                if (nonZeroTraceBits.contains(Integers.valueOf(i >>> 1))) {
                    nonZeroTraceBits.add(Integers.valueOf(i));
                    System.out.print(" " + i);
                }
            } else {
                BigInteger zi = ONE.shiftLeft(i);
                fe = c.fromBigInteger(zi);
                int tr = TraceOptimizer.calculateTrace(fe);
                if (tr != 0) {
                    nonZeroTraceBits.add(Integers.valueOf(i));
                    System.out.print(" " + i);
                }
            }
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < 1000) {
            BigInteger x = new BigInteger(m, R);
            fe = c.fromBigInteger(x);
            int check = TraceOptimizer.calculateTrace(fe);
            int tr = 0;
            int j = 0;
            while (j < nonZeroTraceBits.size()) {
                int bit = (Integer)nonZeroTraceBits.get(j);
                if (x.testBit(bit)) {
                    tr ^= 1;
                }
                ++j;
            }
            if (check != tr) {
                throw new IllegalStateException("Optimized-trace sanity check failed");
            }
            ++i;
        }
    }

    private static int calculateTrace(ECFieldElement fe) {
        int m = fe.getFieldSize();
        int k = 31 - Integers.numberOfLeadingZeros(m);
        int mk = 1;
        ECFieldElement tr = fe;
        while (k > 0) {
            tr = tr.squarePow(mk).add(tr);
            if (((mk = m >>> --k) & 1) == 0) continue;
            tr = tr.square().add(fe);
        }
        if (tr.isZero()) {
            return 0;
        }
        if (tr.isOne()) {
            return 1;
        }
        throw new IllegalStateException("Internal error in trace calculation");
    }

    private static ArrayList enumToList(Enumeration en) {
        ArrayList rv = new ArrayList();
        while (en.hasMoreElements()) {
            rv.add(en.nextElement());
        }
        return rv;
    }
}

