/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.operator.bc;

import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.crypto.CryptoException;
import cn.win_trust_erpc.bouncycastle.crypto.Signer;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.operator.ContentSigner;
import cn.win_trust_erpc.bouncycastle.operator.OperatorCreationException;
import cn.win_trust_erpc.bouncycastle.operator.RuntimeOperatorException;
import cn.win_trust_erpc.bouncycastle.operator.bc.BcDefaultDigestProvider;
import cn.win_trust_erpc.bouncycastle.operator.bc.BcDigestProvider;
import cn.win_trust_erpc.bouncycastle.operator.bc.BcSignerOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public abstract class BcContentSignerBuilder {
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;
    protected BcDigestProvider digestProvider;

    public BcContentSignerBuilder(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) {
        this.sigAlgId = sigAlgId;
        this.digAlgId = digAlgId;
        this.digestProvider = BcDefaultDigestProvider.INSTANCE;
    }

    public BcContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public ContentSigner build(AsymmetricKeyParameter privateKey) throws OperatorCreationException {
        Signer sig = this.createSigner(this.sigAlgId, this.digAlgId);
        if (this.random != null) {
            sig.init(true, new ParametersWithRandom(privateKey, this.random));
        } else {
            sig.init(true, privateKey);
        }
        return new ContentSigner(sig){
            private BcSignerOutputStream stream;
            {
                this.stream = new BcSignerOutputStream(signer);
            }

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return BcContentSignerBuilder.this.sigAlgId;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.stream;
            }

            @Override
            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException e) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                }
            }
        };
    }

    protected abstract Signer createSigner(AlgorithmIdentifier var1, AlgorithmIdentifier var2) throws OperatorCreationException;
}

