/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.operator.jcajce;

import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import cn.win_trust_erpc.bouncycastle.jcajce.util.NamedJcaJceHelper;
import cn.win_trust_erpc.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import cn.win_trust_erpc.bouncycastle.operator.GenericKey;
import cn.win_trust_erpc.bouncycastle.operator.OperatorException;
import cn.win_trust_erpc.bouncycastle.operator.SymmetricKeyUnwrapper;
import cn.win_trust_erpc.bouncycastle.operator.jcajce.JceGenericKey;
import cn.win_trust_erpc.bouncycastle.operator.jcajce.OperatorHelper;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class JceSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecretKey secretKey;

    public JceSymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        super(algorithmIdentifier);
        this.secretKey = secretKey;
    }

    public JceSymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceSymmetricKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        try {
            Cipher keyCipher = this.helper.createSymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
            keyCipher.init(4, this.secretKey);
            return new JceGenericKey(encryptedKeyAlgorithm, keyCipher.unwrap(encryptedKey, this.helper.getKeyAlgorithmName(encryptedKeyAlgorithm.getAlgorithm()), 3));
        }
        catch (InvalidKeyException e) {
            throw new OperatorException("key invalid in message.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OperatorException("can't find algorithm.", e);
        }
    }
}

