/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.asn1;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.DEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSLeaf;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSRootCalc;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSRootSig;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.Treehash;
import java.util.Vector;

public class GMSSPrivateKey
extends ASN1Object {
    private ASN1Primitive primitive;

    private GMSSPrivateKey(ASN1Sequence mtsPrivateKey) {
        ASN1Sequence indexPart = (ASN1Sequence)mtsPrivateKey.getObjectAt(0);
        int[] index = new int[indexPart.size()];
        int i = 0;
        while (i < indexPart.size()) {
            index[i] = GMSSPrivateKey.checkBigIntegerInIntRange(indexPart.getObjectAt(i));
            ++i;
        }
        ASN1Sequence curSeedsPart = (ASN1Sequence)mtsPrivateKey.getObjectAt(1);
        byte[][] curSeeds = new byte[curSeedsPart.size()][];
        int i2 = 0;
        while (i2 < curSeeds.length) {
            curSeeds[i2] = ((DEROctetString)curSeedsPart.getObjectAt(i2)).getOctets();
            ++i2;
        }
        ASN1Sequence nextNextSeedsPart = (ASN1Sequence)mtsPrivateKey.getObjectAt(2);
        byte[][] nextNextSeeds = new byte[nextNextSeedsPart.size()][];
        int i3 = 0;
        while (i3 < nextNextSeeds.length) {
            nextNextSeeds[i3] = ((DEROctetString)nextNextSeedsPart.getObjectAt(i3)).getOctets();
            ++i3;
        }
        ASN1Sequence curAuthPart0 = (ASN1Sequence)mtsPrivateKey.getObjectAt(3);
        byte[][][] curAuth = new byte[curAuthPart0.size()][][];
        int i4 = 0;
        while (i4 < curAuth.length) {
            ASN1Sequence curAuthPart1 = (ASN1Sequence)curAuthPart0.getObjectAt(i4);
            curAuth[i4] = new byte[curAuthPart1.size()][];
            int j = 0;
            while (j < curAuth[i4].length) {
                curAuth[i4][j] = ((DEROctetString)curAuthPart1.getObjectAt(j)).getOctets();
                ++j;
            }
            ++i4;
        }
        ASN1Sequence nextAuthPart0 = (ASN1Sequence)mtsPrivateKey.getObjectAt(4);
        byte[][][] nextAuth = new byte[nextAuthPart0.size()][][];
        int i5 = 0;
        while (i5 < nextAuth.length) {
            ASN1Sequence nextAuthPart1 = (ASN1Sequence)nextAuthPart0.getObjectAt(i5);
            nextAuth[i5] = new byte[nextAuthPart1.size()][];
            int j = 0;
            while (j < nextAuth[i5].length) {
                nextAuth[i5][j] = ((DEROctetString)nextAuthPart1.getObjectAt(j)).getOctets();
                ++j;
            }
            ++i5;
        }
        ASN1Sequence seqOfcurTreehash0 = (ASN1Sequence)mtsPrivateKey.getObjectAt(5);
        Treehash[][] curTreehash = new Treehash[seqOfcurTreehash0.size()][];
    }

    public GMSSPrivateKey(int[] index, byte[][] currentSeed, byte[][] nextNextSeed, byte[][][] currentAuthPath, byte[][][] nextAuthPath, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, byte[][][] keep, GMSSLeaf[] nextNextLeaf, GMSSLeaf[] upperLeaf, GMSSLeaf[] upperTreehashLeaf, int[] minTreehash, byte[][] nextRoot, GMSSRootCalc[] nextNextRoot, byte[][] currentRootSig, GMSSRootSig[] nextRootSig, GMSSParameters gmssParameterset, AlgorithmIdentifier digestAlg) {
        AlgorithmIdentifier[] names = new AlgorithmIdentifier[]{digestAlg};
        this.primitive = this.encode(index, currentSeed, nextNextSeed, currentAuthPath, nextAuthPath, keep, currentTreehash, nextTreehash, currentStack, nextStack, currentRetain, nextRetain, nextNextLeaf, upperLeaf, upperTreehashLeaf, minTreehash, nextRoot, nextNextRoot, currentRootSig, nextRootSig, gmssParameterset, names);
    }

    private ASN1Primitive encode(int[] index, byte[][] currentSeeds, byte[][] nextNextSeeds, byte[][][] currentAuthPaths, byte[][][] nextAuthPaths, byte[][][] keep, Treehash[][] currentTreehash, Treehash[][] nextTreehash, Vector[] currentStack, Vector[] nextStack, Vector[][] currentRetain, Vector[][] nextRetain, GMSSLeaf[] nextNextLeaf, GMSSLeaf[] upperLeaf, GMSSLeaf[] upperTreehashLeaf, int[] minTreehash, byte[][] nextRoot, GMSSRootCalc[] nextNextRoot, byte[][] currentRootSig, GMSSRootSig[] nextRootSig, GMSSParameters gmssParameterset, AlgorithmIdentifier[] algorithms) {
        int k;
        int tailLength;
        int j;
        ASN1EncodableVector result = new ASN1EncodableVector();
        ASN1EncodableVector indexPart = new ASN1EncodableVector();
        int i = 0;
        while (i < index.length) {
            indexPart.add(new ASN1Integer(index[i]));
            ++i;
        }
        result.add(new DERSequence(indexPart));
        ASN1EncodableVector curSeedsPart = new ASN1EncodableVector();
        int i2 = 0;
        while (i2 < currentSeeds.length) {
            curSeedsPart.add(new DEROctetString(currentSeeds[i2]));
            ++i2;
        }
        result.add(new DERSequence(curSeedsPart));
        ASN1EncodableVector nextNextSeedsPart = new ASN1EncodableVector();
        int i3 = 0;
        while (i3 < nextNextSeeds.length) {
            nextNextSeedsPart.add(new DEROctetString(nextNextSeeds[i3]));
            ++i3;
        }
        result.add(new DERSequence(nextNextSeedsPart));
        ASN1EncodableVector curAuthPart0 = new ASN1EncodableVector();
        ASN1EncodableVector curAuthPart1 = new ASN1EncodableVector();
        int i4 = 0;
        while (i4 < currentAuthPaths.length) {
            int j2 = 0;
            while (j2 < currentAuthPaths[i4].length) {
                curAuthPart0.add(new DEROctetString(currentAuthPaths[i4][j2]));
                ++j2;
            }
            curAuthPart1.add(new DERSequence(curAuthPart0));
            curAuthPart0 = new ASN1EncodableVector();
            ++i4;
        }
        result.add(new DERSequence(curAuthPart1));
        ASN1EncodableVector nextAuthPart0 = new ASN1EncodableVector();
        ASN1EncodableVector nextAuthPart1 = new ASN1EncodableVector();
        int i5 = 0;
        while (i5 < nextAuthPaths.length) {
            int j3 = 0;
            while (j3 < nextAuthPaths[i5].length) {
                nextAuthPart0.add(new DEROctetString(nextAuthPaths[i5][j3]));
                ++j3;
            }
            nextAuthPart1.add(new DERSequence(nextAuthPart0));
            nextAuthPart0 = new ASN1EncodableVector();
            ++i5;
        }
        result.add(new DERSequence(nextAuthPart1));
        ASN1EncodableVector seqOfTreehash0 = new ASN1EncodableVector();
        ASN1EncodableVector seqOfTreehash1 = new ASN1EncodableVector();
        ASN1EncodableVector seqOfStat = new ASN1EncodableVector();
        ASN1EncodableVector seqOfByte = new ASN1EncodableVector();
        ASN1EncodableVector seqOfInt = new ASN1EncodableVector();
        int i6 = 0;
        while (i6 < currentTreehash.length) {
            j = 0;
            while (j < currentTreehash[i6].length) {
                seqOfStat.add(new DERSequence(algorithms[0]));
                tailLength = currentTreehash[i6][j].getStatInt()[1];
                seqOfByte.add(new DEROctetString(currentTreehash[i6][j].getStatByte()[0]));
                seqOfByte.add(new DEROctetString(currentTreehash[i6][j].getStatByte()[1]));
                seqOfByte.add(new DEROctetString(currentTreehash[i6][j].getStatByte()[2]));
                k = 0;
                while (k < tailLength) {
                    seqOfByte.add(new DEROctetString(currentTreehash[i6][j].getStatByte()[3 + k]));
                    ++k;
                }
                seqOfStat.add(new DERSequence(seqOfByte));
                seqOfByte = new ASN1EncodableVector();
                seqOfInt.add(new ASN1Integer(currentTreehash[i6][j].getStatInt()[0]));
                seqOfInt.add(new ASN1Integer(tailLength));
                seqOfInt.add(new ASN1Integer(currentTreehash[i6][j].getStatInt()[2]));
                seqOfInt.add(new ASN1Integer(currentTreehash[i6][j].getStatInt()[3]));
                seqOfInt.add(new ASN1Integer(currentTreehash[i6][j].getStatInt()[4]));
                seqOfInt.add(new ASN1Integer(currentTreehash[i6][j].getStatInt()[5]));
                k = 0;
                while (k < tailLength) {
                    seqOfInt.add(new ASN1Integer(currentTreehash[i6][j].getStatInt()[6 + k]));
                    ++k;
                }
                seqOfStat.add(new DERSequence(seqOfInt));
                seqOfInt = new ASN1EncodableVector();
                seqOfTreehash1.add(new DERSequence(seqOfStat));
                seqOfStat = new ASN1EncodableVector();
                ++j;
            }
            seqOfTreehash0.add(new DERSequence(seqOfTreehash1));
            seqOfTreehash1 = new ASN1EncodableVector();
            ++i6;
        }
        result.add(new DERSequence(seqOfTreehash0));
        seqOfTreehash0 = new ASN1EncodableVector();
        seqOfTreehash1 = new ASN1EncodableVector();
        seqOfStat = new ASN1EncodableVector();
        seqOfByte = new ASN1EncodableVector();
        seqOfInt = new ASN1EncodableVector();
        i6 = 0;
        while (i6 < nextTreehash.length) {
            j = 0;
            while (j < nextTreehash[i6].length) {
                seqOfStat.add(new DERSequence(algorithms[0]));
                tailLength = nextTreehash[i6][j].getStatInt()[1];
                seqOfByte.add(new DEROctetString(nextTreehash[i6][j].getStatByte()[0]));
                seqOfByte.add(new DEROctetString(nextTreehash[i6][j].getStatByte()[1]));
                seqOfByte.add(new DEROctetString(nextTreehash[i6][j].getStatByte()[2]));
                k = 0;
                while (k < tailLength) {
                    seqOfByte.add(new DEROctetString(nextTreehash[i6][j].getStatByte()[3 + k]));
                    ++k;
                }
                seqOfStat.add(new DERSequence(seqOfByte));
                seqOfByte = new ASN1EncodableVector();
                seqOfInt.add(new ASN1Integer(nextTreehash[i6][j].getStatInt()[0]));
                seqOfInt.add(new ASN1Integer(tailLength));
                seqOfInt.add(new ASN1Integer(nextTreehash[i6][j].getStatInt()[2]));
                seqOfInt.add(new ASN1Integer(nextTreehash[i6][j].getStatInt()[3]));
                seqOfInt.add(new ASN1Integer(nextTreehash[i6][j].getStatInt()[4]));
                seqOfInt.add(new ASN1Integer(nextTreehash[i6][j].getStatInt()[5]));
                k = 0;
                while (k < tailLength) {
                    seqOfInt.add(new ASN1Integer(nextTreehash[i6][j].getStatInt()[6 + k]));
                    ++k;
                }
                seqOfStat.add(new DERSequence(seqOfInt));
                seqOfInt = new ASN1EncodableVector();
                seqOfTreehash1.add(new DERSequence(seqOfStat));
                seqOfStat = new ASN1EncodableVector();
                ++j;
            }
            seqOfTreehash0.add(new DERSequence(new DERSequence(seqOfTreehash1)));
            seqOfTreehash1 = new ASN1EncodableVector();
            ++i6;
        }
        result.add(new DERSequence(seqOfTreehash0));
        ASN1EncodableVector keepPart0 = new ASN1EncodableVector();
        ASN1EncodableVector keepPart1 = new ASN1EncodableVector();
        int i7 = 0;
        while (i7 < keep.length) {
            int j4 = 0;
            while (j4 < keep[i7].length) {
                keepPart0.add(new DEROctetString(keep[i7][j4]));
                ++j4;
            }
            keepPart1.add(new DERSequence(keepPart0));
            keepPart0 = new ASN1EncodableVector();
            ++i7;
        }
        result.add(new DERSequence(keepPart1));
        ASN1EncodableVector curStackPart0 = new ASN1EncodableVector();
        ASN1EncodableVector curStackPart1 = new ASN1EncodableVector();
        int i8 = 0;
        while (i8 < currentStack.length) {
            int j5 = 0;
            while (j5 < currentStack[i8].size()) {
                curStackPart0.add(new DEROctetString((byte[])currentStack[i8].elementAt(j5)));
                ++j5;
            }
            curStackPart1.add(new DERSequence(curStackPart0));
            curStackPart0 = new ASN1EncodableVector();
            ++i8;
        }
        result.add(new DERSequence(curStackPart1));
        ASN1EncodableVector nextStackPart0 = new ASN1EncodableVector();
        ASN1EncodableVector nextStackPart1 = new ASN1EncodableVector();
        int i9 = 0;
        while (i9 < nextStack.length) {
            int j6 = 0;
            while (j6 < nextStack[i9].size()) {
                nextStackPart0.add(new DEROctetString((byte[])nextStack[i9].elementAt(j6)));
                ++j6;
            }
            nextStackPart1.add(new DERSequence(nextStackPart0));
            nextStackPart0 = new ASN1EncodableVector();
            ++i9;
        }
        result.add(new DERSequence(nextStackPart1));
        ASN1EncodableVector currentRetainPart0 = new ASN1EncodableVector();
        ASN1EncodableVector currentRetainPart1 = new ASN1EncodableVector();
        ASN1EncodableVector currentRetainPart2 = new ASN1EncodableVector();
        int i10 = 0;
        while (i10 < currentRetain.length) {
            int j7 = 0;
            while (j7 < currentRetain[i10].length) {
                int k2 = 0;
                while (k2 < currentRetain[i10][j7].size()) {
                    currentRetainPart0.add(new DEROctetString((byte[])currentRetain[i10][j7].elementAt(k2)));
                    ++k2;
                }
                currentRetainPart1.add(new DERSequence(currentRetainPart0));
                currentRetainPart0 = new ASN1EncodableVector();
                ++j7;
            }
            currentRetainPart2.add(new DERSequence(currentRetainPart1));
            currentRetainPart1 = new ASN1EncodableVector();
            ++i10;
        }
        result.add(new DERSequence(currentRetainPart2));
        ASN1EncodableVector nextRetainPart0 = new ASN1EncodableVector();
        ASN1EncodableVector nextRetainPart1 = new ASN1EncodableVector();
        ASN1EncodableVector nextRetainPart2 = new ASN1EncodableVector();
        int i11 = 0;
        while (i11 < nextRetain.length) {
            int j8 = 0;
            while (j8 < nextRetain[i11].length) {
                int k3 = 0;
                while (k3 < nextRetain[i11][j8].size()) {
                    nextRetainPart0.add(new DEROctetString((byte[])nextRetain[i11][j8].elementAt(k3)));
                    ++k3;
                }
                nextRetainPart1.add(new DERSequence(nextRetainPart0));
                nextRetainPart0 = new ASN1EncodableVector();
                ++j8;
            }
            nextRetainPart2.add(new DERSequence(nextRetainPart1));
            nextRetainPart1 = new ASN1EncodableVector();
            ++i11;
        }
        result.add(new DERSequence(nextRetainPart2));
        ASN1EncodableVector seqOfLeaf = new ASN1EncodableVector();
        seqOfStat = new ASN1EncodableVector();
        seqOfByte = new ASN1EncodableVector();
        seqOfInt = new ASN1EncodableVector();
        int i12 = 0;
        while (i12 < nextNextLeaf.length) {
            seqOfStat.add(new DERSequence(algorithms[0]));
            byte[][] tempByte = nextNextLeaf[i12].getStatByte();
            seqOfByte.add(new DEROctetString(tempByte[0]));
            seqOfByte.add(new DEROctetString(tempByte[1]));
            seqOfByte.add(new DEROctetString(tempByte[2]));
            seqOfByte.add(new DEROctetString(tempByte[3]));
            seqOfStat.add(new DERSequence(seqOfByte));
            seqOfByte = new ASN1EncodableVector();
            int[] tempInt = nextNextLeaf[i12].getStatInt();
            seqOfInt.add(new ASN1Integer(tempInt[0]));
            seqOfInt.add(new ASN1Integer(tempInt[1]));
            seqOfInt.add(new ASN1Integer(tempInt[2]));
            seqOfInt.add(new ASN1Integer(tempInt[3]));
            seqOfStat.add(new DERSequence(seqOfInt));
            seqOfInt = new ASN1EncodableVector();
            seqOfLeaf.add(new DERSequence(seqOfStat));
            seqOfStat = new ASN1EncodableVector();
            ++i12;
        }
        result.add(new DERSequence(seqOfLeaf));
        ASN1EncodableVector seqOfUpperLeaf = new ASN1EncodableVector();
        seqOfStat = new ASN1EncodableVector();
        seqOfByte = new ASN1EncodableVector();
        seqOfInt = new ASN1EncodableVector();
        int i13 = 0;
        while (i13 < upperLeaf.length) {
            seqOfStat.add(new DERSequence(algorithms[0]));
            byte[][] tempByte = upperLeaf[i13].getStatByte();
            seqOfByte.add(new DEROctetString(tempByte[0]));
            seqOfByte.add(new DEROctetString(tempByte[1]));
            seqOfByte.add(new DEROctetString(tempByte[2]));
            seqOfByte.add(new DEROctetString(tempByte[3]));
            seqOfStat.add(new DERSequence(seqOfByte));
            seqOfByte = new ASN1EncodableVector();
            int[] tempInt = upperLeaf[i13].getStatInt();
            seqOfInt.add(new ASN1Integer(tempInt[0]));
            seqOfInt.add(new ASN1Integer(tempInt[1]));
            seqOfInt.add(new ASN1Integer(tempInt[2]));
            seqOfInt.add(new ASN1Integer(tempInt[3]));
            seqOfStat.add(new DERSequence(seqOfInt));
            seqOfInt = new ASN1EncodableVector();
            seqOfUpperLeaf.add(new DERSequence(seqOfStat));
            seqOfStat = new ASN1EncodableVector();
            ++i13;
        }
        result.add(new DERSequence(seqOfUpperLeaf));
        ASN1EncodableVector seqOfUpperTreehashLeaf = new ASN1EncodableVector();
        seqOfStat = new ASN1EncodableVector();
        seqOfByte = new ASN1EncodableVector();
        seqOfInt = new ASN1EncodableVector();
        int i14 = 0;
        while (i14 < upperTreehashLeaf.length) {
            seqOfStat.add(new DERSequence(algorithms[0]));
            byte[][] tempByte = upperTreehashLeaf[i14].getStatByte();
            seqOfByte.add(new DEROctetString(tempByte[0]));
            seqOfByte.add(new DEROctetString(tempByte[1]));
            seqOfByte.add(new DEROctetString(tempByte[2]));
            seqOfByte.add(new DEROctetString(tempByte[3]));
            seqOfStat.add(new DERSequence(seqOfByte));
            seqOfByte = new ASN1EncodableVector();
            int[] tempInt = upperTreehashLeaf[i14].getStatInt();
            seqOfInt.add(new ASN1Integer(tempInt[0]));
            seqOfInt.add(new ASN1Integer(tempInt[1]));
            seqOfInt.add(new ASN1Integer(tempInt[2]));
            seqOfInt.add(new ASN1Integer(tempInt[3]));
            seqOfStat.add(new DERSequence(seqOfInt));
            seqOfInt = new ASN1EncodableVector();
            seqOfUpperTreehashLeaf.add(new DERSequence(seqOfStat));
            seqOfStat = new ASN1EncodableVector();
            ++i14;
        }
        result.add(new DERSequence(seqOfUpperTreehashLeaf));
        ASN1EncodableVector minTreehashPart = new ASN1EncodableVector();
        int i15 = 0;
        while (i15 < minTreehash.length) {
            minTreehashPart.add(new ASN1Integer(minTreehash[i15]));
            ++i15;
        }
        result.add(new DERSequence(minTreehashPart));
        ASN1EncodableVector nextRootPart = new ASN1EncodableVector();
        int i16 = 0;
        while (i16 < nextRoot.length) {
            nextRootPart.add(new DEROctetString(nextRoot[i16]));
            ++i16;
        }
        result.add(new DERSequence(nextRootPart));
        ASN1EncodableVector seqOfnextNextRoot = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRStats = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRStrings = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRBytes = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRInts = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRTreehash = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnnRRetain = new ASN1EncodableVector();
        int i17 = 0;
        while (i17 < nextNextRoot.length) {
            int k4;
            seqOfnnRStats.add(new DERSequence(algorithms[0]));
            seqOfnnRStrings = new ASN1EncodableVector();
            int heightOfTree = nextNextRoot[i17].getStatInt()[0];
            int tailLength2 = nextNextRoot[i17].getStatInt()[7];
            seqOfnnRBytes.add(new DEROctetString(nextNextRoot[i17].getStatByte()[0]));
            int j9 = 0;
            while (j9 < heightOfTree) {
                seqOfnnRBytes.add(new DEROctetString(nextNextRoot[i17].getStatByte()[1 + j9]));
                ++j9;
            }
            j9 = 0;
            while (j9 < tailLength2) {
                seqOfnnRBytes.add(new DEROctetString(nextNextRoot[i17].getStatByte()[1 + heightOfTree + j9]));
                ++j9;
            }
            seqOfnnRStats.add(new DERSequence(seqOfnnRBytes));
            seqOfnnRBytes = new ASN1EncodableVector();
            seqOfnnRInts.add(new ASN1Integer(heightOfTree));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[1]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[2]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[3]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[4]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[5]));
            seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[6]));
            seqOfnnRInts.add(new ASN1Integer(tailLength2));
            j9 = 0;
            while (j9 < heightOfTree) {
                seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[8 + j9]));
                ++j9;
            }
            j9 = 0;
            while (j9 < tailLength2) {
                seqOfnnRInts.add(new ASN1Integer(nextNextRoot[i17].getStatInt()[8 + heightOfTree + j9]));
                ++j9;
            }
            seqOfnnRStats.add(new DERSequence(seqOfnnRInts));
            seqOfnnRInts = new ASN1EncodableVector();
            seqOfStat = new ASN1EncodableVector();
            seqOfByte = new ASN1EncodableVector();
            seqOfInt = new ASN1EncodableVector();
            if (nextNextRoot[i17].getTreehash() != null) {
                j9 = 0;
                while (j9 < nextNextRoot[i17].getTreehash().length) {
                    seqOfStat.add(new DERSequence(algorithms[0]));
                    tailLength2 = nextNextRoot[i17].getTreehash()[j9].getStatInt()[1];
                    seqOfByte.add(new DEROctetString(nextNextRoot[i17].getTreehash()[j9].getStatByte()[0]));
                    seqOfByte.add(new DEROctetString(nextNextRoot[i17].getTreehash()[j9].getStatByte()[1]));
                    seqOfByte.add(new DEROctetString(nextNextRoot[i17].getTreehash()[j9].getStatByte()[2]));
                    k4 = 0;
                    while (k4 < tailLength2) {
                        seqOfByte.add(new DEROctetString(nextNextRoot[i17].getTreehash()[j9].getStatByte()[3 + k4]));
                        ++k4;
                    }
                    seqOfStat.add(new DERSequence(seqOfByte));
                    seqOfByte = new ASN1EncodableVector();
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[0]));
                    seqOfInt.add(new ASN1Integer(tailLength2));
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[2]));
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[3]));
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[4]));
                    seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[5]));
                    k4 = 0;
                    while (k4 < tailLength2) {
                        seqOfInt.add(new ASN1Integer(nextNextRoot[i17].getTreehash()[j9].getStatInt()[6 + k4]));
                        ++k4;
                    }
                    seqOfStat.add(new DERSequence(seqOfInt));
                    seqOfInt = new ASN1EncodableVector();
                    seqOfnnRTreehash.add(new DERSequence(seqOfStat));
                    seqOfStat = new ASN1EncodableVector();
                    ++j9;
                }
            }
            seqOfnnRStats.add(new DERSequence(seqOfnnRTreehash));
            seqOfnnRTreehash = new ASN1EncodableVector();
            currentRetainPart0 = new ASN1EncodableVector();
            if (nextNextRoot[i17].getRetain() != null) {
                j9 = 0;
                while (j9 < nextNextRoot[i17].getRetain().length) {
                    k4 = 0;
                    while (k4 < nextNextRoot[i17].getRetain()[j9].size()) {
                        currentRetainPart0.add(new DEROctetString((byte[])nextNextRoot[i17].getRetain()[j9].elementAt(k4)));
                        ++k4;
                    }
                    seqOfnnRRetain.add(new DERSequence(currentRetainPart0));
                    currentRetainPart0 = new ASN1EncodableVector();
                    ++j9;
                }
            }
            seqOfnnRStats.add(new DERSequence(seqOfnnRRetain));
            seqOfnnRRetain = new ASN1EncodableVector();
            seqOfnextNextRoot.add(new DERSequence(seqOfnnRStats));
            seqOfnnRStats = new ASN1EncodableVector();
            ++i17;
        }
        result.add(new DERSequence(seqOfnextNextRoot));
        ASN1EncodableVector curRootSigPart = new ASN1EncodableVector();
        int i18 = 0;
        while (i18 < currentRootSig.length) {
            curRootSigPart.add(new DEROctetString(currentRootSig[i18]));
            ++i18;
        }
        result.add(new DERSequence(curRootSigPart));
        ASN1EncodableVector seqOfnextRootSigs = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnRSStats = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnRSStrings = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnRSBytes = new ASN1EncodableVector();
        ASN1EncodableVector seqOfnRSInts = new ASN1EncodableVector();
        int i19 = 0;
        while (i19 < nextRootSig.length) {
            seqOfnRSStats.add(new DERSequence(algorithms[0]));
            seqOfnRSStrings = new ASN1EncodableVector();
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[0]));
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[1]));
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[2]));
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[3]));
            seqOfnRSBytes.add(new DEROctetString(nextRootSig[i19].getStatByte()[4]));
            seqOfnRSStats.add(new DERSequence(seqOfnRSBytes));
            seqOfnRSBytes = new ASN1EncodableVector();
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[0]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[1]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[2]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[3]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[4]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[5]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[6]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[7]));
            seqOfnRSInts.add(new ASN1Integer(nextRootSig[i19].getStatInt()[8]));
            seqOfnRSStats.add(new DERSequence(seqOfnRSInts));
            seqOfnRSInts = new ASN1EncodableVector();
            seqOfnextRootSigs.add(new DERSequence(seqOfnRSStats));
            seqOfnRSStats = new ASN1EncodableVector();
            ++i19;
        }
        result.add(new DERSequence(seqOfnextRootSigs));
        ASN1EncodableVector parSetPart0 = new ASN1EncodableVector();
        ASN1EncodableVector parSetPart1 = new ASN1EncodableVector();
        ASN1EncodableVector parSetPart2 = new ASN1EncodableVector();
        ASN1EncodableVector parSetPart3 = new ASN1EncodableVector();
        int i20 = 0;
        while (i20 < gmssParameterset.getHeightOfTrees().length) {
            parSetPart1.add(new ASN1Integer(gmssParameterset.getHeightOfTrees()[i20]));
            parSetPart2.add(new ASN1Integer(gmssParameterset.getWinternitzParameter()[i20]));
            parSetPart3.add(new ASN1Integer(gmssParameterset.getK()[i20]));
            ++i20;
        }
        parSetPart0.add(new ASN1Integer(gmssParameterset.getNumOfLayers()));
        parSetPart0.add(new DERSequence(parSetPart1));
        parSetPart0.add(new DERSequence(parSetPart2));
        parSetPart0.add(new DERSequence(parSetPart3));
        result.add(new DERSequence(parSetPart0));
        ASN1EncodableVector namesPart = new ASN1EncodableVector();
        int i21 = 0;
        while (i21 < algorithms.length) {
            namesPart.add(algorithms[i21]);
            ++i21;
        }
        result.add(new DERSequence(namesPart));
        return new DERSequence(result);
    }

    private static int checkBigIntegerInIntRange(ASN1Encodable a) {
        return ((ASN1Integer)a).intValueExact();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.primitive;
    }
}

