/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.crypto.Signer;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.MessageSigner;

public class DigestingMessageSigner
implements Signer {
    private final Digest messDigest;
    private final MessageSigner messSigner;
    private boolean forSigning;

    public DigestingMessageSigner(MessageSigner messSigner, Digest messDigest) {
        this.messSigner = messSigner;
        this.messDigest = messDigest;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        AsymmetricKeyParameter k = param instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)param).getParameters() : (AsymmetricKeyParameter)param;
        if (forSigning && !k.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!forSigning && k.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.messSigner.init(forSigning, param);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for signature generation.");
        }
        byte[] hash = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(hash, 0);
        return this.messSigner.generateSignature(hash);
    }

    @Override
    public void update(byte b) {
        this.messDigest.update(b);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.messDigest.update(in, off, len);
    }

    @Override
    public void reset() {
        this.messDigest.reset();
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.forSigning) {
            throw new IllegalStateException("DigestingMessageSigner not initialised for verification");
        }
        byte[] hash = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(hash, 0);
        return this.messSigner.verifySignature(hash, signature);
    }
}

