/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss;

import cn.win_trust_erpc.bouncycastle.util.Arrays;

public class GMSSParameters {
    private int numOfLayers;
    private int[] heightOfTrees;
    private int[] winternitzParameter;
    private int[] K;

    public GMSSParameters(int layers, int[] heightOfTrees, int[] winternitzParameter, int[] K) throws IllegalArgumentException {
        this.init(layers, heightOfTrees, winternitzParameter, K);
    }

    private void init(int layers, int[] heightOfTrees, int[] winternitzParameter, int[] K) throws IllegalArgumentException {
        boolean valid = true;
        String errMsg = "";
        this.numOfLayers = layers;
        if (this.numOfLayers != winternitzParameter.length || this.numOfLayers != heightOfTrees.length || this.numOfLayers != K.length) {
            valid = false;
            errMsg = "Unexpected parameterset format";
        }
        int i = 0;
        while (i < this.numOfLayers) {
            if (K[i] < 2 || (heightOfTrees[i] - K[i]) % 2 != 0) {
                valid = false;
                errMsg = "Wrong parameter K (K >= 2 and H-K even required)!";
            }
            if (heightOfTrees[i] < 4 || winternitzParameter[i] < 2) {
                valid = false;
                errMsg = "Wrong parameter H or w (H > 3 and w > 1 required)!";
            }
            ++i;
        }
        if (!valid) {
            throw new IllegalArgumentException(errMsg);
        }
        this.heightOfTrees = Arrays.clone(heightOfTrees);
        this.winternitzParameter = Arrays.clone(winternitzParameter);
        this.K = Arrays.clone(K);
    }

    public GMSSParameters(int keySize) throws IllegalArgumentException {
        if (keySize <= 10) {
            int[] defh = new int[]{10};
            int[] defw = new int[]{3};
            int[] defk = new int[]{2};
            this.init(defh.length, defh, defw, defk);
        } else if (keySize <= 20) {
            int[] defh = new int[]{10, 10};
            int[] defw = new int[]{5, 4};
            int[] defk = new int[]{2, 2};
            this.init(defh.length, defh, defw, defk);
        } else {
            int[] defh = new int[]{10, 10, 10, 10};
            int[] defw = new int[]{9, 9, 9, 3};
            int[] defk = new int[]{2, 2, 2, 2};
            this.init(defh.length, defh, defw, defk);
        }
    }

    public int getNumOfLayers() {
        return this.numOfLayers;
    }

    public int[] getHeightOfTrees() {
        return Arrays.clone(this.heightOfTrees);
    }

    public int[] getWinternitzParameter() {
        return Arrays.clone(this.winternitzParameter);
    }

    public int[] getK() {
        return Arrays.clone(this.K);
    }
}

