/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.lms;

import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.Composer;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSSignature;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMS;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSContext;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSSignature;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HSSPublicKeyParameters
extends LMSKeyParameters
implements LMSContextBasedVerifier {
    private final int l;
    private final LMSPublicKeyParameters lmsPublicKey;

    public HSSPublicKeyParameters(int l, LMSPublicKeyParameters lmsPublicKey) {
        super(false);
        this.l = l;
        this.lmsPublicKey = lmsPublicKey;
    }

    public static HSSPublicKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof HSSPublicKeyParameters) {
            return (HSSPublicKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            int L = ((DataInputStream)src).readInt();
            LMSPublicKeyParameters lmsPublicKey = LMSPublicKeyParameters.getInstance(src);
            return new HSSPublicKeyParameters(L, lmsPublicKey);
        }
        if (src instanceof byte[]) {
            InputStream in = null;
            try {
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                HSSPublicKeyParameters hSSPublicKeyParameters = HSSPublicKeyParameters.getInstance(in);
                return hSSPublicKeyParameters;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (src instanceof InputStream) {
            return HSSPublicKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public int getL() {
        return this.l;
    }

    public LMSPublicKeyParameters getLMSPublicKey() {
        return this.lmsPublicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSSPublicKeyParameters publicKey = (HSSPublicKeyParameters)o;
        if (this.l != publicKey.l) {
            return false;
        }
        return this.lmsPublicKey.equals(publicKey.lmsPublicKey);
    }

    public int hashCode() {
        int result = this.l;
        result = 31 * result + this.lmsPublicKey.hashCode();
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.l).bytes(this.lmsPublicKey.getEncoded()).build();
    }

    @Override
    public LMSContext generateLMSContext(byte[] sigEnc) {
        HSSSignature signature;
        try {
            signature = HSSSignature.getInstance(sigEnc, this.getL());
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot parse signature: " + e.getMessage());
        }
        LMSSignedPubKey[] signedPubKeys = signature.getSignedPubKey();
        LMSPublicKeyParameters key = signedPubKeys[signedPubKeys.length - 1].getPublicKey();
        return key.generateOtsContext(signature.getSignature()).withSignedPublicKeys(signedPubKeys);
    }

    @Override
    public boolean verify(LMSContext context) {
        boolean failed = false;
        LMSSignedPubKey[] sigKeys = context.getSignedPubKeys();
        if (sigKeys.length != this.getL() - 1) {
            return false;
        }
        LMSPublicKeyParameters key = this.getLMSPublicKey();
        int i = 0;
        while (i < sigKeys.length) {
            byte[] msg;
            LMSSignature sig = sigKeys[i].getSignature();
            if (!LMS.verifySignature(key, sig, msg = sigKeys[i].getPublicKey().toByteArray())) {
                failed = true;
            }
            key = sigKeys[i].getPublicKey();
            ++i;
        }
        return !failed & key.verify(context);
    }
}

