/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.lms;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMS;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import java.security.SecureRandom;

public class LMSKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    LMSKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (LMSKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom source = this.param.getRandom();
        byte[] I = new byte[16];
        source.nextBytes(I);
        byte[] rootSecret = new byte[32];
        source.nextBytes(rootSecret);
        LMSPrivateKeyParameters privKey = LMS.generateKeys(this.param.getParameters().getLMSigParam(), this.param.getParameters().getLMOTSParam(), 0, I, rootSecret);
        return new AsymmetricCipherKeyPair(privKey.getPublicKey(), privKey);
    }
}

