/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope;

import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.crypto.util.DEROtherInfo;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.ExchangePair;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope.NHAgreement;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import java.io.IOException;
import java.security.SecureRandom;

public class NHOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;
    protected boolean used = false;

    public NHOtherInfoGenerator(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmID, partyUInfo, partyVInfo);
        this.random = random;
    }

    private static byte[] getEncoded(NHPublicKeyParameters pubKey) {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            SubjectPublicKeyInfo pki = new SubjectPublicKeyInfo(algorithmIdentifier, pubKey.getPubData());
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static NHPublicKeyParameters getPublicKey(byte[] enc) {
        SubjectPublicKeyInfo pki = SubjectPublicKeyInfo.getInstance(enc);
        return new NHPublicKeyParameters(pki.getPublicKeyData().getOctets());
    }

    public static class PartyU
    extends NHOtherInfoGenerator {
        private AsymmetricCipherKeyPair aKp;
        private NHAgreement agreement = new NHAgreement();

        public PartyU(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
            super(algorithmID, partyUInfo, partyVInfo, random);
            NHKeyPairGenerator kpGen = new NHKeyPairGenerator();
            kpGen.init(new KeyGenerationParameters(random, 2048));
            this.aKp = kpGen.generateKeyPair();
            this.agreement.init(this.aKp.getPrivate());
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] suppPubInfo) {
            this.otherInfoBuilder.withSuppPubInfo(suppPubInfo);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            return NHOtherInfoGenerator.getEncoded((NHPublicKeyParameters)this.aKp.getPublic());
        }

        public DEROtherInfo generate(byte[] suppPrivInfoPartB) {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            this.otherInfoBuilder.withSuppPrivInfo(this.agreement.calculateAgreement(NHOtherInfoGenerator.getPublicKey(suppPrivInfoPartB)));
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyV
    extends NHOtherInfoGenerator {
        public PartyV(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
            super(algorithmID, partyUInfo, partyVInfo, random);
        }

        public NHOtherInfoGenerator withSuppPubInfo(byte[] suppPubInfo) {
            this.otherInfoBuilder.withSuppPubInfo(suppPubInfo);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] suppPrivInfoPartA) {
            NHExchangePairGenerator exchGen = new NHExchangePairGenerator(this.random);
            ExchangePair bEp = exchGen.generateExchange(NHOtherInfoGenerator.getPublicKey(suppPrivInfoPartA));
            this.otherInfoBuilder.withSuppPrivInfo(bEp.getSharedValue());
            return NHOtherInfoGenerator.getEncoded((NHPublicKeyParameters)bEp.getPublicKey());
        }

        public DEROtherInfo generate() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return this.otherInfoBuilder.build();
        }
    }
}

