/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.ntru;

import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA256Digest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA512Digest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class NTRUSigningParameters
implements Cloneable {
    public int N;
    public int q;
    public int d;
    public int d1;
    public int d2;
    public int d3;
    public int B;
    double beta;
    public double betaSq;
    double normBound;
    public double normBoundSq;
    public int signFailTolerance = 100;
    int bitsF = 6;
    public Digest hashAlg;

    public NTRUSigningParameters(int N, int q, int d, int B, double beta, double normBound, Digest hashAlg) {
        this.N = N;
        this.q = q;
        this.d = d;
        this.B = B;
        this.beta = beta;
        this.normBound = normBound;
        this.hashAlg = hashAlg;
        this.init();
    }

    public NTRUSigningParameters(int N, int q, int d1, int d2, int d3, int B, double beta, double normBound, double keyNormBound, Digest hashAlg) {
        this.N = N;
        this.q = q;
        this.d1 = d1;
        this.d2 = d2;
        this.d3 = d3;
        this.B = B;
        this.beta = beta;
        this.normBound = normBound;
        this.hashAlg = hashAlg;
        this.init();
    }

    private void init() {
        this.betaSq = this.beta * this.beta;
        this.normBoundSq = this.normBound * this.normBound;
    }

    public NTRUSigningParameters(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        this.N = dis.readInt();
        this.q = dis.readInt();
        this.d = dis.readInt();
        this.d1 = dis.readInt();
        this.d2 = dis.readInt();
        this.d3 = dis.readInt();
        this.B = dis.readInt();
        this.beta = dis.readDouble();
        this.normBound = dis.readDouble();
        this.signFailTolerance = dis.readInt();
        this.bitsF = dis.readInt();
        String alg = dis.readUTF();
        if ("SHA-512".equals(alg)) {
            this.hashAlg = new SHA512Digest();
        } else if ("SHA-256".equals(alg)) {
            this.hashAlg = new SHA256Digest();
        }
        this.init();
    }

    public void writeTo(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(this.N);
        dos.writeInt(this.q);
        dos.writeInt(this.d);
        dos.writeInt(this.d1);
        dos.writeInt(this.d2);
        dos.writeInt(this.d3);
        dos.writeInt(this.B);
        dos.writeDouble(this.beta);
        dos.writeDouble(this.normBound);
        dos.writeInt(this.signFailTolerance);
        dos.writeInt(this.bitsF);
        dos.writeUTF(this.hashAlg.getAlgorithmName());
    }

    public NTRUSigningParameters clone() {
        return new NTRUSigningParameters(this.N, this.q, this.d, this.B, this.beta, this.normBound, this.hashAlg);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.B;
        result = 31 * result + this.N;
        long temp = Double.doubleToLongBits(this.beta);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.betaSq);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.bitsF;
        result = 31 * result + this.d;
        result = 31 * result + this.d1;
        result = 31 * result + this.d2;
        result = 31 * result + this.d3;
        result = 31 * result + (this.hashAlg == null ? 0 : this.hashAlg.getAlgorithmName().hashCode());
        temp = Double.doubleToLongBits(this.normBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.normBoundSq);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.q;
        result = 31 * result + this.signFailTolerance;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUSigningParameters)) {
            return false;
        }
        NTRUSigningParameters other = (NTRUSigningParameters)obj;
        if (this.B != other.B) {
            return false;
        }
        if (this.N != other.N) {
            return false;
        }
        if (Double.doubleToLongBits(this.beta) != Double.doubleToLongBits(other.beta)) {
            return false;
        }
        if (Double.doubleToLongBits(this.betaSq) != Double.doubleToLongBits(other.betaSq)) {
            return false;
        }
        if (this.bitsF != other.bitsF) {
            return false;
        }
        if (this.d != other.d) {
            return false;
        }
        if (this.d1 != other.d1) {
            return false;
        }
        if (this.d2 != other.d2) {
            return false;
        }
        if (this.d3 != other.d3) {
            return false;
        }
        if (this.hashAlg == null ? other.hashAlg != null : !this.hashAlg.getAlgorithmName().equals(other.hashAlg.getAlgorithmName())) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBound) != Double.doubleToLongBits(other.normBound)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBoundSq) != Double.doubleToLongBits(other.normBoundSq)) {
            return false;
        }
        if (this.q != other.q) {
            return false;
        }
        return this.signFailTolerance == other.signFailTolerance;
    }

    public String toString() {
        DecimalFormat format = new DecimalFormat("0.00");
        StringBuilder output = new StringBuilder("SignatureParameters(N=" + this.N + " q=" + this.q);
        output.append(" B=" + this.B + " beta=" + format.format(this.beta) + " normBound=" + format.format(this.normBound) + " hashAlg=" + this.hashAlg + ")");
        return output.toString();
    }
}

