/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla;

import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import cn.win_trust_erpc.bouncycastle.util.Arrays;

public final class QTESLAPublicKeyParameters
extends AsymmetricKeyParameter {
    private int securityCategory;
    private byte[] publicKey;

    public QTESLAPublicKeyParameters(int securityCategory, byte[] publicKey) {
        super(false);
        if (publicKey.length != QTESLASecurityCategory.getPublicSize(securityCategory)) {
            throw new IllegalArgumentException("invalid key size for security category");
        }
        this.securityCategory = securityCategory;
        this.publicKey = Arrays.clone(publicKey);
    }

    public int getSecurityCategory() {
        return this.securityCategory;
    }

    public byte[] getPublicData() {
        return Arrays.clone(this.publicKey);
    }
}

