/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.crypto.CryptoServicesRegistrar;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.MessageSigner;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTesla1p;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTesla3p;
import java.security.SecureRandom;

public class QTESLASigner
implements MessageSigner {
    private QTESLAPublicKeyParameters publicKey;
    private QTESLAPrivateKeyParameters privateKey;
    private SecureRandom secureRandom;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                this.secureRandom = ((ParametersWithRandom)param).getRandom();
                this.privateKey = (QTESLAPrivateKeyParameters)((ParametersWithRandom)param).getParameters();
            } else {
                this.secureRandom = CryptoServicesRegistrar.getSecureRandom();
                this.privateKey = (QTESLAPrivateKeyParameters)param;
            }
            this.publicKey = null;
            QTESLASecurityCategory.validate(this.privateKey.getSecurityCategory());
        } else {
            this.privateKey = null;
            this.publicKey = (QTESLAPublicKeyParameters)param;
            QTESLASecurityCategory.validate(this.publicKey.getSecurityCategory());
        }
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        byte[] sig = new byte[QTESLASecurityCategory.getSignatureSize(this.privateKey.getSecurityCategory())];
        switch (this.privateKey.getSecurityCategory()) {
            case 5: {
                QTesla1p.generateSignature(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 6: {
                QTesla3p.generateSignature(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.privateKey.getSecurityCategory());
            }
        }
        return sig;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        int status;
        switch (this.publicKey.getSecurityCategory()) {
            case 5: {
                status = QTesla1p.verifying(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 6: {
                status = QTesla3p.verifying(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.publicKey.getSecurityCategory());
            }
        }
        return status == 0;
    }
}

