/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.rainbow.util;

import cn.win_trust_erpc.bouncycastle.pqc.crypto.rainbow.util.GF2Field;

public class ComputeInField {
    private short[][] A;
    short[] x;

    public short[] solveEquation(short[][] B, short[] b) {
        if (B.length != b.length) {
            return null;
        }
        try {
            this.A = new short[B.length][B.length + 1];
            this.x = new short[B.length];
            int i = 0;
            while (i < B.length) {
                int j = 0;
                while (j < B[0].length) {
                    this.A[i][j] = B[i][j];
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < b.length) {
                this.A[i][b.length] = GF2Field.addElem(b[i], this.A[i][b.length]);
                ++i;
            }
            this.computeZerosUnder(false);
            this.substitute();
            return this.x;
        }
        catch (RuntimeException rte) {
            return null;
        }
    }

    public short[][] inverse(short[][] coef) {
        try {
            int j;
            this.A = new short[coef.length][2 * coef.length];
            if (coef.length != coef[0].length) {
                throw new RuntimeException("The matrix is not invertible. Please choose another one!");
            }
            int i = 0;
            while (i < coef.length) {
                j = 0;
                while (j < coef.length) {
                    this.A[i][j] = coef[i][j];
                    ++j;
                }
                j = coef.length;
                while (j < 2 * coef.length) {
                    this.A[i][j] = 0;
                    ++j;
                }
                this.A[i][i + this.A.length] = 1;
                ++i;
            }
            this.computeZerosUnder(true);
            i = 0;
            while (i < this.A.length) {
                short factor = GF2Field.invElem(this.A[i][i]);
                j = i;
                while (j < 2 * this.A.length) {
                    this.A[i][j] = GF2Field.multElem(this.A[i][j], factor);
                    ++j;
                }
                ++i;
            }
            this.computeZerosAbove();
            short[][] inverse = new short[this.A.length][this.A.length];
            i = 0;
            while (i < this.A.length) {
                j = this.A.length;
                while (j < 2 * this.A.length) {
                    inverse[i][j - this.A.length] = this.A[i][j];
                    ++j;
                }
                ++i;
            }
            return inverse;
        }
        catch (RuntimeException rte) {
            return null;
        }
    }

    private void computeZerosUnder(boolean usedForInverse) throws RuntimeException {
        short tmp = 0;
        int length = usedForInverse ? 2 * this.A.length : this.A.length + 1;
        int k = 0;
        while (k < this.A.length - 1) {
            int i = k + 1;
            while (i < this.A.length) {
                short factor1 = this.A[i][k];
                short factor2 = GF2Field.invElem(this.A[k][k]);
                if (factor2 == 0) {
                    throw new IllegalStateException("Matrix not invertible! We have to choose another one!");
                }
                int j = k;
                while (j < length) {
                    tmp = GF2Field.multElem(this.A[k][j], factor2);
                    tmp = GF2Field.multElem(factor1, tmp);
                    this.A[i][j] = GF2Field.addElem(this.A[i][j], tmp);
                    ++j;
                }
                ++i;
            }
            ++k;
        }
    }

    private void computeZerosAbove() throws RuntimeException {
        short tmp = 0;
        int k = this.A.length - 1;
        while (k > 0) {
            int i = k - 1;
            while (i >= 0) {
                short factor1 = this.A[i][k];
                short factor2 = GF2Field.invElem(this.A[k][k]);
                if (factor2 == 0) {
                    throw new RuntimeException("The matrix is not invertible");
                }
                int j = k;
                while (j < 2 * this.A.length) {
                    tmp = GF2Field.multElem(this.A[k][j], factor2);
                    tmp = GF2Field.multElem(factor1, tmp);
                    this.A[i][j] = GF2Field.addElem(this.A[i][j], tmp);
                    ++j;
                }
                --i;
            }
            --k;
        }
    }

    private void substitute() throws IllegalStateException {
        short temp = GF2Field.invElem(this.A[this.A.length - 1][this.A.length - 1]);
        if (temp == 0) {
            throw new IllegalStateException("The equation system is not solvable");
        }
        this.x[this.A.length - 1] = GF2Field.multElem(this.A[this.A.length - 1][this.A.length], temp);
        int i = this.A.length - 2;
        while (i >= 0) {
            short tmp = this.A[i][this.A.length];
            int j = this.A.length - 1;
            while (j > i) {
                temp = GF2Field.multElem(this.A[i][j], this.x[j]);
                tmp = GF2Field.addElem(tmp, temp);
                --j;
            }
            temp = GF2Field.invElem(this.A[i][i]);
            if (temp == 0) {
                throw new IllegalStateException("Not solvable equation system");
            }
            this.x[i] = GF2Field.multElem(tmp, temp);
            --i;
        }
    }

    public short[][] multiplyMatrix(short[][] M1, short[][] M2) throws RuntimeException {
        if (M1[0].length != M2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short tmp = 0;
        this.A = new short[M1.length][M2[0].length];
        int i = 0;
        while (i < M1.length) {
            int j = 0;
            while (j < M2.length) {
                int k = 0;
                while (k < M2[0].length) {
                    tmp = GF2Field.multElem(M1[i][j], M2[j][k]);
                    this.A[i][k] = GF2Field.addElem(this.A[i][k], tmp);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return this.A;
    }

    public short[] multiplyMatrix(short[][] M1, short[] m) throws RuntimeException {
        if (M1[0].length != m.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short tmp = 0;
        short[] B = new short[M1.length];
        int i = 0;
        while (i < M1.length) {
            int j = 0;
            while (j < m.length) {
                tmp = GF2Field.multElem(M1[i][j], m[j]);
                B[i] = GF2Field.addElem(B[i], tmp);
                ++j;
            }
            ++i;
        }
        return B;
    }

    public short[] addVect(short[] vector1, short[] vector2) {
        if (vector1.length != vector2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[] rslt = new short[vector1.length];
        int n = 0;
        while (n < rslt.length) {
            rslt[n] = GF2Field.addElem(vector1[n], vector2[n]);
            ++n;
        }
        return rslt;
    }

    public short[][] multVects(short[] vector1, short[] vector2) {
        if (vector1.length != vector2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[][] rslt = new short[vector1.length][vector2.length];
        int i = 0;
        while (i < vector1.length) {
            int j = 0;
            while (j < vector2.length) {
                rslt[i][j] = GF2Field.multElem(vector1[i], vector2[j]);
                ++j;
            }
            ++i;
        }
        return rslt;
    }

    public short[] multVect(short scalar, short[] vector) {
        short[] rslt = new short[vector.length];
        int n = 0;
        while (n < rslt.length) {
            rslt[n] = GF2Field.multElem(scalar, vector[n]);
            ++n;
        }
        return rslt;
    }

    public short[][] multMatrix(short scalar, short[][] matrix) {
        short[][] rslt = new short[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                rslt[i][j] = GF2Field.multElem(scalar, matrix[i][j]);
                ++j;
            }
            ++i;
        }
        return rslt;
    }

    public short[][] addSquareMatrix(short[][] matrix1, short[][] matrix2) {
        if (matrix1.length != matrix2.length || matrix1[0].length != matrix2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] rslt = new short[matrix1.length][matrix1.length];
        int i = 0;
        while (i < matrix1.length) {
            int j = 0;
            while (j < matrix2.length) {
                rslt[i][j] = GF2Field.addElem(matrix1[i][j], matrix2[i][j]);
                ++j;
            }
            ++i;
        }
        return rslt;
    }
}

