/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.HT;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.PK;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.SK;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPublicKeyParameters;
import java.security.SecureRandom;

public class SPHINCSPlusKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private SPHINCSPlusParameters parameters;

    @Override
    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.parameters = ((SPHINCSPlusKeyGenerationParameters)param).getParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        SPHINCSPlusEngine engine = this.parameters.getEngine();
        SK sk = new SK(this.sec_rand(engine.N), this.sec_rand(engine.N));
        byte[] pkSeed = this.sec_rand(engine.N);
        PK pk = new PK(pkSeed, new HT((SPHINCSPlusEngine)engine, (byte[])sk.seed, (byte[])pkSeed).htPubKey);
        return new AsymmetricCipherKeyPair(new SPHINCSPlusPublicKeyParameters(this.parameters, pk), new SPHINCSPlusPrivateKeyParameters(this.parameters, sk, pk));
    }

    private byte[] sec_rand(int n) {
        byte[] rv = new byte[n];
        this.random.nextBytes(rv);
        return rv;
    }
}

