/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus;

import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.PK;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import cn.win_trust_erpc.bouncycastle.util.Arrays;

public class SPHINCSPlusPublicKeyParameters
extends SPHINCSPlusKeyParameters {
    private final PK pk;

    public SPHINCSPlusPublicKeyParameters(SPHINCSPlusParameters parameters, byte[] pkEncoded) {
        super(false, parameters);
        int n = parameters.getEngine().N;
        if (pkEncoded.length != 2 * n) {
            throw new IllegalArgumentException("public key encoding does not match parameters");
        }
        this.pk = new PK(Arrays.copyOfRange(pkEncoded, 0, n), Arrays.copyOfRange(pkEncoded, n, 2 * n));
    }

    SPHINCSPlusPublicKeyParameters(SPHINCSPlusParameters parameters, PK pk) {
        super(false, parameters);
        this.pk = pk;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.pk.seed);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.pk.root);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(this.pk.seed, this.pk.root);
    }
}

