/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.DefaultXMSSOid;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.DigestUtil;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSOid;
import cn.win_trust_erpc.bouncycastle.util.Integers;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class XMSSParameters {
    private static final Map<Integer, XMSSParameters> paramsLookupTable;
    private final XMSSOid oid;
    private final int height;
    private final int k;
    private final ASN1ObjectIdentifier treeDigestOID;
    private final int winternitzParameter;
    private final String treeDigest;
    private final int treeDigestSize;
    private final WOTSPlusParameters wotsPlusParams;

    static {
        HashMap<Integer, XMSSParameters> pMap = new HashMap<Integer, XMSSParameters>();
        pMap.put(Integers.valueOf(1), new XMSSParameters(10, NISTObjectIdentifiers.id_sha256));
        pMap.put(Integers.valueOf(2), new XMSSParameters(16, NISTObjectIdentifiers.id_sha256));
        pMap.put(Integers.valueOf(3), new XMSSParameters(20, NISTObjectIdentifiers.id_sha256));
        pMap.put(Integers.valueOf(4), new XMSSParameters(10, NISTObjectIdentifiers.id_sha512));
        pMap.put(Integers.valueOf(5), new XMSSParameters(16, NISTObjectIdentifiers.id_sha512));
        pMap.put(Integers.valueOf(6), new XMSSParameters(20, NISTObjectIdentifiers.id_sha512));
        pMap.put(Integers.valueOf(7), new XMSSParameters(10, NISTObjectIdentifiers.id_shake128));
        pMap.put(Integers.valueOf(8), new XMSSParameters(16, NISTObjectIdentifiers.id_shake128));
        pMap.put(Integers.valueOf(9), new XMSSParameters(20, NISTObjectIdentifiers.id_shake128));
        pMap.put(Integers.valueOf(10), new XMSSParameters(10, NISTObjectIdentifiers.id_shake256));
        pMap.put(Integers.valueOf(11), new XMSSParameters(16, NISTObjectIdentifiers.id_shake256));
        pMap.put(Integers.valueOf(12), new XMSSParameters(20, NISTObjectIdentifiers.id_shake256));
        paramsLookupTable = Collections.unmodifiableMap(pMap);
    }

    public XMSSParameters(int height, Digest treeDigest) {
        this(height, DigestUtil.getDigestOID(treeDigest.getAlgorithmName()));
    }

    public XMSSParameters(int height, ASN1ObjectIdentifier treeDigestOID) {
        if (height < 2) {
            throw new IllegalArgumentException("height must be >= 2");
        }
        if (treeDigestOID == null) {
            throw new NullPointerException("digest == null");
        }
        this.height = height;
        this.k = this.determineMinK();
        this.treeDigest = DigestUtil.getDigestName(treeDigestOID);
        this.treeDigestOID = treeDigestOID;
        this.wotsPlusParams = new WOTSPlusParameters(treeDigestOID);
        this.treeDigestSize = this.wotsPlusParams.getTreeDigestSize();
        this.winternitzParameter = this.wotsPlusParams.getWinternitzParameter();
        this.oid = DefaultXMSSOid.lookup(this.treeDigest, this.treeDigestSize, this.winternitzParameter, this.wotsPlusParams.getLen(), height);
    }

    private int determineMinK() {
        int k = 2;
        while (k <= this.height) {
            if ((this.height - k) % 2 == 0) {
                return k;
            }
            ++k;
        }
        throw new IllegalStateException("should never happen...");
    }

    public int getTreeDigestSize() {
        return this.treeDigestSize;
    }

    public ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigestOID;
    }

    public int getHeight() {
        return this.height;
    }

    String getTreeDigest() {
        return this.treeDigest;
    }

    int getLen() {
        return this.wotsPlusParams.getLen();
    }

    int getWinternitzParameter() {
        return this.winternitzParameter;
    }

    WOTSPlus getWOTSPlus() {
        return new WOTSPlus(this.wotsPlusParams);
    }

    XMSSOid getOid() {
        return this.oid;
    }

    int getK() {
        return this.k;
    }

    public static XMSSParameters lookupByOID(int oid) {
        return paramsLookupTable.get(Integers.valueOf(oid));
    }
}

