/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.KeyedHashFunctions;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.WOTSPlusSignature;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSNode;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSSignature;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSVerifierUtil;
import cn.win_trust_erpc.bouncycastle.util.Arrays;

public class XMSSSigner
implements StateAwareMessageSigner {
    private XMSSPrivateKeyParameters privateKey;
    private XMSSPublicKeyParameters publicKey;
    private XMSSParameters params;
    private WOTSPlus wotsPlus;
    private KeyedHashFunctions khf;
    private boolean initSign;
    private boolean hasGenerated;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.initSign = true;
            this.hasGenerated = false;
            this.privateKey = (XMSSPrivateKeyParameters)param;
            this.params = this.privateKey.getParameters();
        } else {
            this.initSign = false;
            this.publicKey = (XMSSPublicKeyParameters)param;
            this.params = this.publicKey.getParameters();
        }
        this.wotsPlus = this.params.getWOTSPlus();
        this.khf = this.wotsPlus.getKhf();
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (this.initSign) {
            if (this.privateKey == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.privateKey;
        synchronized (xMSSPrivateKeyParameters) {
            byte[] byArray;
            if (this.privateKey.getUsagesRemaining() <= 0L) {
                throw new ExhaustedPrivateKeyException("no usages of private key remaining");
            }
            if (this.privateKey.getBDSState().getAuthenticationPath().isEmpty()) {
                throw new IllegalStateException("not initialized");
            }
            try {
                int index = this.privateKey.getIndex();
                this.hasGenerated = true;
                byte[] random = this.khf.PRF(this.privateKey.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(index, 32));
                byte[] concatenated = Arrays.concatenate(random, this.privateKey.getRoot(), XMSSUtil.toBytesBigEndian(index, this.params.getTreeDigestSize()));
                byte[] messageDigest = this.khf.HMsg(concatenated, message);
                OTSHashAddress otsHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(index).build();
                WOTSPlusSignature wotsPlusSignature = this.wotsSign(messageDigest, otsHashAddress);
                byArray = new XMSSSignature.Builder(this.params).withIndex(index).withRandom(random).withWOTSPlusSignature(wotsPlusSignature).withAuthPath(this.privateKey.getBDSState().getAuthenticationPath()).build().toByteArray();
                this.privateKey.getBDSState().markUsed();
                this.privateKey.rollKey();
            }
            catch (Throwable throwable) {
                this.privateKey.getBDSState().markUsed();
                this.privateKey.rollKey();
                throw throwable;
            }
            return byArray;
        }
    }

    public long getUsagesRemaining() {
        return this.privateKey.getUsagesRemaining();
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        XMSSSignature sig = new XMSSSignature.Builder(this.params).withSignature(signature).build();
        int index = sig.getIndex();
        this.wotsPlus.importKeys(new byte[this.params.getTreeDigestSize()], this.publicKey.getPublicSeed());
        byte[] concatenated = Arrays.concatenate(sig.getRandom(), this.publicKey.getRoot(), XMSSUtil.toBytesBigEndian(index, this.params.getTreeDigestSize()));
        byte[] messageDigest = this.khf.HMsg(concatenated, message);
        int xmssHeight = this.params.getHeight();
        int indexLeaf = XMSSUtil.getLeafIndex(index, xmssHeight);
        OTSHashAddress otsHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(index).build();
        XMSSNode rootNodeFromSignature = XMSSVerifierUtil.getRootNodeFromSignature(this.wotsPlus, xmssHeight, messageDigest, sig, otsHashAddress, indexLeaf);
        return Arrays.constantTimeAreEqual(rootNodeFromSignature.getValue(), this.publicKey.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.privateKey;
        synchronized (xMSSPrivateKeyParameters) {
            if (this.hasGenerated) {
                XMSSPrivateKeyParameters privKey = this.privateKey;
                this.privateKey = null;
                return privKey;
            }
            XMSSPrivateKeyParameters privKey = this.privateKey;
            if (privKey != null) {
                this.privateKey = this.privateKey.getNextKey();
            }
            return privKey;
        }
    }

    private WOTSPlusSignature wotsSign(byte[] messageDigest, OTSHashAddress otsHashAddress) {
        if (messageDigest.length != this.params.getTreeDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (otsHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.wotsPlus.importKeys(this.wotsPlus.getWOTSPlusSecretKey(this.privateKey.getSecretKeySeed(), otsHashAddress), this.privateKey.getPublicSeed());
        return this.wotsPlus.sign(messageDigest, otsHashAddress);
    }
}

