/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.lms;

import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.interfaces.LMSKey;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;

public class BCLMSPublicKey
implements PublicKey,
LMSKey {
    private static final long serialVersionUID = -5617456225328969766L;
    private transient LMSKeyParameters keyParams;

    public BCLMSPublicKey(LMSKeyParameters keyParams) {
        this.keyParams = keyParams;
    }

    public BCLMSPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.keyParams = (LMSKeyParameters)PublicKeyFactory.createKey(keyInfo);
    }

    @Override
    public final String getAlgorithm() {
        return "LMS";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo pki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCLMSPublicKey) {
            BCLMSPublicKey otherKey = (BCLMSPublicKey)o;
            try {
                return Arrays.areEqual(this.keyParams.getEncoded(), otherKey.keyParams.getEncoded());
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public int getLevels() {
        if (this.keyParams instanceof LMSPublicKeyParameters) {
            return 1;
        }
        return ((HSSPublicKeyParameters)this.keyParams).getL();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

