/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.lms;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.CryptoServicesRegistrar;
import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSigParameters;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.lms.BCLMSPrivateKey;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.lms.BCLMSPublicKey;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.spec.LMSHSSKeyGenParameterSpec;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.spec.LMSHSSParameterSpec;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.spec.LMSKeyGenParameterSpec;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.spec.LMSParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class LMSKeyPairGeneratorSpi
extends KeyPairGenerator {
    private KeyGenerationParameters param;
    private ASN1ObjectIdentifier treeDigest;
    private AsymmetricCipherKeyPairGenerator engine = new LMSKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public LMSKeyPairGeneratorSpi() {
        super("LMS");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof LMSKeyGenParameterSpec) {
            LMSKeyGenParameterSpec lmsParams = (LMSKeyGenParameterSpec)params;
            this.param = new LMSKeyGenerationParameters(new LMSParameters(lmsParams.getSigParams(), lmsParams.getOtsParams()), random);
            this.engine = new LMSKeyPairGenerator();
            this.engine.init(this.param);
        } else if (params instanceof LMSHSSKeyGenParameterSpec) {
            LMSKeyGenParameterSpec[] lmsParams = ((LMSHSSKeyGenParameterSpec)params).getLMSSpecs();
            LMSParameters[] hssParams = new LMSParameters[lmsParams.length];
            int i = 0;
            while (i != lmsParams.length) {
                hssParams[i] = new LMSParameters(lmsParams[i].getSigParams(), lmsParams[i].getOtsParams());
                ++i;
            }
            this.param = new HSSKeyGenerationParameters(hssParams, random);
            this.engine = new HSSKeyPairGenerator();
            this.engine.init(this.param);
        } else if (params instanceof LMSParameterSpec) {
            LMSParameterSpec lmsParams = (LMSParameterSpec)params;
            this.param = new LMSKeyGenerationParameters(new LMSParameters(lmsParams.getSigParams(), lmsParams.getOtsParams()), random);
            this.engine = new LMSKeyPairGenerator();
            this.engine.init(this.param);
        } else if (params instanceof LMSHSSParameterSpec) {
            LMSParameterSpec[] lmsParams = ((LMSHSSParameterSpec)params).getLMSSpecs();
            LMSParameters[] hssParams = new LMSParameters[lmsParams.length];
            int i = 0;
            while (i != lmsParams.length) {
                hssParams[i] = new LMSParameters(lmsParams[i].getSigParams(), lmsParams[i].getOtsParams());
                ++i;
            }
            this.param = new HSSKeyGenerationParameters(hssParams, random);
            this.engine = new HSSKeyPairGenerator();
            this.engine.init(this.param);
        } else {
            throw new InvalidAlgorithmParameterException("parameter object not a LMSParameterSpec/LMSHSSParameterSpec");
        }
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new LMSKeyGenerationParameters(new LMSParameters(LMSigParameters.lms_sha256_n32_h10, LMOtsParameters.sha256_n32_w2), this.random);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        if (this.engine instanceof LMSKeyPairGenerator) {
            LMSPublicKeyParameters pub = (LMSPublicKeyParameters)pair.getPublic();
            LMSPrivateKeyParameters priv = (LMSPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new BCLMSPublicKey(pub), new BCLMSPrivateKey(priv));
        }
        HSSPublicKeyParameters pub = (HSSPublicKeyParameters)pair.getPublic();
        HSSPrivateKeyParameters priv = (HSSPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCLMSPublicKey(pub), new BCLMSPrivateKey(priv));
    }
}

