/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra;

import cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra.GF2mField;
import cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra.IntUtils;
import cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra.Matrix;
import cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra.Permutation;
import cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mMatrix
extends Matrix {
    protected GF2mField field;
    protected int[][] matrix;

    public GF2mMatrix(GF2mField field, byte[] enc) {
        this.field = field;
        int d = 8;
        int count = 1;
        while (field.getDegree() > d) {
            ++count;
            d += 8;
        }
        if (enc.length < 5) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numRows = (enc[3] & 0xFF) << 24 ^ (enc[2] & 0xFF) << 16 ^ (enc[1] & 0xFF) << 8 ^ enc[0] & 0xFF;
        int n = count * this.numRows;
        if (this.numRows <= 0 || (enc.length - 4) % n != 0) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numColumns = (enc.length - 4) / n;
        this.matrix = new int[this.numRows][this.numColumns];
        count = 4;
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                int jj = 0;
                while (jj < d) {
                    int[] nArray = this.matrix[i];
                    int n2 = j;
                    nArray[n2] = nArray[n2] ^ (enc[count++] & 0xFF) << jj;
                    jj += 8;
                }
                if (!this.field.isElementOfThisField(this.matrix[i][j])) {
                    throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
                }
                ++j;
            }
            ++i;
        }
    }

    public GF2mMatrix(GF2mMatrix other) {
        this.numRows = other.numRows;
        this.numColumns = other.numColumns;
        this.field = other.field;
        this.matrix = new int[this.numRows][];
        int i = 0;
        while (i < this.numRows) {
            this.matrix[i] = IntUtils.clone(other.matrix[i]);
            ++i;
        }
    }

    protected GF2mMatrix(GF2mField field, int[][] matrix) {
        this.field = field;
        this.matrix = matrix;
        this.numRows = matrix.length;
        this.numColumns = matrix[0].length;
    }

    @Override
    public byte[] getEncoded() {
        int d = 8;
        int count = 1;
        while (this.field.getDegree() > d) {
            ++count;
            d += 8;
        }
        byte[] bf = new byte[this.numRows * this.numColumns * count + 4];
        bf[0] = (byte)(this.numRows & 0xFF);
        bf[1] = (byte)(this.numRows >>> 8 & 0xFF);
        bf[2] = (byte)(this.numRows >>> 16 & 0xFF);
        bf[3] = (byte)(this.numRows >>> 24 & 0xFF);
        count = 4;
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                int jj = 0;
                while (jj < d) {
                    bf[count++] = (byte)(this.matrix[i][j] >>> jj);
                    jj += 8;
                }
                ++j;
            }
            ++i;
        }
        return bf;
    }

    @Override
    public boolean isZero() {
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                if (this.matrix[i][j] != 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Matrix computeInverse() {
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] tmpMatrix = new int[this.numRows][this.numRows];
        int i = this.numRows - 1;
        while (i >= 0) {
            tmpMatrix[i] = IntUtils.clone(this.matrix[i]);
            --i;
        }
        int[][] invMatrix = new int[this.numRows][this.numRows];
        int i2 = this.numRows - 1;
        while (i2 >= 0) {
            invMatrix[i2][i2] = 1;
            --i2;
        }
        i2 = 0;
        while (i2 < this.numRows) {
            if (tmpMatrix[i2][i2] == 0) {
                boolean foundNonZero = false;
                int j = i2 + 1;
                while (j < this.numRows) {
                    if (tmpMatrix[j][i2] != 0) {
                        foundNonZero = true;
                        GF2mMatrix.swapColumns(tmpMatrix, i2, j);
                        GF2mMatrix.swapColumns(invMatrix, i2, j);
                        j = this.numRows;
                    }
                    ++j;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            int coef = tmpMatrix[i2][i2];
            int invCoef = this.field.inverse(coef);
            this.multRowWithElementThis(tmpMatrix[i2], invCoef);
            this.multRowWithElementThis(invMatrix[i2], invCoef);
            int j = 0;
            while (j < this.numRows) {
                if (j != i2 && (coef = tmpMatrix[j][i2]) != 0) {
                    int[] tmpRow = this.multRowWithElement(tmpMatrix[i2], coef);
                    int[] tmpInvRow = this.multRowWithElement(invMatrix[i2], coef);
                    this.addToRow(tmpRow, tmpMatrix[j]);
                    this.addToRow(tmpInvRow, invMatrix[j]);
                }
                ++j;
            }
            ++i2;
        }
        return new GF2mMatrix(this.field, invMatrix);
    }

    private static void swapColumns(int[][] matrix, int first, int second) {
        int[] tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }

    private void multRowWithElementThis(int[] row, int element) {
        int i = row.length - 1;
        while (i >= 0) {
            row[i] = this.field.mult(row[i], element);
            --i;
        }
    }

    private int[] multRowWithElement(int[] row, int element) {
        int[] result = new int[row.length];
        int i = row.length - 1;
        while (i >= 0) {
            result[i] = this.field.mult(row[i], element);
            --i;
        }
        return result;
    }

    private void addToRow(int[] fromRow, int[] toRow) {
        int i = toRow.length - 1;
        while (i >= 0) {
            toRow[i] = this.field.add(fromRow[i], toRow[i]);
            --i;
        }
    }

    @Override
    public Matrix rightMultiply(Matrix a) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Matrix rightMultiply(Permutation perm) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector leftMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector rightMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2mMatrix)) {
            return false;
        }
        GF2mMatrix otherMatrix = (GF2mMatrix)other;
        if (!this.field.equals(otherMatrix.field) || otherMatrix.numRows != this.numColumns || otherMatrix.numColumns != this.numColumns) {
            return false;
        }
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                if (this.matrix[i][j] != otherMatrix.matrix[i][j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = (this.field.hashCode() * 31 + this.numRows) * 31 + this.numColumns;
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                hash = hash * 31 + this.matrix[i][j];
                ++j;
            }
            ++i;
        }
        return hash;
    }

    @Override
    public String toString() {
        String str = String.valueOf(this.numRows) + " x " + this.numColumns + " Matrix over " + this.field.toString() + ": \n";
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                str = String.valueOf(str) + this.field.elementToStr(this.matrix[i][j]) + " : ";
                ++j;
            }
            str = String.valueOf(str) + "\n";
            ++i;
        }
        return str;
    }
}

