/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra;

import cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra.GF2mField;
import cn.win_trust_erpc.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class PolynomialRingGF2m {
    private GF2mField field;
    private PolynomialGF2mSmallM p;
    protected PolynomialGF2mSmallM[] sqMatrix;
    protected PolynomialGF2mSmallM[] sqRootMatrix;

    public PolynomialRingGF2m(GF2mField field, PolynomialGF2mSmallM p) {
        this.field = field;
        this.p = p;
        this.computeSquaringMatrix();
        this.computeSquareRootMatrix();
    }

    public PolynomialGF2mSmallM[] getSquaringMatrix() {
        return this.sqMatrix;
    }

    public PolynomialGF2mSmallM[] getSquareRootMatrix() {
        return this.sqRootMatrix;
    }

    private void computeSquaringMatrix() {
        int[] monomCoeffs;
        int numColumns = this.p.getDegree();
        this.sqMatrix = new PolynomialGF2mSmallM[numColumns];
        int i = 0;
        while (i < numColumns >> 1) {
            monomCoeffs = new int[(i << 1) + 1];
            monomCoeffs[i << 1] = 1;
            this.sqMatrix[i] = new PolynomialGF2mSmallM(this.field, monomCoeffs);
            ++i;
        }
        i = numColumns >> 1;
        while (i < numColumns) {
            monomCoeffs = new int[(i << 1) + 1];
            monomCoeffs[i << 1] = 1;
            PolynomialGF2mSmallM monomial = new PolynomialGF2mSmallM(this.field, monomCoeffs);
            this.sqMatrix[i] = monomial.mod(this.p);
            ++i;
        }
    }

    private void computeSquareRootMatrix() {
        int numColumns = this.p.getDegree();
        PolynomialGF2mSmallM[] tmpMatrix = new PolynomialGF2mSmallM[numColumns];
        int i = numColumns - 1;
        while (i >= 0) {
            tmpMatrix[i] = new PolynomialGF2mSmallM(this.sqMatrix[i]);
            --i;
        }
        this.sqRootMatrix = new PolynomialGF2mSmallM[numColumns];
        i = numColumns - 1;
        while (i >= 0) {
            this.sqRootMatrix[i] = new PolynomialGF2mSmallM(this.field, i);
            --i;
        }
        i = 0;
        while (i < numColumns) {
            if (tmpMatrix[i].getCoefficient(i) == 0) {
                boolean foundNonZero = false;
                int j = i + 1;
                while (j < numColumns) {
                    if (tmpMatrix[j].getCoefficient(i) != 0) {
                        foundNonZero = true;
                        PolynomialRingGF2m.swapColumns(tmpMatrix, i, j);
                        PolynomialRingGF2m.swapColumns(this.sqRootMatrix, i, j);
                        j = numColumns;
                    }
                    ++j;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Squaring matrix is not invertible.");
                }
            }
            int coef = tmpMatrix[i].getCoefficient(i);
            int invCoef = this.field.inverse(coef);
            tmpMatrix[i].multThisWithElement(invCoef);
            this.sqRootMatrix[i].multThisWithElement(invCoef);
            int j = 0;
            while (j < numColumns) {
                if (j != i && (coef = tmpMatrix[j].getCoefficient(i)) != 0) {
                    PolynomialGF2mSmallM tmpSqColumn = tmpMatrix[i].multWithElement(coef);
                    PolynomialGF2mSmallM tmpInvColumn = this.sqRootMatrix[i].multWithElement(coef);
                    tmpMatrix[j].addToThis(tmpSqColumn);
                    this.sqRootMatrix[j].addToThis(tmpInvColumn);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void swapColumns(PolynomialGF2mSmallM[] matrix, int first, int second) {
        PolynomialGF2mSmallM tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }
}

