/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.AbstractTlsPeer;
import cn.win_trust_erpc.bouncycastle.tls.CertificateStatusRequest;
import cn.win_trust_erpc.bouncycastle.tls.DefaultTlsDHGroupVerifier;
import cn.win_trust_erpc.bouncycastle.tls.DefaultTlsSRPConfigVerifier;
import cn.win_trust_erpc.bouncycastle.tls.NewSessionTicket;
import cn.win_trust_erpc.bouncycastle.tls.OCSPStatusRequest;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsClient;
import cn.win_trust_erpc.bouncycastle.tls.TlsClientContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsDHGroupVerifier;
import cn.win_trust_erpc.bouncycastle.tls.TlsECCUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsExtensionsUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsPSK;
import cn.win_trust_erpc.bouncycastle.tls.TlsPSKIdentity;
import cn.win_trust_erpc.bouncycastle.tls.TlsSRPConfigVerifier;
import cn.win_trust_erpc.bouncycastle.tls.TlsSRPIdentity;
import cn.win_trust_erpc.bouncycastle.tls.TlsSession;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.util.Integers;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsClientContext context;
    protected ProtocolVersion[] protocolVersions;
    protected int[] cipherSuites;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;
    protected Vector supportedSignatureAlgorithmsCert;

    public AbstractTlsClient(TlsCrypto crypto) {
        super(crypto);
    }

    protected boolean allowUnexpectedServerExtension(Integer extensionType, byte[] extensionData) throws IOException {
        switch (extensionType) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(extensionData);
                return true;
            }
            case 11: {
                TlsExtensionsUtils.readSupportedPointFormatsExtension(extensionData);
                return true;
            }
        }
        return false;
    }

    protected Vector getNamedGroupRoles() {
        Vector namedGroupRoles = TlsUtils.getNamedGroupRoles(this.getCipherSuites());
        Vector sigAlgs = this.supportedSignatureAlgorithms;
        Vector sigAlgsCert = this.supportedSignatureAlgorithmsCert;
        if (sigAlgs == null || TlsUtils.containsAnySignatureAlgorithm(sigAlgs, (short)3) || sigAlgsCert != null && TlsUtils.containsAnySignatureAlgorithm(sigAlgsCert, (short)3)) {
            TlsUtils.addToSet(namedGroupRoles, 3);
        }
        return namedGroupRoles;
    }

    protected void checkForUnexpectedServerExtension(Hashtable serverExtensions, Integer extensionType) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(serverExtensions, extensionType);
        if (extensionData != null && !this.allowUnexpectedServerExtension(extensionType, extensionData)) {
            throw new TlsFatalAlert(47);
        }
    }

    @Override
    public TlsPSKIdentity getPSKIdentity() throws IOException {
        return null;
    }

    @Override
    public TlsSRPIdentity getSRPIdentity() throws IOException {
        return null;
    }

    @Override
    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new DefaultTlsDHGroupVerifier();
    }

    @Override
    public TlsSRPConfigVerifier getSRPConfigVerifier() {
        return new DefaultTlsSRPConfigVerifier();
    }

    protected Vector getCertificateAuthorities() {
        return null;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getMultiCertStatusRequest() {
        return null;
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected Vector getSupportedGroups(Vector namedGroupRoles) {
        TlsCrypto crypto = this.getCrypto();
        Vector supportedGroups = new Vector();
        if (namedGroupRoles.contains(Integers.valueOf(2))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, new int[]{29, 30});
        }
        if (namedGroupRoles.contains(Integers.valueOf(2)) || namedGroupRoles.contains(Integers.valueOf(3))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, new int[]{23, 24});
        }
        if (namedGroupRoles.contains(Integers.valueOf(1))) {
            TlsUtils.addIfSupported(supportedGroups, crypto, new int[]{256, 257, 258});
        }
        return supportedGroups;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    protected Vector getSupportedSignatureAlgorithmsCert() {
        return null;
    }

    protected Vector getTrustedCAIndication() {
        return null;
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
        this.protocolVersions = this.getSupportedVersions();
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public ProtocolVersion[] getProtocolVersions() {
        return this.protocolVersions;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.supportedGroups = null;
        this.supportedSignatureAlgorithms = null;
        this.supportedSignatureAlgorithmsCert = null;
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public Vector getExternalPSKs() {
        return null;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Vector namedGroupRoles;
        Vector supportedGroups;
        ProtocolVersion clientVersion;
        Vector certificateAuthorities;
        CertificateStatusRequest statusRequest;
        Vector sniServerNames;
        Hashtable clientExtensions = new Hashtable();
        boolean offeringTLSv13Plus = false;
        boolean offeringPreTLSv13 = false;
        ProtocolVersion[] supportedVersions = this.getProtocolVersions();
        int i = 0;
        while (i < supportedVersions.length) {
            if (TlsUtils.isTLSv13(supportedVersions[i])) {
                offeringTLSv13Plus = true;
            } else {
                offeringPreTLSv13 = true;
            }
            ++i;
        }
        Vector protocolNames = this.getProtocolNames();
        if (protocolNames != null) {
            TlsExtensionsUtils.addALPNExtensionClient(clientExtensions, protocolNames);
        }
        if ((sniServerNames = this.getSNIServerNames()) != null) {
            TlsExtensionsUtils.addServerNameExtensionClient(clientExtensions, sniServerNames);
        }
        if ((statusRequest = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(clientExtensions, statusRequest);
        }
        if (offeringTLSv13Plus && (certificateAuthorities = this.getCertificateAuthorities()) != null) {
            TlsExtensionsUtils.addCertificateAuthoritiesExtension(clientExtensions, certificateAuthorities);
        }
        if (offeringPreTLSv13) {
            Vector trustedCAKeys;
            TlsExtensionsUtils.addEncryptThenMACExtension(clientExtensions);
            Vector statusRequestV2 = this.getMultiCertStatusRequest();
            if (statusRequestV2 != null) {
                TlsExtensionsUtils.addStatusRequestV2Extension(clientExtensions, statusRequestV2);
            }
            if ((trustedCAKeys = this.getTrustedCAIndication()) != null) {
                TlsExtensionsUtils.addTrustedCAKeysExtensionClient(clientExtensions, trustedCAKeys);
            }
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion = this.context.getClientVersion())) {
            Vector supportedSigAlgsCert;
            Vector supportedSigAlgs = this.getSupportedSignatureAlgorithms();
            if (supportedSigAlgs != null && !supportedSigAlgs.isEmpty()) {
                this.supportedSignatureAlgorithms = supportedSigAlgs;
                TlsExtensionsUtils.addSignatureAlgorithmsExtension(clientExtensions, supportedSigAlgs);
            }
            if ((supportedSigAlgsCert = this.getSupportedSignatureAlgorithmsCert()) != null && !supportedSigAlgsCert.isEmpty()) {
                this.supportedSignatureAlgorithmsCert = supportedSigAlgsCert;
                TlsExtensionsUtils.addSignatureAlgorithmsCertExtension(clientExtensions, supportedSigAlgsCert);
            }
        }
        if ((supportedGroups = this.getSupportedGroups(namedGroupRoles = this.getNamedGroupRoles())) != null && !supportedGroups.isEmpty()) {
            this.supportedGroups = supportedGroups;
            TlsExtensionsUtils.addSupportedGroupsExtension(clientExtensions, supportedGroups);
        }
        if (offeringPreTLSv13 && (namedGroupRoles.contains(Integers.valueOf(2)) || namedGroupRoles.contains(Integers.valueOf(3)))) {
            TlsExtensionsUtils.addSupportedPointFormatsExtension(clientExtensions, new short[1]);
        }
        return clientExtensions;
    }

    @Override
    public Vector getEarlyKeyShareGroups() {
        if (this.supportedGroups == null || this.supportedGroups.isEmpty()) {
            return null;
        }
        if (this.supportedGroups.contains(Integers.valueOf(29))) {
            return TlsUtils.vectorOfOne(Integers.valueOf(29));
        }
        if (this.supportedGroups.contains(Integers.valueOf(23))) {
            return TlsUtils.vectorOfOne(Integers.valueOf(23));
        }
        return TlsUtils.vectorOfOne(this.supportedGroups.elementAt(0));
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
    }

    @Override
    public void notifySessionToResume(TlsSession session) {
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
    }

    @Override
    public void notifySelectedPSK(TlsPSK selectedPSK) throws IOException {
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (serverExtensions == null) {
            return;
        }
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        boolean isTLSv13 = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        if (!isTLSv13) {
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_signature_algorithms_cert);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_supported_groups);
            int selectedCipherSuite = securityParameters.getCipherSuite();
            if (TlsECCUtils.isECCCipherSuite(selectedCipherSuite)) {
                TlsExtensionsUtils.getSupportedPointFormatsExtension(serverExtensions);
            } else {
                this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_padding);
        }
    }

    @Override
    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

