/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ocsp.OCSPResponse;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CertificateStatus {
    protected short statusType;
    protected Object response;

    public CertificateStatus(short statusType, Object response) {
        if (!CertificateStatus.isCorrectType(statusType, response)) {
            throw new IllegalArgumentException("'response' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.response = response;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getResponse() {
        return this.response;
    }

    public OCSPResponse getOCSPResponse() {
        if (!CertificateStatus.isCorrectType((short)1, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponse");
        }
        return (OCSPResponse)this.response;
    }

    public Vector getOCSPResponseList() {
        if (!CertificateStatus.isCorrectType((short)2, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponseList");
        }
        return (Vector)this.response;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        switch (this.statusType) {
            case 1: {
                OCSPResponse ocspResponse = (OCSPResponse)this.response;
                byte[] derEncoding = ocspResponse.getEncoded("DER");
                TlsUtils.writeOpaque24(derEncoding, output);
                break;
            }
            case 2: {
                Vector ocspResponseList = (Vector)this.response;
                int count = ocspResponseList.size();
                Vector<byte[]> derEncodings = new Vector<byte[]>(count);
                long totalLength = 0L;
                int i = 0;
                while (i < count) {
                    OCSPResponse ocspResponse = (OCSPResponse)ocspResponseList.elementAt(i);
                    if (ocspResponse == null) {
                        derEncodings.addElement(TlsUtils.EMPTY_BYTES);
                    } else {
                        byte[] derEncoding = ocspResponse.getEncoded("DER");
                        derEncodings.addElement(derEncoding);
                        totalLength += (long)derEncoding.length;
                    }
                    totalLength += 3L;
                    ++i;
                }
                TlsUtils.checkUint24(totalLength);
                TlsUtils.writeUint24((int)totalLength, output);
                i = 0;
                while (i < count) {
                    byte[] derEncoding = (byte[])derEncodings.elementAt(i);
                    TlsUtils.writeOpaque24(derEncoding, output);
                    ++i;
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static CertificateStatus parse(TlsContext context, InputStream input) throws IOException {
        Object response;
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        Certificate peerCertificate = securityParameters.getPeerCertificate();
        if (peerCertificate == null || peerCertificate.isEmpty() || peerCertificate.getCertificateType() != 0) {
            throw new TlsFatalAlert(80);
        }
        int certificateCount = peerCertificate.getLength();
        int statusRequestVersion = securityParameters.getStatusRequestVersion();
        short status_type = TlsUtils.readUint8(input);
        switch (status_type) {
            case 1: {
                CertificateStatus.requireStatusRequestVersion(1, statusRequestVersion);
                byte[] derEncoding = TlsUtils.readOpaque24(input, 1);
                response = CertificateStatus.parseOCSPResponse(derEncoding);
                break;
            }
            case 2: {
                CertificateStatus.requireStatusRequestVersion(2, statusRequestVersion);
                byte[] ocsp_response_list = TlsUtils.readOpaque24(input, 1);
                ByteArrayInputStream buf = new ByteArrayInputStream(ocsp_response_list);
                Vector<OCSPResponse> ocspResponseList = new Vector<OCSPResponse>();
                while (buf.available() > 0) {
                    if (ocspResponseList.size() >= certificateCount) {
                        throw new TlsFatalAlert(47);
                    }
                    int length = TlsUtils.readUint24(buf);
                    if (length < 1) {
                        ocspResponseList.addElement(null);
                        continue;
                    }
                    byte[] derEncoding = TlsUtils.readFully(length, (InputStream)buf);
                    ocspResponseList.addElement(CertificateStatus.parseOCSPResponse(derEncoding));
                }
                ocspResponseList.trimToSize();
                response = ocspResponseList;
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new CertificateStatus(status_type, response);
    }

    protected static boolean isCorrectType(short statusType, Object response) {
        switch (statusType) {
            case 1: {
                return response instanceof OCSPResponse;
            }
            case 2: {
                return CertificateStatus.isOCSPResponseList(response);
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }

    protected static boolean isOCSPResponseList(Object response) {
        if (!(response instanceof Vector)) {
            return false;
        }
        Vector v = (Vector)response;
        int count = v.size();
        if (count < 1) {
            return false;
        }
        int i = 0;
        while (i < count) {
            Object e = v.elementAt(i);
            if (e != null && !(e instanceof OCSPResponse)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static OCSPResponse parseOCSPResponse(byte[] derEncoding) throws IOException {
        ASN1Primitive asn1 = TlsUtils.readASN1Object(derEncoding);
        OCSPResponse ocspResponse = OCSPResponse.getInstance(asn1);
        TlsUtils.requireDEREncoding(ocspResponse, derEncoding);
        return ocspResponse;
    }

    protected static void requireStatusRequestVersion(int minVersion, int statusRequestVersion) throws IOException {
        if (statusRequestVersion < minVersion) {
            throw new TlsFatalAlert(50);
        }
    }
}

