/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.SSL3Utils;
import cn.win_trust_erpc.bouncycastle.tls.TlsContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHash;
import cn.win_trust_erpc.bouncycastle.util.Arrays;

public class CombinedHash
implements TlsHash {
    protected TlsContext context;
    protected TlsCrypto crypto;
    protected TlsHash md5;
    protected TlsHash sha1;

    CombinedHash(TlsContext context, TlsHash md5, TlsHash sha1) {
        this.context = context;
        this.crypto = context.getCrypto();
        this.md5 = md5;
        this.sha1 = sha1;
    }

    public CombinedHash(TlsCrypto crypto) {
        this.crypto = crypto;
        this.md5 = crypto.createHash(1);
        this.sha1 = crypto.createHash(2);
    }

    public CombinedHash(CombinedHash t) {
        this.context = t.context;
        this.crypto = t.crypto;
        this.md5 = t.md5.cloneHash();
        this.sha1 = t.sha1.cloneHash();
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        this.md5.update(input, inOff, len);
        this.sha1.update(input, inOff, len);
    }

    @Override
    public byte[] calculateHash() {
        if (this.context != null && TlsUtils.isSSL(this.context)) {
            SSL3Utils.completeCombinedHash(this.context, this.md5, this.sha1);
        }
        return Arrays.concatenate(this.md5.calculateHash(), this.sha1.calculateHash());
    }

    @Override
    public TlsHash cloneHash() {
        return new CombinedHash(this);
    }

    @Override
    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }
}

