/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.DTLSRecordLayer;
import cn.win_trust_erpc.bouncycastle.tls.DatagramTransport;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import java.io.IOException;
import java.io.InterruptedIOException;

public class DTLSTransport
implements DatagramTransport {
    private final DTLSRecordLayer recordLayer;

    DTLSTransport(DTLSRecordLayer recordLayer) {
        this.recordLayer = recordLayer;
    }

    @Override
    public int getReceiveLimit() throws IOException {
        return this.recordLayer.getReceiveLimit();
    }

    @Override
    public int getSendLimit() throws IOException {
        return this.recordLayer.getSendLimit();
    }

    @Override
    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        if (buf == null) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (off < 0 || off >= buf.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + off);
        }
        if (len < 0 || len > buf.length - off) {
            throw new IllegalArgumentException("'len' is an invalid length: " + len);
        }
        if (waitMillis < 0) {
            throw new IllegalArgumentException("'waitMillis' cannot be negative");
        }
        try {
            return this.recordLayer.receive(buf, off, len, waitMillis);
        }
        catch (TlsFatalAlert fatalAlert) {
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public void send(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException("'buf' cannot be null");
        }
        if (off < 0 || off >= buf.length) {
            throw new IllegalArgumentException("'off' is an invalid offset: " + off);
        }
        if (len < 0 || len > buf.length - off) {
            throw new IllegalArgumentException("'len' is an invalid length: " + len);
        }
        try {
            this.recordLayer.send(buf, off, len);
        }
        catch (TlsFatalAlert fatalAlert) {
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.recordLayer.close();
    }
}

