/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.DTLSReliableHandshake;
import cn.win_trust_erpc.bouncycastle.tls.DTLSRequest;
import cn.win_trust_erpc.bouncycastle.tls.DatagramSender;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHMAC;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsMAC;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsMACOutputStream;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;

public class DTLSVerifier {
    private final TlsMAC cookieMAC;
    private final TlsMACOutputStream cookieMACOutputStream;

    private static TlsMAC createCookieMAC(TlsCrypto crypto) {
        TlsHMAC mac = crypto.createHMAC(3);
        byte[] secret = new byte[mac.getMacLength()];
        crypto.getSecureRandom().nextBytes(secret);
        mac.setKey(secret, 0, secret.length);
        return mac;
    }

    public DTLSVerifier(TlsCrypto crypto) {
        this.cookieMAC = DTLSVerifier.createCookieMAC(crypto);
        this.cookieMACOutputStream = new TlsMACOutputStream(this.cookieMAC);
    }

    public synchronized DTLSRequest verifyRequest(byte[] clientID, byte[] data, int dataOff, int dataLen, DatagramSender sender) {
        block8: {
            boolean resetCookieMAC = true;
            try {
                this.cookieMAC.update(clientID, 0, clientID.length);
                DTLSRequest request = DTLSReliableHandshake.readClientRequest(data, dataOff, dataLen, this.cookieMACOutputStream);
                if (request == null) break block8;
                byte[] expectedCookie = this.cookieMAC.calculateMAC();
                resetCookieMAC = false;
                if (Arrays.constantTimeAreEqual(expectedCookie, request.getClientHello().getCookie())) {
                    DTLSRequest dTLSRequest = request;
                    return dTLSRequest;
                }
                try {
                    DTLSReliableHandshake.sendHelloVerifyRequest(sender, request.getRecordSeq(), expectedCookie);
                }
                catch (IOException iOException) {}
            }
            finally {
                if (resetCookieMAC) {
                    this.cookieMAC.reset();
                }
            }
        }
        return null;
    }
}

