/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.PskIdentity;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsHandshakeHash;
import cn.win_trust_erpc.bouncycastle.tls.TlsPSK;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHash;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHashOutputStream;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class OfferedPsks {
    protected final Vector identities;
    protected final Vector binders;
    protected final int bindersSize;

    public OfferedPsks(Vector identities) {
        this(identities, null, -1);
    }

    private OfferedPsks(Vector identities, Vector binders, int bindersSize) {
        if (identities == null || identities.isEmpty()) {
            throw new IllegalArgumentException("'identities' cannot be null or empty");
        }
        if (binders != null && identities.size() != binders.size()) {
            throw new IllegalArgumentException("'binders' must be the same length as 'identities' (or null)");
        }
        if (binders != null != bindersSize >= 0) {
            throw new IllegalArgumentException("'bindersSize' must be >= 0 iff 'binders' are present");
        }
        this.identities = identities;
        this.binders = binders;
        this.bindersSize = bindersSize;
    }

    public Vector getBinders() {
        return this.binders;
    }

    public int getBindersSize() {
        return this.bindersSize;
    }

    public Vector getIdentities() {
        return this.identities;
    }

    public int getIndexOfIdentity(PskIdentity pskIdentity) {
        int i = 0;
        int count = this.identities.size();
        while (i < count) {
            if (pskIdentity.equals(this.identities.elementAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void encode(OutputStream output) throws IOException {
        PskIdentity identity;
        int lengthOfIdentitiesList = 0;
        int i = 0;
        while (i < this.identities.size()) {
            identity = (PskIdentity)this.identities.elementAt(i);
            lengthOfIdentitiesList += identity.getEncodedLength();
            ++i;
        }
        TlsUtils.checkUint16(lengthOfIdentitiesList);
        TlsUtils.writeUint16(lengthOfIdentitiesList, output);
        i = 0;
        while (i < this.identities.size()) {
            identity = (PskIdentity)this.identities.elementAt(i);
            identity.encode(output);
            ++i;
        }
        if (this.binders != null) {
            byte[] binder;
            int lengthOfBindersList = 0;
            i = 0;
            while (i < this.binders.size()) {
                binder = (byte[])this.binders.elementAt(i);
                lengthOfBindersList += 1 + binder.length;
                ++i;
            }
            TlsUtils.checkUint16(lengthOfBindersList);
            TlsUtils.writeUint16(lengthOfBindersList, output);
            i = 0;
            while (i < this.binders.size()) {
                binder = (byte[])this.binders.elementAt(i);
                TlsUtils.writeOpaque8(binder, output);
                ++i;
            }
        }
    }

    static void encodeBinders(OutputStream output, TlsCrypto crypto, TlsHandshakeHash handshakeHash, BindersConfig bindersConfig) throws IOException {
        TlsPSK[] psks = bindersConfig.psks;
        TlsSecret[] earlySecrets = bindersConfig.earlySecrets;
        int expectedLengthOfBindersList = bindersConfig.bindersSize - 2;
        TlsUtils.checkUint16(expectedLengthOfBindersList);
        TlsUtils.writeUint16(expectedLengthOfBindersList, output);
        int lengthOfBindersList = 0;
        int i = 0;
        while (i < psks.length) {
            TlsPSK psk = psks[i];
            TlsSecret earlySecret = earlySecrets[i];
            boolean isExternalPSK = true;
            int pskCryptoHashAlgorithm = TlsCryptoUtils.getHashForPRF(psk.getPRFAlgorithm());
            TlsHash hash = crypto.createHash(pskCryptoHashAlgorithm);
            handshakeHash.copyBufferTo(new TlsHashOutputStream(hash));
            byte[] transcriptHash = hash.calculateHash();
            byte[] binder = TlsUtils.calculatePSKBinder(crypto, isExternalPSK, pskCryptoHashAlgorithm, earlySecret, transcriptHash);
            lengthOfBindersList += 1 + binder.length;
            TlsUtils.writeOpaque8(binder, output);
            ++i;
        }
        if (expectedLengthOfBindersList != lengthOfBindersList) {
            throw new TlsFatalAlert(80);
        }
    }

    static int getBindersSize(TlsPSK[] psks) throws IOException {
        int lengthOfBindersList = 0;
        int i = 0;
        while (i < psks.length) {
            TlsPSK psk = psks[i];
            int prfAlgorithm = psk.getPRFAlgorithm();
            int prfCryptoHashAlgorithm = TlsCryptoUtils.getHashForPRF(prfAlgorithm);
            lengthOfBindersList += 1 + TlsCryptoUtils.getHashOutputSize(prfCryptoHashAlgorithm);
            ++i;
        }
        TlsUtils.checkUint16(lengthOfBindersList);
        return 2 + lengthOfBindersList;
    }

    public static OfferedPsks parse(InputStream input) throws IOException {
        Vector<PskIdentity> identities = new Vector<PskIdentity>();
        int totalLengthIdentities = TlsUtils.readUint16(input);
        if (totalLengthIdentities < 7) {
            throw new TlsFatalAlert(50);
        }
        byte[] identitiesData = TlsUtils.readFully(totalLengthIdentities, input);
        ByteArrayInputStream buf = new ByteArrayInputStream(identitiesData);
        do {
            PskIdentity identity = PskIdentity.parse(buf);
            identities.add(identity);
        } while (buf.available() > 0);
        Vector<byte[]> binders = new Vector<byte[]>();
        int totalLengthBinders = TlsUtils.readUint16(input);
        if (totalLengthBinders < 33) {
            throw new TlsFatalAlert(50);
        }
        byte[] bindersData = TlsUtils.readFully(totalLengthBinders, input);
        ByteArrayInputStream buf2 = new ByteArrayInputStream(bindersData);
        do {
            byte[] binder = TlsUtils.readOpaque8(buf2, 32);
            binders.add(binder);
        } while (buf2.available() > 0);
        return new OfferedPsks(identities, binders, 2 + totalLengthBinders);
    }

    static class BindersConfig {
        final TlsPSK[] psks;
        final short[] pskKeyExchangeModes;
        final TlsSecret[] earlySecrets;
        final int bindersSize;

        BindersConfig(TlsPSK[] psks, short[] pskKeyExchangeModes, TlsSecret[] earlySecrets, int bindersSize) {
            this.psks = psks;
            this.pskKeyExchangeModes = pskKeyExchangeModes;
            this.earlySecrets = earlySecrets;
            this.bindersSize = bindersSize;
        }
    }

    static class SelectedConfig {
        final int index;
        final TlsPSK psk;
        final short[] pskKeyExchangeModes;
        final TlsSecret earlySecret;

        SelectedConfig(int index, TlsPSK psk, short[] pskKeyExchangeModes, TlsSecret earlySecret) {
            this.index = index;
            this.psk = psk;
            this.pskKeyExchangeModes = pskKeyExchangeModes;
            this.earlySecret = earlySecret;
        }
    }
}

