/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.AbstractTlsClient;
import cn.win_trust_erpc.bouncycastle.tls.BasicTlsPSKIdentity;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.TlsAuthentication;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsPSKIdentity;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsCrypto crypto, byte[] identity, byte[] psk) {
        this(crypto, new BasicTlsPSKIdentity(identity, psk));
    }

    public PSKTlsClient(TlsCrypto crypto, TlsPSKIdentity pskIdentity) {
        super(crypto);
        this.pskIdentity = pskIdentity;
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.downTo(ProtocolVersion.TLSv10);
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    @Override
    public TlsPSKIdentity getPSKIdentity() {
        return this.pskIdentity;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }
}

