/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.AbstractTlsKeyExchange;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.DigestInputBuffer;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedSigner;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentials;
import cn.win_trust_erpc.bouncycastle.tls.TlsDHGroupVerifier;
import cn.win_trust_erpc.bouncycastle.tls.TlsDHUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsAgreement;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsDHConfig;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsDHEKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHGroupVerifier dhGroupVerifier;
    protected TlsDHConfig dhConfig;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsCertificate serverCertificate = null;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 3: 
            case 5: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHEKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) {
        this(keyExchange, dhGroupVerifier, null);
    }

    public TlsDHEKeyExchange(int keyExchange, TlsDHConfig dhConfig) {
        this(keyExchange, null, dhConfig);
    }

    private TlsDHEKeyExchange(int keyExchange, TlsDHGroupVerifier dhGroupVerifier, TlsDHConfig dhConfig) {
        super(TlsDHEKeyExchange.checkKeyExchange(keyExchange));
        this.dhGroupVerifier = dhGroupVerifier;
        this.dhConfig = dhConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireSignerCredentials(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.serverCertificate = serverCertificate.getCertificateAt(0);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        TlsDHUtils.writeDHConfig(this.dhConfig, digestBuffer);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, digestBuffer);
        TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, null, digestBuffer);
        return digestBuffer.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, digestBuffer);
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.context, this.dhGroupVerifier, teeIn);
        byte[] y = TlsUtils.readOpaque16(teeIn, 1);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, input, this.serverCertificate, null, digestBuffer);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.agreement.receivePeerValue(y);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        this.agreement.receivePeerValue(TlsUtils.readOpaque16(input, 1));
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }
}

