/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.crypto.params.ECPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.signers.SM2Signer;
import cn.win_trust_erpc.bouncycastle.tls.AbstractTlsKeyExchange;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedDecryptor;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentials;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsEncryptor;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsSM2KeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsEncryptor serverEncryptor;
    protected TlsSecret preMasterSecret;
    Certificate certificates;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 25: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSM2KeyExchange(int keyExchange) {
        super(TlsSM2KeyExchange.checkKeyExchange(keyExchange));
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireDecryptorCredentials(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.certificates = serverCertificate;
        this.serverEncryptor = serverCertificate.getCertificateAt(1).createEncryptor(4);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{256};
    }

    public static byte[] int2bytes(int num) {
        byte[] result = new byte[]{(byte)(num >>> 24 & 0xFF), (byte)(num >>> 16 & 0xFF), (byte)(num >>> 8 & 0xFF), (byte)(num >>> 0 & 0xFF)};
        return result;
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        byte[] signture = TlsUtils.readOpaque16(input);
        int len = input.available();
        byte[] res = new byte[len];
        try {
            TlsCertificate x509Cert = this.certificates.getCertificateAt(0);
            BcTlsCertificate bcCert = (BcTlsCertificate)x509Cert;
            SecurityParameters securityParameters = this.context.getSecurityParameters();
            ECPublicKeyParameters ec = bcCert.getPubKeyEC();
            SM2Signer sm2_signer = new SM2Signer();
            sm2_signer.init(false, ec);
            sm2_signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
            sm2_signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
            byte[] bTmp = TlsSM2KeyExchange.int2bytes(this.certificates.getCertificateAt(1).getEncoded().length);
            sm2_signer.update(bTmp, 1, 3);
            sm2_signer.update(this.certificates.getCertificateAt(1).getEncoded(), 0, this.certificates.getCertificateAt(1).getEncoded().length);
            if (!sm2_signer.verifySignature(signture)) {
                throw new TlsFatalAlert(43);
            }
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.preMasterSecret = TlsUtils.generateEncryptedPreMasterSecret(this.context, this.serverEncryptor, output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readEncryptedPMS(this.context, input);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tmp = this.preMasterSecret;
        this.preMasterSecret = null;
        return tmp;
    }
}

