/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.SessionParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsSession;
import cn.win_trust_erpc.bouncycastle.util.Arrays;

class TlsSessionImpl
implements TlsSession {
    final byte[] sessionID;
    final SessionParameters sessionParameters;
    boolean resumable;

    TlsSessionImpl(byte[] sessionID, SessionParameters sessionParameters) {
        if (sessionID == null) {
            throw new IllegalArgumentException("'sessionID' cannot be null");
        }
        if (sessionID.length > 32) {
            throw new IllegalArgumentException("'sessionID' cannot be longer than 32 bytes");
        }
        this.sessionID = Arrays.clone(sessionID);
        this.sessionParameters = sessionParameters;
        this.resumable = sessionID.length > 0 && sessionParameters != null;
    }

    @Override
    public synchronized SessionParameters exportSessionParameters() {
        return this.sessionParameters == null ? null : this.sessionParameters.copy();
    }

    @Override
    public synchronized byte[] getSessionID() {
        return this.sessionID;
    }

    @Override
    public synchronized void invalidate() {
        this.resumable = false;
    }

    @Override
    public synchronized boolean isResumable() {
        return this.resumable;
    }
}

