/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1InputStream;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import cn.win_trust_erpc.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.internal.asn1.bsi.BSIObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.internal.asn1.eac.EACObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.CertificateRequest;
import cn.win_trust_erpc.bouncycastle.tls.CertificateStatus;
import cn.win_trust_erpc.bouncycastle.tls.CipherSuite;
import cn.win_trust_erpc.bouncycastle.tls.CombinedHash;
import cn.win_trust_erpc.bouncycastle.tls.DigestInputBuffer;
import cn.win_trust_erpc.bouncycastle.tls.DigitallySigned;
import cn.win_trust_erpc.bouncycastle.tls.ExtensionType;
import cn.win_trust_erpc.bouncycastle.tls.HandshakeMessageInput;
import cn.win_trust_erpc.bouncycastle.tls.HashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.KeyShareEntry;
import cn.win_trust_erpc.bouncycastle.tls.NamedGroup;
import cn.win_trust_erpc.bouncycastle.tls.OfferedPsks;
import cn.win_trust_erpc.bouncycastle.tls.PRFAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.PskIdentity;
import cn.win_trust_erpc.bouncycastle.tls.RecordStream;
import cn.win_trust_erpc.bouncycastle.tls.SSL3Utils;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.SessionParameters;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureScheme;
import cn.win_trust_erpc.bouncycastle.tls.TlsAuthentication;
import cn.win_trust_erpc.bouncycastle.tls.TlsClient;
import cn.win_trust_erpc.bouncycastle.tls.TlsClientContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedAgreement;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedDecryptor;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedSigner;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentials;
import cn.win_trust_erpc.bouncycastle.tls.TlsExtensionsUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsHandshakeHash;
import cn.win_trust_erpc.bouncycastle.tls.TlsKeyExchange;
import cn.win_trust_erpc.bouncycastle.tls.TlsKeyExchangeFactory;
import cn.win_trust_erpc.bouncycastle.tls.TlsObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.tls.TlsPSK;
import cn.win_trust_erpc.bouncycastle.tls.TlsPSKExternal;
import cn.win_trust_erpc.bouncycastle.tls.TlsProtocol;
import cn.win_trust_erpc.bouncycastle.tls.TlsServer;
import cn.win_trust_erpc.bouncycastle.tls.TlsServerCertificateImpl;
import cn.win_trust_erpc.bouncycastle.tls.TlsServerContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsSession;
import cn.win_trust_erpc.bouncycastle.tls.TlsSessionImpl;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsAgreement;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCipher;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsDHConfig;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsECConfig;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsEncryptor;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHash;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHashOutputStream;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamVerifier;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsVerifier;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.Integers;
import cn.win_trust_erpc.bouncycastle.util.Shorts;
import cn.win_trust_erpc.bouncycastle.util.encoders.Hex;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TlsUtils {
    private static byte[] DOWNGRADE_TLS11 = Hex.decodeStrict("444F574E47524400");
    private static byte[] DOWNGRADE_TLS12 = Hex.decodeStrict("444F574E47524401");
    private static final Hashtable CERT_SIG_ALG_OIDS = TlsUtils.createCertSigAlgOIDs();
    private static final Vector DEFAULT_SUPPORTED_SIG_ALGS = TlsUtils.createDefaultSupportedSigAlgs();
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final String[] EMPTY_STRINGS = new String[0];
    static final short MINIMUM_HASH_STRICT = 2;
    static final short MINIMUM_HASH_PREFERRED = 4;

    private static void addCertSigAlgOID(Hashtable h, ASN1ObjectIdentifier oid, SignatureAndHashAlgorithm sigAndHash) {
        h.put(oid.getId(), sigAndHash);
    }

    private static void addCertSigAlgOID(Hashtable h, ASN1ObjectIdentifier oid, short hashAlgorithm, short signatureAlgorithm) {
        TlsUtils.addCertSigAlgOID(h, oid, SignatureAndHashAlgorithm.getInstance(hashAlgorithm, signatureAlgorithm));
    }

    private static Hashtable createCertSigAlgOIDs() {
        Hashtable h = new Hashtable();
        TlsUtils.addCertSigAlgOID(h, NISTObjectIdentifiers.dsa_with_sha224, (short)3, (short)2);
        TlsUtils.addCertSigAlgOID(h, NISTObjectIdentifiers.dsa_with_sha256, (short)4, (short)2);
        TlsUtils.addCertSigAlgOID(h, NISTObjectIdentifiers.dsa_with_sha384, (short)5, (short)2);
        TlsUtils.addCertSigAlgOID(h, NISTObjectIdentifiers.dsa_with_sha512, (short)6, (short)2);
        TlsUtils.addCertSigAlgOID(h, OIWObjectIdentifiers.dsaWithSHA1, (short)2, (short)2);
        TlsUtils.addCertSigAlgOID(h, OIWObjectIdentifiers.sha1WithRSA, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha1WithRSAEncryption, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha224WithRSAEncryption, (short)3, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha256WithRSAEncryption, (short)4, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha384WithRSAEncryption, (short)5, (short)1);
        TlsUtils.addCertSigAlgOID(h, PKCSObjectIdentifiers.sha512WithRSAEncryption, (short)6, (short)1);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.ecdsa_with_SHA512, (short)6, (short)3);
        TlsUtils.addCertSigAlgOID(h, X9ObjectIdentifiers.id_dsa_with_sha1, (short)2, (short)2);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_ECDSA_SHA_512, (short)6, (short)3);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1, (short)2, (short)1);
        TlsUtils.addCertSigAlgOID(h, EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256, (short)4, (short)1);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA1, (short)2, (short)3);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA224, (short)3, (short)3);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA256, (short)4, (short)3);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA384, (short)5, (short)3);
        TlsUtils.addCertSigAlgOID(h, BSIObjectIdentifiers.ecdsa_plain_SHA512, (short)6, (short)3);
        TlsUtils.addCertSigAlgOID(h, EdECObjectIdentifiers.id_Ed25519, SignatureAndHashAlgorithm.ed25519);
        TlsUtils.addCertSigAlgOID(h, EdECObjectIdentifiers.id_Ed448, SignatureAndHashAlgorithm.ed448);
        TlsUtils.addCertSigAlgOID(h, RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, SignatureAndHashAlgorithm.gostr34102012_256);
        TlsUtils.addCertSigAlgOID(h, RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, SignatureAndHashAlgorithm.gostr34102012_512);
        return h;
    }

    private static Vector createDefaultSupportedSigAlgs() {
        Vector<SignatureAndHashAlgorithm> result = new Vector<SignatureAndHashAlgorithm>();
        result.addElement(SignatureAndHashAlgorithm.ed25519);
        result.addElement(SignatureAndHashAlgorithm.ed448);
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)4, (short)3));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)5, (short)3));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)6, (short)3));
        result.addElement(SignatureAndHashAlgorithm.rsa_pss_rsae_sha256);
        result.addElement(SignatureAndHashAlgorithm.rsa_pss_rsae_sha384);
        result.addElement(SignatureAndHashAlgorithm.rsa_pss_rsae_sha512);
        result.addElement(SignatureAndHashAlgorithm.rsa_pss_pss_sha256);
        result.addElement(SignatureAndHashAlgorithm.rsa_pss_pss_sha384);
        result.addElement(SignatureAndHashAlgorithm.rsa_pss_pss_sha512);
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)4, (short)1));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)5, (short)1));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)6, (short)1));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)4, (short)2));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)5, (short)2));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)6, (short)2));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)3, (short)3));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)3, (short)1));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)3, (short)2));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)2, (short)3));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)2, (short)1));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)2, (short)2));
        result.addElement(SignatureAndHashAlgorithm.getInstance((short)16, (short)187));
        return result;
    }

    public static void checkUint8(short i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(long i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int i) throws IOException {
        if (!TlsUtils.isValidUint16(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(long i) throws IOException {
        if (!TlsUtils.isValidUint16(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int i) throws IOException {
        if (!TlsUtils.isValidUint24(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(long i) throws IOException {
        if (!TlsUtils.isValidUint24(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long i) throws IOException {
        if (!TlsUtils.isValidUint32(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long i) throws IOException {
        if (!TlsUtils.isValidUint48(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long i) throws IOException {
        if (!TlsUtils.isValidUint64(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint8(int i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint8(long i) {
        return (i & 0xFFL) == i;
    }

    public static boolean isValidUint16(int i) {
        return (i & 0xFFFF) == i;
    }

    public static boolean isValidUint16(long i) {
        return (i & 0xFFFFL) == i;
    }

    public static boolean isValidUint24(int i) {
        return (i & 0xFFFFFF) == i;
    }

    public static boolean isValidUint24(long i) {
        return (i & 0xFFFFFFL) == i;
    }

    public static boolean isValidUint32(long i) {
        return (i & 0xFFFFFFFFL) == i;
    }

    public static boolean isValidUint48(long i) {
        return (i & 0xFFFFFFFFFFFFL) == i;
    }

    public static boolean isValidUint64(long i) {
        return true;
    }

    public static boolean isSSL(TlsContext context) {
        return context.getServerVersion().isSSL();
    }

    public static boolean isTLSv10(ProtocolVersion version) {
        return ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv10(TlsContext context) {
        return TlsUtils.isTLSv10(context.getServerVersion());
    }

    public static boolean isTLSv11(ProtocolVersion version) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsContext context) {
        return TlsUtils.isTLSv11(context.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion version) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsContext context) {
        return TlsUtils.isTLSv12(context.getServerVersion());
    }

    public static boolean isSMv11(ProtocolVersion version) {
        return ProtocolVersion.SMv11.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isSMv11(TlsContext context) {
        return TlsUtils.isSMv11(context.getServerVersion());
    }

    public static boolean isTLSv13(ProtocolVersion version) {
        return ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv13(TlsContext context) {
        return TlsUtils.isTLSv13(context.getServerVersion());
    }

    public static void writeUint8(short i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(int i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(short i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint8(int i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint16(int i, OutputStream output) throws IOException {
        output.write(i >>> 8);
        output.write(i);
    }

    public static void writeUint16(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 8);
        buf[offset + 1] = (byte)i;
    }

    public static void writeUint24(int i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint24(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 16);
        buf[offset + 1] = (byte)(i >>> 8);
        buf[offset + 2] = (byte)i;
    }

    public static void writeUint32(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint32(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 24);
        buf[offset + 1] = (byte)(i >>> 16);
        buf[offset + 2] = (byte)(i >>> 8);
        buf[offset + 3] = (byte)i;
    }

    public static void writeUint48(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 40));
        output.write((byte)(i >>> 32));
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint48(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 40);
        buf[offset + 1] = (byte)(i >>> 32);
        buf[offset + 2] = (byte)(i >>> 24);
        buf[offset + 3] = (byte)(i >>> 16);
        buf[offset + 4] = (byte)(i >>> 8);
        buf[offset + 5] = (byte)i;
    }

    public static void writeUint64(long i, OutputStream output) throws IOException {
        output.write((byte)(i >>> 56));
        output.write((byte)(i >>> 48));
        output.write((byte)(i >>> 40));
        output.write((byte)(i >>> 32));
        output.write((byte)(i >>> 24));
        output.write((byte)(i >>> 16));
        output.write((byte)(i >>> 8));
        output.write((byte)i);
    }

    public static void writeUint64(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >>> 56);
        buf[offset + 1] = (byte)(i >>> 48);
        buf[offset + 2] = (byte)(i >>> 40);
        buf[offset + 3] = (byte)(i >>> 32);
        buf[offset + 4] = (byte)(i >>> 24);
        buf[offset + 5] = (byte)(i >>> 16);
        buf[offset + 6] = (byte)(i >>> 8);
        buf[offset + 7] = (byte)i;
    }

    public static void writeOpaque8(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint8(buf.length);
        TlsUtils.writeUint8(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque8(byte[] data, byte[] buf, int off) throws IOException {
        TlsUtils.checkUint8(data.length);
        TlsUtils.writeUint8(data.length, buf, off);
        System.arraycopy(data, 0, buf, off + 1, data.length);
    }

    public static void writeOpaque16(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint16(buf.length);
        TlsUtils.writeUint16(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque16(byte[] data, byte[] buf, int off) throws IOException {
        TlsUtils.checkUint16(data.length);
        TlsUtils.writeUint16(data.length, buf, off);
        System.arraycopy(data, 0, buf, off + 2, data.length);
    }

    public static void writeOpaque24(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint24(buf.length);
        TlsUtils.writeUint24(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque24(byte[] data, byte[] buf, int off) throws IOException {
        TlsUtils.checkUint24(data.length);
        TlsUtils.writeUint24(data.length, buf, off);
        System.arraycopy(data, 0, buf, off + 3, data.length);
    }

    public static void writeUint8Array(short[] uints, OutputStream output) throws IOException {
        int i = 0;
        while (i < uints.length) {
            TlsUtils.writeUint8(uints[i], output);
            ++i;
        }
    }

    public static void writeUint8Array(short[] uints, byte[] buf, int offset) throws IOException {
        int i = 0;
        while (i < uints.length) {
            TlsUtils.writeUint8(uints[i], buf, offset);
            ++offset;
            ++i;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, OutputStream output) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, output);
        TlsUtils.writeUint8Array(uints, output);
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, byte[] buf, int offset) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, buf, offset);
        TlsUtils.writeUint8Array(uints, buf, offset + 1);
    }

    public static void writeUint16Array(int[] uints, OutputStream output) throws IOException {
        int i = 0;
        while (i < uints.length) {
            TlsUtils.writeUint16(uints[i], output);
            ++i;
        }
    }

    public static void writeUint16Array(int[] uints, byte[] buf, int offset) throws IOException {
        int i = 0;
        while (i < uints.length) {
            TlsUtils.writeUint16(uints[i], buf, offset);
            offset += 2;
            ++i;
        }
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, OutputStream output) throws IOException {
        int length = 2 * uints.length;
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, output);
        TlsUtils.writeUint16Array(uints, output);
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, byte[] buf, int offset) throws IOException {
        int length = 2 * uints.length;
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, buf, offset);
        TlsUtils.writeUint16Array(uints, buf, offset + 2);
    }

    public static byte[] decodeOpaque8(byte[] buf) throws IOException {
        return TlsUtils.decodeOpaque8(buf, 0);
    }

    public static byte[] decodeOpaque8(byte[] buf, int minLength) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length < 1) {
            throw new TlsFatalAlert(50);
        }
        short length = TlsUtils.readUint8(buf, 0);
        if (buf.length != length + 1 || length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.copyOfRangeExact(buf, 1, buf.length);
    }

    public static byte[] decodeOpaque16(byte[] buf) throws IOException {
        return TlsUtils.decodeOpaque16(buf, 0);
    }

    public static byte[] decodeOpaque16(byte[] buf, int minLength) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length < 2) {
            throw new TlsFatalAlert(50);
        }
        int length = TlsUtils.readUint16(buf, 0);
        if (buf.length != length + 2 || length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.copyOfRangeExact(buf, 2, buf.length);
    }

    public static short decodeUint8(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 1) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8(buf, 0);
    }

    public static short[] decodeUint8ArrayWithUint8Length(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        int count = TlsUtils.readUint8(buf, 0);
        if (buf.length != count + 1) {
            throw new TlsFatalAlert(50);
        }
        short[] uints = new short[count];
        int i = 0;
        while (i < count) {
            uints[i] = TlsUtils.readUint8(buf, i + 1);
            ++i;
        }
        return uints;
    }

    public static int decodeUint16(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 2) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint16(buf, 0);
    }

    public static long decodeUint32(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("'buf' cannot be null");
        }
        if (buf.length != 4) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint32(buf, 0);
    }

    public static byte[] encodeOpaque8(byte[] buf) throws IOException {
        TlsUtils.checkUint8(buf.length);
        return Arrays.prepend(buf, (byte)buf.length);
    }

    public static byte[] encodeOpaque16(byte[] buf) throws IOException {
        TlsUtils.checkUint16(buf.length);
        byte[] r = new byte[2 + buf.length];
        TlsUtils.writeUint16(buf.length, r, 0);
        System.arraycopy(buf, 0, r, 2, buf.length);
        return r;
    }

    public static byte[] encodeOpaque24(byte[] buf) throws IOException {
        TlsUtils.checkUint24(buf.length);
        byte[] r = new byte[3 + buf.length];
        TlsUtils.writeUint24(buf.length, r, 0);
        System.arraycopy(buf, 0, r, 3, buf.length);
        return r;
    }

    public static byte[] encodeUint8(short uint) throws IOException {
        TlsUtils.checkUint8(uint);
        byte[] encoding = new byte[1];
        TlsUtils.writeUint8(uint, encoding, 0);
        return encoding;
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] uints) throws IOException {
        byte[] result = new byte[1 + uints.length];
        TlsUtils.writeUint8ArrayWithUint8Length(uints, result, 0);
        return result;
    }

    public static byte[] encodeUint16(int uint) throws IOException {
        TlsUtils.checkUint16(uint);
        byte[] encoding = new byte[2];
        TlsUtils.writeUint16(uint, encoding, 0);
        return encoding;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] uints) throws IOException {
        int length = 2 * uints.length;
        byte[] result = new byte[2 + length];
        TlsUtils.writeUint16ArrayWithUint16Length(uints, result, 0);
        return result;
    }

    public static byte[] encodeUint24(int uint) throws IOException {
        TlsUtils.checkUint24(uint);
        byte[] encoding = new byte[3];
        TlsUtils.writeUint24(uint, encoding, 0);
        return encoding;
    }

    public static byte[] encodeUint32(long uint) throws IOException {
        TlsUtils.checkUint32(uint);
        byte[] encoding = new byte[4];
        TlsUtils.writeUint32(uint, encoding, 0);
        return encoding;
    }

    public static byte[] encodeVersion(ProtocolVersion version) throws IOException {
        return new byte[]{(byte)version.getMajorVersion(), (byte)version.getMinorVersion()};
    }

    public static int readInt32(byte[] buf, int offset) {
        int n = buf[offset] << 24;
        n |= (buf[++offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static short readUint8(InputStream input) throws IOException {
        int i = input.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (short)i;
    }

    public static short readUint8(byte[] buf, int offset) {
        return (short)(buf[offset] & 0xFF);
    }

    public static int readUint16(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    public static int readUint16(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static int readUint24(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        if (i3 < 0) {
            throw new EOFException();
        }
        return i1 << 16 | i2 << 8 | i3;
    }

    public static int readUint24(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static long readUint32(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        int i4 = input.read();
        if (i4 < 0) {
            throw new EOFException();
        }
        return (long)(i1 << 24 | i2 << 16 | i3 << 8 | i4) & 0xFFFFFFFFL;
    }

    public static long readUint32(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 24;
        n |= (buf[++offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return (long)(n |= buf[++offset] & 0xFF) & 0xFFFFFFFFL;
    }

    public static long readUint48(InputStream input) throws IOException {
        int hi = TlsUtils.readUint24(input);
        int lo = TlsUtils.readUint24(input);
        return ((long)hi & 0xFFFFFFFFL) << 24 | (long)lo & 0xFFFFFFFFL;
    }

    public static long readUint48(byte[] buf, int offset) {
        int hi = TlsUtils.readUint24(buf, offset);
        int lo = TlsUtils.readUint24(buf, offset + 3);
        return ((long)hi & 0xFFFFFFFFL) << 24 | (long)lo & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        int read = Streams.readFully(input, buf);
        if (read == 0) {
            return null;
        }
        if (read != length) {
            throw new EOFException();
        }
        return buf;
    }

    public static byte[] readFully(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        if (length != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
        return buf;
    }

    public static void readFully(byte[] buf, InputStream input) throws IOException {
        int length = buf.length;
        if (length > 0 && length != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream input) throws IOException {
        short length = TlsUtils.readUint8(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque8(InputStream input, int minLength) throws IOException {
        short length = TlsUtils.readUint8(input);
        if (length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque8(InputStream input, int minLength, int maxLength) throws IOException {
        short length = TlsUtils.readUint8(input);
        if (length < minLength || maxLength < length) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque16(InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque16(InputStream input, int minLength) throws IOException {
        int length = TlsUtils.readUint16(input);
        if (length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque24(InputStream input) throws IOException {
        int length = TlsUtils.readUint24(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque24(InputStream input, int minLength) throws IOException {
        int length = TlsUtils.readUint24(input);
        if (length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readFully(length, input);
    }

    public static short[] readUint8Array(int count, InputStream input) throws IOException {
        short[] uints = new short[count];
        int i = 0;
        while (i < count) {
            uints[i] = TlsUtils.readUint8(input);
            ++i;
        }
        return uints;
    }

    public static short[] readUint8ArrayWithUint8Length(InputStream input, int minLength) throws IOException {
        short length = TlsUtils.readUint8(input);
        if (length < minLength) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8Array(length, input);
    }

    public static int[] readUint16Array(int count, InputStream input) throws IOException {
        int[] uints = new int[count];
        int i = 0;
        while (i < count) {
            uints[i] = TlsUtils.readUint16(input);
            ++i;
        }
        return uints;
    }

    public static ProtocolVersion readVersion(byte[] buf, int offset) {
        return ProtocolVersion.get(buf[offset] & 0xFF, buf[offset + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(i1, i2);
    }

    public static ASN1Primitive readASN1Object(byte[] encoding) throws IOException {
        ASN1InputStream asn1 = new ASN1InputStream(encoding);
        ASN1Primitive result = asn1.readObject();
        if (result == null) {
            throw new TlsFatalAlert(50);
        }
        if (asn1.readObject() != null) {
            throw new TlsFatalAlert(50);
        }
        return result;
    }

    public static ASN1Primitive readDERObject(byte[] encoding) throws IOException {
        ASN1Primitive result = TlsUtils.readASN1Object(encoding);
        TlsUtils.requireDEREncoding(result, encoding);
        return result;
    }

    public static void requireDEREncoding(ASN1Object asn1, byte[] encoding) throws IOException {
        byte[] check = asn1.getEncoded("DER");
        if (!Arrays.areEqual(check, encoding)) {
            throw new TlsFatalAlert(50);
        }
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int t = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(t >>> 24);
        buf[offset + 1] = (byte)(t >>> 16);
        buf[offset + 2] = (byte)(t >>> 8);
        buf[offset + 3] = (byte)t;
    }

    public static void writeVersion(ProtocolVersion version, OutputStream output) throws IOException {
        output.write(version.getMajorVersion());
        output.write(version.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion version, byte[] buf, int offset) {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    public static void addIfSupported(Vector supportedAlgs, TlsCrypto crypto, SignatureAndHashAlgorithm alg) {
        if (crypto.hasSignatureAndHashAlgorithm(alg)) {
            supportedAlgs.addElement(alg);
        }
    }

    public static void addIfSupported(Vector supportedGroups, TlsCrypto crypto, int namedGroup) {
        if (crypto.hasNamedGroup(namedGroup)) {
            supportedGroups.addElement(Integers.valueOf(namedGroup));
        }
    }

    public static void addIfSupported(Vector supportedGroups, TlsCrypto crypto, int[] namedGroups) {
        int i = 0;
        while (i < namedGroups.length) {
            TlsUtils.addIfSupported(supportedGroups, crypto, namedGroups[i]);
            ++i;
        }
    }

    public static boolean addToSet(Vector s, int i) {
        boolean result;
        boolean bl = result = !s.contains(Integers.valueOf(i));
        if (result) {
            s.add(Integers.valueOf(i));
        }
        return result;
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)2);
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)3);
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.getDefaultSignatureAlgorithms((short)1);
    }

    public static SignatureAndHashAlgorithm getDefaultSignatureAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: 
            case 2: 
            case 3: {
                return SignatureAndHashAlgorithm.getInstance((short)2, signatureAlgorithm);
            }
            case 187: {
                return SignatureAndHashAlgorithm.getInstance((short)16, signatureAlgorithm);
            }
        }
        return null;
    }

    public static Vector getDefaultSignatureAlgorithms(short signatureAlgorithm) {
        SignatureAndHashAlgorithm sigAndHashAlg = TlsUtils.getDefaultSignatureAlgorithm(signatureAlgorithm);
        return sigAndHashAlg == null ? new Vector() : TlsUtils.vectorOfOne(sigAndHashAlg);
    }

    public static Vector getDefaultSupportedSignatureAlgorithms(TlsContext context) {
        TlsCrypto crypto = context.getCrypto();
        int count = DEFAULT_SUPPORTED_SIG_ALGS.size();
        Vector result = new Vector(count);
        int i = 0;
        while (i < count) {
            TlsUtils.addIfSupported(result, crypto, (SignatureAndHashAlgorithm)DEFAULT_SUPPORTED_SIG_ALGS.elementAt(i));
            ++i;
        }
        return result;
    }

    public static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(TlsContext context, TlsCredentialedSigner signerCredentials) throws IOException {
        return TlsUtils.getSignatureAndHashAlgorithm(context.getServerVersion(), signerCredentials);
    }

    static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(ProtocolVersion negotiatedVersion, TlsCredentialedSigner signerCredentials) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (TlsUtils.isTLSv12(negotiatedVersion) && (signatureAndHashAlgorithm = signerCredentials.getSignatureAndHashAlgorithm()) == null) {
            throw new TlsFatalAlert(80);
        }
        return signatureAndHashAlgorithm;
    }

    public static byte[] getExtensionData(Hashtable extensions, Integer extensionType) {
        return extensions == null ? null : (byte[])extensions.get(extensionType);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable extensions, Integer extensionType, short alertDescription) throws IOException {
        byte[] extension_data = TlsUtils.getExtensionData(extensions, extensionType);
        if (extension_data == null) {
            return false;
        }
        if (extension_data.length != 0) {
            throw new TlsFatalAlert(alertDescription);
        }
        return true;
    }

    public static TlsSession importSession(byte[] sessionID, SessionParameters sessionParameters) {
        return new TlsSessionImpl(sessionID, sessionParameters);
    }

    static boolean isExtendedMasterSecretOptionalDTLS(ProtocolVersion[] activeProtocolVersions) {
        return ProtocolVersion.contains(activeProtocolVersions, ProtocolVersion.DTLSv12) || ProtocolVersion.contains(activeProtocolVersions, ProtocolVersion.DTLSv10);
    }

    static boolean isExtendedMasterSecretOptionalTLS(ProtocolVersion[] activeProtocolVersions) {
        return ProtocolVersion.contains(activeProtocolVersions, ProtocolVersion.TLSv12) || ProtocolVersion.contains(activeProtocolVersions, ProtocolVersion.TLSv11) || ProtocolVersion.contains(activeProtocolVersions, ProtocolVersion.TLSv10);
    }

    public static boolean isNullOrContainsNull(Object[] array) {
        if (array == null) {
            return true;
        }
        int count = array.length;
        int i = 0;
        while (i < count) {
            if (array[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNullOrEmpty(byte[] array) {
        return array == null || array.length < 1;
    }

    public static boolean isNullOrEmpty(short[] array) {
        return array == null || array.length < 1;
    }

    public static boolean isNullOrEmpty(int[] array) {
        return array == null || array.length < 1;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length < 1;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() < 1;
    }

    public static boolean isNullOrEmpty(Vector v) {
        return v == null || v.isEmpty();
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion version) {
        return version != null && ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static short getLegacyClientCertType(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 64;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmClient(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return 2;
            }
            case 64: {
                return 3;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmClientCert(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: 
            case 4: {
                return 2;
            }
            case 64: 
            case 66: {
                return 3;
            }
            case 1: 
            case 3: 
            case 65: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmServer(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 3: 
            case 22: {
                return 2;
            }
            case 17: {
                return 3;
            }
            case 5: 
            case 19: 
            case 23: {
                return 1;
            }
        }
        return -1;
    }

    public static short getLegacySignatureAlgorithmServerCert(int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 3: 
            case 7: 
            case 22: {
                return 2;
            }
            case 16: 
            case 17: {
                return 3;
            }
            case 1: 
            case 5: 
            case 9: 
            case 15: 
            case 18: 
            case 19: 
            case 23: {
                return 1;
            }
        }
        return -1;
    }

    public static Vector getLegacySupportedSignatureAlgorithms() {
        Vector<SignatureAndHashAlgorithm> result = new Vector<SignatureAndHashAlgorithm>(3);
        result.add(SignatureAndHashAlgorithm.getInstance((short)2, (short)2));
        result.add(SignatureAndHashAlgorithm.getInstance((short)2, (short)3));
        result.add(SignatureAndHashAlgorithm.getInstance((short)2, (short)1));
        return result;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector supportedSignatureAlgorithms, OutputStream output) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int length = 2 * supportedSignatureAlgorithms.size();
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, output);
        int i = 0;
        while (i < supportedSignatureAlgorithms.size()) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (entry.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            entry.encode(output);
            ++i;
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int count = length / 2;
        Vector<SignatureAndHashAlgorithm> supportedSignatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(count);
        int i = 0;
        while (i < count) {
            SignatureAndHashAlgorithm sigAndHashAlg = SignatureAndHashAlgorithm.parse(input);
            if (sigAndHashAlg.getSignature() != 0) {
                supportedSignatureAlgorithms.addElement(sigAndHashAlg);
            }
            ++i;
        }
        return supportedSignatureAlgorithms;
    }

    public static void verifySupportedSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAlgorithm' cannot be null");
        }
        if (signatureAlgorithm.getSignature() == 0 || !TlsUtils.containsSignatureAlgorithm(supportedSignatureAlgorithms, signatureAlgorithm)) {
            throw new TlsFatalAlert(47);
        }
    }

    public static boolean containsSignatureAlgorithm(Vector supportedSignatureAlgorithms, SignatureAndHashAlgorithm signatureAlgorithm) throws IOException {
        int i = 0;
        while (i < supportedSignatureAlgorithms.size()) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (entry.equals(signatureAlgorithm)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsAnySignatureAlgorithm(Vector supportedSignatureAlgorithms, short signatureAlgorithm) {
        int i = 0;
        while (i < supportedSignatureAlgorithms.size()) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (entry.getSignature() == signatureAlgorithm) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static TlsSecret PRF(SecurityParameters securityParameters, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        return secret.deriveUsingPRF(securityParameters.getPRFAlgorithm(), asciiLabel, seed, length);
    }

    public static TlsSecret PRF(TlsContext context, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        return TlsUtils.PRF(context.getSecurityParametersHandshake(), secret, asciiLabel, seed, length);
    }

    public static byte[] clone(byte[] data) {
        return data == null ? null : (data.length == 0 ? EMPTY_BYTES : (byte[])data.clone());
    }

    public static String[] clone(String[] s) {
        return s == null ? null : (s.length < 1 ? EMPTY_STRINGS : (String[])s.clone());
    }

    public static boolean constantTimeAreEqual(int len, byte[] a, int aOff, byte[] b, int bOff) {
        int d = 0;
        int i = 0;
        while (i < len) {
            d |= a[aOff + i] ^ b[bOff + i];
            ++i;
        }
        return d == 0;
    }

    public static byte[] copyOfRangeExact(byte[] original, int from, int to) {
        int newLength = to - from;
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, newLength);
        return copy;
    }

    static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    static byte[] calculateEndPointHash(TlsContext context, TlsCertificate certificate, byte[] enc) throws IOException {
        return TlsUtils.calculateEndPointHash(context, certificate, enc, 0, enc.length);
    }

    static byte[] calculateEndPointHash(TlsContext context, TlsCertificate certificate, byte[] enc, int encOff, int encLen) throws IOException {
        TlsHash hash;
        int hashAlgorithm = 0;
        String sigAlgOID = certificate.getSigAlgOID();
        if (sigAlgOID != null) {
            if (PKCSObjectIdentifiers.id_RSASSA_PSS.getId().equals(sigAlgOID)) {
                RSASSAPSSparams pssParams = RSASSAPSSparams.getInstance(certificate.getSigAlgParams());
                if (pssParams != null) {
                    ASN1ObjectIdentifier hashOID = pssParams.getHashAlgorithm().getAlgorithm();
                    if (NISTObjectIdentifiers.id_sha256.equals(hashOID)) {
                        hashAlgorithm = 4;
                    } else if (NISTObjectIdentifiers.id_sha384.equals(hashOID)) {
                        hashAlgorithm = 5;
                    } else if (NISTObjectIdentifiers.id_sha512.equals(hashOID)) {
                        hashAlgorithm = 6;
                    }
                }
            } else {
                SignatureAndHashAlgorithm sigAndHashAlg = (SignatureAndHashAlgorithm)CERT_SIG_ALG_OIDS.get(sigAlgOID);
                if (sigAndHashAlg != null) {
                    hashAlgorithm = sigAndHashAlg.getHash();
                }
            }
        }
        switch (hashAlgorithm) {
            case 8: {
                hashAlgorithm = 0;
                break;
            }
            case 1: 
            case 2: {
                hashAlgorithm = 4;
            }
        }
        if (hashAlgorithm != 0 && (hash = TlsUtils.createHash(context.getCrypto(), (short)hashAlgorithm)) != null) {
            hash.update(enc, encOff, encLen);
            return hash.calculateHash();
        }
        return EMPTY_BYTES;
    }

    public static byte[] calculateExporterSeed(SecurityParameters securityParameters, byte[] context) {
        byte[] cr = securityParameters.getClientRandom();
        byte[] sr = securityParameters.getServerRandom();
        if (context == null) {
            return Arrays.concatenate(cr, sr);
        }
        if (!TlsUtils.isValidUint16(context.length)) {
            throw new IllegalArgumentException("'context' must have length less than 2^16 (or be null)");
        }
        byte[] contextLength = new byte[2];
        TlsUtils.writeUint16(context.length, contextLength, 0);
        return Arrays.concatenate(cr, sr, contextLength, context);
    }

    private static byte[] calculateFinishedHMAC(SecurityParameters securityParameters, TlsSecret baseKey, byte[] transcriptHash) throws IOException {
        int prfCryptoHashAlgorithm = securityParameters.getPRFCryptoHashAlgorithm();
        int prfHashLength = securityParameters.getPRFHashLength();
        return TlsUtils.calculateFinishedHMAC(prfCryptoHashAlgorithm, prfHashLength, baseKey, transcriptHash);
    }

    private static byte[] calculateFinishedHMAC(int prfCryptoHashAlgorithm, int prfHashLength, TlsSecret baseKey, byte[] transcriptHash) throws IOException {
        TlsSecret finishedKey = TlsCryptoUtils.hkdfExpandLabel(baseKey, prfCryptoHashAlgorithm, "finished", EMPTY_BYTES, prfHashLength);
        try {
            byte[] byArray = finishedKey.calculateHMAC(prfCryptoHashAlgorithm, transcriptHash, 0, transcriptHash.length);
            return byArray;
        }
        finally {
            finishedKey.destroy();
        }
    }

    static TlsSecret calculateMasterSecret(TlsContext context, TlsSecret preMasterSecret) {
        byte[] seed;
        String asciiLabel;
        SecurityParameters sp = context.getSecurityParametersHandshake();
        if (sp.isExtendedMasterSecret()) {
            asciiLabel = "extended master secret";
            seed = sp.getSessionHash();
        } else {
            asciiLabel = "master secret";
            seed = TlsUtils.concat(sp.getClientRandom(), sp.getServerRandom());
        }
        return TlsUtils.PRF(sp, preMasterSecret, asciiLabel, seed, 48);
    }

    static byte[] calculatePSKBinder(TlsCrypto crypto, boolean isExternalPSK, int pskCryptoHashAlgorithm, TlsSecret earlySecret, byte[] transcriptHash) throws IOException {
        int prfHashLength = TlsCryptoUtils.getHashOutputSize(pskCryptoHashAlgorithm);
        String label = isExternalPSK ? "ext binder" : "res binder";
        byte[] emptyTranscriptHash = crypto.createHash(pskCryptoHashAlgorithm).calculateHash();
        TlsSecret binderKey = TlsUtils.deriveSecret(pskCryptoHashAlgorithm, prfHashLength, earlySecret, label, emptyTranscriptHash);
        try {
            byte[] byArray = TlsUtils.calculateFinishedHMAC(pskCryptoHashAlgorithm, prfHashLength, binderKey, transcriptHash);
            return byArray;
        }
        finally {
            binderKey.destroy();
        }
    }

    static byte[] calculateVerifyData(TlsContext context, TlsHandshakeHash handshakeHash, boolean isServer) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (TlsUtils.isTLSv13(negotiatedVersion)) {
            TlsSecret baseKey = isServer ? securityParameters.getBaseKeyServer() : securityParameters.getBaseKeyClient();
            byte[] transcriptHash = TlsUtils.getCurrentPRFHash(handshakeHash);
            return TlsUtils.calculateFinishedHMAC(securityParameters, baseKey, transcriptHash);
        }
        if (negotiatedVersion.isSSL()) {
            return SSL3Utils.calculateVerifyData(handshakeHash, isServer);
        }
        String asciiLabel = isServer ? "server finished" : "client finished";
        byte[] prfHash = TlsUtils.getCurrentPRFHash(handshakeHash);
        TlsSecret master_secret = securityParameters.getMasterSecret();
        int verify_data_length = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(securityParameters, master_secret, asciiLabel, prfHash, verify_data_length).extract();
    }

    static void establish13PhaseSecrets(TlsContext context, TlsSecret pskEarlySecret, TlsSecret sharedSecret) throws IOException {
        TlsCrypto crypto = context.getCrypto();
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        int cryptoHashAlgorithm = securityParameters.getPRFCryptoHashAlgorithm();
        TlsSecret zeros = crypto.hkdfInit(cryptoHashAlgorithm);
        byte[] emptyTranscriptHash = crypto.createHash(cryptoHashAlgorithm).calculateHash();
        TlsSecret earlySecret = pskEarlySecret;
        if (earlySecret == null) {
            earlySecret = crypto.hkdfInit(cryptoHashAlgorithm).hkdfExtract(cryptoHashAlgorithm, zeros);
        }
        if (sharedSecret == null) {
            sharedSecret = zeros;
        }
        TlsSecret handshakeSecret = TlsUtils.deriveSecret(securityParameters, earlySecret, "derived", emptyTranscriptHash).hkdfExtract(cryptoHashAlgorithm, sharedSecret);
        if (sharedSecret != zeros) {
            sharedSecret.destroy();
        }
        TlsSecret masterSecret = TlsUtils.deriveSecret(securityParameters, handshakeSecret, "derived", emptyTranscriptHash).hkdfExtract(cryptoHashAlgorithm, zeros);
        securityParameters.earlySecret = earlySecret;
        securityParameters.handshakeSecret = handshakeSecret;
        securityParameters.masterSecret = masterSecret;
    }

    private static void establish13TrafficSecrets(TlsContext context, byte[] transcriptHash, TlsSecret phaseSecret, String clientLabel, String serverLabel, RecordStream recordStream) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        securityParameters.trafficSecretClient = TlsUtils.deriveSecret(securityParameters, phaseSecret, clientLabel, transcriptHash);
        if (serverLabel != null) {
            securityParameters.trafficSecretServer = TlsUtils.deriveSecret(securityParameters, phaseSecret, serverLabel, transcriptHash);
        }
        recordStream.setPendingCipher(TlsUtils.initCipher(context));
    }

    static void establish13PhaseApplication(TlsContext context, byte[] serverFinishedTranscriptHash, RecordStream recordStream) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        TlsSecret phaseSecret = securityParameters.getMasterSecret();
        TlsUtils.establish13TrafficSecrets(context, serverFinishedTranscriptHash, phaseSecret, "c ap traffic", "s ap traffic", recordStream);
        securityParameters.exporterMasterSecret = TlsUtils.deriveSecret(securityParameters, phaseSecret, "exp master", serverFinishedTranscriptHash);
    }

    static void establish13PhaseEarly(TlsContext context, byte[] clientHelloTranscriptHash, RecordStream recordStream) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        TlsSecret phaseSecret = securityParameters.getEarlySecret();
        if (recordStream != null) {
            TlsUtils.establish13TrafficSecrets(context, clientHelloTranscriptHash, phaseSecret, "c e traffic", null, recordStream);
        }
        securityParameters.earlyExporterMasterSecret = TlsUtils.deriveSecret(securityParameters, phaseSecret, "e exp master", clientHelloTranscriptHash);
    }

    static void establish13PhaseHandshake(TlsContext context, byte[] serverHelloTranscriptHash, RecordStream recordStream) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        TlsSecret phaseSecret = securityParameters.getHandshakeSecret();
        TlsUtils.establish13TrafficSecrets(context, serverHelloTranscriptHash, phaseSecret, "c hs traffic", "s hs traffic", recordStream);
        securityParameters.baseKeyClient = securityParameters.getTrafficSecretClient();
        securityParameters.baseKeyServer = securityParameters.getTrafficSecretServer();
    }

    static void update13TrafficSecretLocal(TlsContext context) throws IOException {
        TlsUtils.update13TrafficSecret(context, context.isServer());
    }

    static void update13TrafficSecretPeer(TlsContext context) throws IOException {
        TlsUtils.update13TrafficSecret(context, !context.isServer());
    }

    private static void update13TrafficSecret(TlsContext context, boolean forServer) throws IOException {
        TlsSecret current;
        SecurityParameters securityParameters = context.getSecurityParametersConnection();
        if (forServer) {
            current = securityParameters.getTrafficSecretServer();
            securityParameters.trafficSecretServer = TlsUtils.update13TrafficSecret(securityParameters, current);
        } else {
            current = securityParameters.getTrafficSecretClient();
            securityParameters.trafficSecretClient = TlsUtils.update13TrafficSecret(securityParameters, current);
        }
        if (current != null) {
            current.destroy();
        }
    }

    private static TlsSecret update13TrafficSecret(SecurityParameters securityParameters, TlsSecret secret) throws IOException {
        return TlsCryptoUtils.hkdfExpandLabel(secret, securityParameters.getPRFCryptoHashAlgorithm(), "traffic upd", EMPTY_BYTES, securityParameters.getPRFHashLength());
    }

    public static short getHashAlgorithmForPRFAlgorithm(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 2: 
            case 4: {
                return 4;
            }
            case 3: 
            case 5: {
                return 5;
            }
            case 7: 
            case 8: {
                return 16;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm: " + PRFAlgorithm.getText(prfAlgorithm));
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    static int getPRFAlgorithm(SecurityParameters securityParameters, int cipherSuite) throws IOException {
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        boolean isTLSv13 = TlsUtils.isTLSv13(negotiatedVersion);
        boolean isTLSv12Exactly = !isTLSv13 && TlsUtils.isTLSv12(negotiatedVersion);
        boolean isSSL = negotiatedVersion.isSSL();
        switch (cipherSuite) {
            case 4865: 
            case 4867: 
            case 4868: 
            case 4869: {
                if (isTLSv13) {
                    return 4;
                }
                throw new TlsFatalAlert(47);
            }
            case 4866: {
                if (isTLSv13) {
                    return 5;
                }
                throw new TlsFatalAlert(47);
            }
            case 57363: {
                return 8;
            }
            case 198: 
            case 199: {
                if (isTLSv13) {
                    return 7;
                }
                throw new TlsFatalAlert(47);
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49258: 
            case 49260: 
            case 49262: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53251: 
            case 53253: {
                if (isTLSv12Exactly) {
                    return 2;
                }
                throw new TlsFatalAlert(47);
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49259: 
            case 49261: 
            case 49263: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: 
            case 53250: {
                if (isTLSv12Exactly) {
                    return 3;
                }
                throw new TlsFatalAlert(47);
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49208: 
            case 49211: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                if (isTLSv13) {
                    throw new TlsFatalAlert(47);
                }
                if (isTLSv12Exactly) {
                    return 3;
                }
                if (isSSL) {
                    return 0;
                }
                return 1;
            }
        }
        if (isTLSv13) {
            throw new TlsFatalAlert(47);
        }
        if (isTLSv12Exactly) {
            return 2;
        }
        if (isSSL) {
            return 0;
        }
        return 1;
    }

    static int getPRFAlgorithm13(int cipherSuite) {
        switch (cipherSuite) {
            case 4865: 
            case 4867: 
            case 4868: 
            case 4869: {
                return 4;
            }
            case 4866: {
                return 5;
            }
            case 57363: {
                return 8;
            }
            case 198: 
            case 199: {
                return 7;
            }
        }
        return -1;
    }

    static int[] getPRFAlgorithms13(int[] cipherSuites) {
        int[] result = new int[Math.min(3, cipherSuites.length)];
        int count = 0;
        int i = 0;
        while (i < cipherSuites.length) {
            int prfAlgorithm = TlsUtils.getPRFAlgorithm13(cipherSuites[i]);
            if (prfAlgorithm >= 0 && !Arrays.contains(result, prfAlgorithm)) {
                result[count++] = prfAlgorithm;
            }
            ++i;
        }
        return TlsUtils.truncate(result, count);
    }

    static byte[] calculateSignatureHash(TlsContext context, SignatureAndHashAlgorithm algorithm, byte[] extraSignatureInput, DigestInputBuffer buf) {
        TlsCrypto crypto = context.getCrypto();
        TlsHash h = algorithm == null ? new CombinedHash(crypto) : TlsUtils.createHash(crypto, algorithm.getHash());
        SecurityParameters sp = context.getSecurityParametersHandshake();
        byte[] randoms = Arrays.concatenate(sp.getClientRandom(), sp.getServerRandom());
        h.update(randoms, 0, randoms.length);
        if (extraSignatureInput != null) {
            h.update(extraSignatureInput, 0, extraSignatureInput.length);
        }
        buf.updateDigest(h);
        return h.calculateHash();
    }

    static void sendSignatureInput(TlsContext context, byte[] extraSignatureInput, DigestInputBuffer buf, OutputStream output) throws IOException {
        SecurityParameters sp = context.getSecurityParametersHandshake();
        byte[] randoms = Arrays.concatenate(sp.getClientRandom(), sp.getServerRandom());
        output.write(randoms);
        if (extraSignatureInput != null) {
            output.write(extraSignatureInput);
        }
        buf.copyTo(output);
        output.close();
    }

    static DigitallySigned generateCertificateVerifyClient(TlsClientContext clientContext, TlsCredentialedSigner credentialedSigner, TlsStreamSigner streamSigner, TlsHandshakeHash handshakeHash) throws IOException {
        byte[] signature;
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (TlsUtils.isTLSv13(negotiatedVersion)) {
            throw new TlsFatalAlert(80);
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(negotiatedVersion, credentialedSigner);
        if (streamSigner != null) {
            handshakeHash.copyBufferTo(streamSigner.getOutputStream());
            signature = streamSigner.getSignature();
        } else {
            byte[] hash;
            if (signatureAndHashAlgorithm == null) {
                hash = securityParameters.getSessionHash();
            } else {
                int signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm);
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                hash = handshakeHash.getFinalHash(cryptoHashAlgorithm);
            }
            signature = credentialedSigner.generateRawSignature(hash);
        }
        return new DigitallySigned(signatureAndHashAlgorithm, signature);
    }

    static DigitallySigned generate13CertificateVerify(TlsContext context, TlsCredentialedSigner credentialedSigner, TlsHandshakeHash handshakeHash) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = credentialedSigner.getSignatureAndHashAlgorithm();
        if (signatureAndHashAlgorithm == null) {
            throw new TlsFatalAlert(80);
        }
        String contextString = context.isServer() ? "TLS 1.3, server CertificateVerify" : "TLS 1.3, client CertificateVerify";
        byte[] signature = TlsUtils.generate13CertificateVerify(context.getCrypto(), credentialedSigner, contextString, handshakeHash, signatureAndHashAlgorithm);
        return new DigitallySigned(signatureAndHashAlgorithm, signature);
    }

    private static byte[] generate13CertificateVerify(TlsCrypto crypto, TlsCredentialedSigner credentialedSigner, String contextString, TlsHandshakeHash handshakeHash, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        TlsStreamSigner streamSigner = credentialedSigner.getStreamSigner();
        byte[] header = TlsUtils.getCertificateVerifyHeader(contextString);
        byte[] prfHash = TlsUtils.getCurrentPRFHash(handshakeHash);
        if (streamSigner != null) {
            OutputStream output = streamSigner.getOutputStream();
            output.write(header, 0, header.length);
            output.write(prfHash, 0, prfHash.length);
            return streamSigner.getSignature();
        }
        int signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm);
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
        TlsHash tlsHash = crypto.createHash(cryptoHashAlgorithm);
        tlsHash.update(header, 0, header.length);
        tlsHash.update(prfHash, 0, prfHash.length);
        byte[] hash = tlsHash.calculateHash();
        return credentialedSigner.generateRawSignature(hash);
    }

    static void verifyCertificateVerifyClient(TlsServerContext serverContext, CertificateRequest certificateRequest, DigitallySigned certificateVerify, TlsHandshakeHash handshakeHash) throws IOException {
        boolean verified;
        short signatureAlgorithm;
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        Certificate clientCertificate = securityParameters.getPeerCertificate();
        TlsCertificate verifyingCert = clientCertificate.getCertificateAt(0);
        SignatureAndHashAlgorithm sigAndHashAlg = certificateVerify.getAlgorithm();
        if (sigAndHashAlg == null) {
            signatureAlgorithm = verifyingCert.getLegacySignatureAlgorithm();
            short clientCertType = TlsUtils.getLegacyClientCertType(signatureAlgorithm);
            if (clientCertType < 0 || !Arrays.contains(certificateRequest.getCertificateTypes(), clientCertType)) {
                throw new TlsFatalAlert(43);
            }
        } else {
            signatureAlgorithm = sigAndHashAlg.getSignature();
            if (!TlsUtils.isValidSignatureAlgorithmForCertificateVerify(signatureAlgorithm, certificateRequest.getCertificateTypes())) {
                throw new TlsFatalAlert(47);
            }
            TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getServerSigAlgs(), sigAndHashAlg);
        }
        try {
            TlsVerifier verifier = verifyingCert.createVerifier(signatureAlgorithm);
            TlsStreamVerifier streamVerifier = verifier.getStreamVerifier(certificateVerify);
            if (streamVerifier != null) {
                handshakeHash.copyBufferTo(streamVerifier.getOutputStream());
                verified = streamVerifier.isVerified();
            } else {
                byte[] hash;
                if (TlsUtils.isTLSv12(serverContext)) {
                    int signatureScheme = SignatureScheme.from(sigAndHashAlg);
                    int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                    hash = handshakeHash.getFinalHash(cryptoHashAlgorithm);
                } else {
                    hash = securityParameters.getSessionHash();
                }
                verified = verifier.verifyRawSignature(certificateVerify, hash);
            }
        }
        catch (TlsFatalAlert e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51, (Throwable)e);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    static void verify13CertificateVerifyClient(TlsServerContext serverContext, CertificateRequest certificateRequest, DigitallySigned certificateVerify, TlsHandshakeHash handshakeHash) throws IOException {
        boolean verified;
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        Certificate clientCertificate = securityParameters.getPeerCertificate();
        TlsCertificate verifyingCert = clientCertificate.getCertificateAt(0);
        SignatureAndHashAlgorithm sigAndHashAlg = certificateVerify.getAlgorithm();
        TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getServerSigAlgs(), sigAndHashAlg);
        int signatureScheme = SignatureScheme.from(sigAndHashAlg);
        try {
            TlsVerifier verifier = verifyingCert.createVerifier(signatureScheme);
            verified = TlsUtils.verify13CertificateVerify(serverContext.getCrypto(), certificateVerify, verifier, "TLS 1.3, client CertificateVerify", handshakeHash);
        }
        catch (TlsFatalAlert e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51, (Throwable)e);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    static void verify13CertificateVerifyServer(TlsClientContext clientContext, DigitallySigned certificateVerify, TlsHandshakeHash handshakeHash) throws IOException {
        boolean verified;
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        Certificate serverCertificate = securityParameters.getPeerCertificate();
        TlsCertificate verifyingCert = serverCertificate.getCertificateAt(0);
        SignatureAndHashAlgorithm sigAndHashAlg = certificateVerify.getAlgorithm();
        TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getClientSigAlgs(), sigAndHashAlg);
        int signatureScheme = SignatureScheme.from(sigAndHashAlg);
        try {
            TlsVerifier verifier = verifyingCert.createVerifier(signatureScheme);
            verified = TlsUtils.verify13CertificateVerify(clientContext.getCrypto(), certificateVerify, verifier, "TLS 1.3, server CertificateVerify", handshakeHash);
        }
        catch (TlsFatalAlert e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51, (Throwable)e);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    private static boolean verify13CertificateVerify(TlsCrypto crypto, DigitallySigned certificateVerify, TlsVerifier verifier, String contextString, TlsHandshakeHash handshakeHash) throws IOException {
        TlsStreamVerifier streamVerifier = verifier.getStreamVerifier(certificateVerify);
        byte[] header = TlsUtils.getCertificateVerifyHeader(contextString);
        byte[] prfHash = TlsUtils.getCurrentPRFHash(handshakeHash);
        if (streamVerifier != null) {
            OutputStream output = streamVerifier.getOutputStream();
            output.write(header, 0, header.length);
            output.write(prfHash, 0, prfHash.length);
            return streamVerifier.isVerified();
        }
        int signatureScheme = SignatureScheme.from(certificateVerify.getAlgorithm());
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
        TlsHash tlsHash = crypto.createHash(cryptoHashAlgorithm);
        tlsHash.update(header, 0, header.length);
        tlsHash.update(prfHash, 0, prfHash.length);
        byte[] hash = tlsHash.calculateHash();
        return verifier.verifyRawSignature(certificateVerify, hash);
    }

    private static byte[] getCertificateVerifyHeader(String contextString) {
        int count = contextString.length();
        byte[] header = new byte[64 + count + 1];
        int i = 0;
        while (i < 64) {
            header[i] = 32;
            ++i;
        }
        i = 0;
        while (i < count) {
            char c = contextString.charAt(i);
            header[64 + i] = (byte)c;
            ++i;
        }
        header[64 + count] = 0;
        return header;
    }

    static void generateServerKeyExchangeSignature(TlsContext context, TlsCredentialedSigner credentials, byte[] extraSignatureInput, DigestInputBuffer digestBuffer) throws IOException {
        byte[] signature;
        SignatureAndHashAlgorithm algorithm = TlsUtils.getSignatureAndHashAlgorithm(context, credentials);
        TlsStreamSigner streamSigner = credentials.getStreamSigner();
        if (streamSigner != null) {
            TlsUtils.sendSignatureInput(context, extraSignatureInput, digestBuffer, streamSigner.getOutputStream());
            signature = streamSigner.getSignature();
        } else {
            byte[] hash = TlsUtils.calculateSignatureHash(context, algorithm, extraSignatureInput, digestBuffer);
            signature = credentials.generateRawSignature(hash);
        }
        DigitallySigned digitallySigned = new DigitallySigned(algorithm, signature);
        digitallySigned.encode(digestBuffer);
    }

    static void verifyServerKeyExchangeSignature(TlsContext context, InputStream signatureInput, TlsCertificate serverCertificate, byte[] extraSignatureInput, DigestInputBuffer digestBuffer) throws IOException {
        boolean verified;
        short signatureAlgorithm;
        DigitallySigned digitallySigned = DigitallySigned.parse(context, signatureInput);
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        int keyExchangeAlgorithm = securityParameters.getKeyExchangeAlgorithm();
        SignatureAndHashAlgorithm sigAndHashAlg = digitallySigned.getAlgorithm();
        if (sigAndHashAlg == null) {
            signatureAlgorithm = TlsUtils.getLegacySignatureAlgorithmServer(keyExchangeAlgorithm);
        } else {
            signatureAlgorithm = sigAndHashAlg.getSignature();
            if (!TlsUtils.isValidSignatureAlgorithmForServerKeyExchange(signatureAlgorithm, keyExchangeAlgorithm)) {
                throw new TlsFatalAlert(47);
            }
            TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getClientSigAlgs(), sigAndHashAlg);
        }
        TlsVerifier verifier = serverCertificate.createVerifier(signatureAlgorithm);
        TlsStreamVerifier streamVerifier = verifier.getStreamVerifier(digitallySigned);
        if (streamVerifier != null) {
            TlsUtils.sendSignatureInput(context, extraSignatureInput, digestBuffer, streamVerifier.getOutputStream());
            verified = streamVerifier.isVerified();
        } else {
            byte[] hash = TlsUtils.calculateSignatureHash(context, sigAndHashAlg, extraSignatureInput, digestBuffer);
            verified = verifier.verifyRawSignature(digitallySigned, hash);
        }
        if (!verified) {
            throw new TlsFatalAlert(51);
        }
    }

    static void trackHashAlgorithms(TlsHandshakeHash handshakeHash, Vector supportedSignatureAlgorithms) {
        if (supportedSignatureAlgorithms != null) {
            int i = 0;
            while (i < supportedSignatureAlgorithms.size()) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
                int signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm);
                int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(signatureScheme);
                if (cryptoHashAlgorithm >= 0) {
                    handshakeHash.trackHashAlgorithm(cryptoHashAlgorithm);
                } else if (8 == signatureAndHashAlgorithm.getHash()) {
                    handshakeHash.forceBuffering();
                }
                ++i;
            }
        }
    }

    public static boolean hasSigningCapability(short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static Vector vectorOfOne(Object obj) {
        Vector<Object> v = new Vector<Object>(1);
        v.addElement(obj);
        return v;
    }

    public static int getCipherType(int cipherSuite) {
        int encryptionAlgorithm = TlsUtils.getEncryptionAlgorithm(cipherSuite);
        return TlsUtils.getEncryptionAlgorithmType(encryptionAlgorithm);
    }

    public static int getEncryptionAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 139: 
            case 143: 
            case 147: 
            case 49155: 
            case 49160: 
            case 49165: 
            case 49170: 
            case 49175: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49204: {
                return 7;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 108: 
            case 140: 
            case 144: 
            case 148: 
            case 174: 
            case 178: 
            case 182: 
            case 49156: 
            case 49161: 
            case 49166: 
            case 49171: 
            case 49176: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49205: 
            case 49207: {
                return 8;
            }
            case 4868: 
            case 49308: 
            case 49310: 
            case 49316: 
            case 49318: 
            case 49324: 
            case 53253: {
                return 15;
            }
            case 4869: 
            case 49312: 
            case 49314: 
            case 49320: 
            case 49322: 
            case 49326: 
            case 53251: {
                return 16;
            }
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 4865: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 53249: {
                return 10;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 141: 
            case 145: 
            case 149: 
            case 175: 
            case 179: 
            case 183: 
            case 49157: 
            case 49162: 
            case 49167: 
            case 49172: 
            case 49177: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49206: 
            case 49208: {
                return 9;
            }
            case 49309: 
            case 49311: 
            case 49317: 
            case 49319: 
            case 49325: {
                return 17;
            }
            case 49313: 
            case 49315: 
            case 49321: 
            case 49323: 
            case 49327: {
                return 18;
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 4866: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 53250: {
                return 11;
            }
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: {
                return 22;
            }
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49258: 
            case 49260: 
            case 49262: {
                return 24;
            }
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: {
                return 23;
            }
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49259: 
            case 49261: 
            case 49263: {
                return 25;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 12;
            }
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: {
                return 19;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 13;
            }
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: {
                return 20;
            }
            case 4867: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: {
                return 21;
            }
            case 2: 
            case 44: 
            case 45: 
            case 46: 
            case 49153: 
            case 49158: 
            case 49163: 
            case 49168: 
            case 49173: 
            case 49209: {
                return 0;
            }
            case 59: 
            case 176: 
            case 180: 
            case 184: 
            case 49210: {
                return 0;
            }
            case 177: 
            case 181: 
            case 185: 
            case 49211: {
                return 0;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                return 14;
            }
            case 199: {
                return 26;
            }
            case 198: {
                return 27;
            }
            case 57363: {
                return 28;
            }
        }
        return -1;
    }

    public static int getEncryptionAlgorithmType(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 23: 
            case 28: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
        }
        return -1;
    }

    public static int getKeyExchangeAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 27: 
            case 52: 
            case 58: 
            case 70: 
            case 108: 
            case 109: 
            case 137: 
            case 155: 
            case 166: 
            case 167: 
            case 191: 
            case 197: 
            case 49222: 
            case 49223: 
            case 49242: 
            case 49243: 
            case 49284: 
            case 49285: {
                return 11;
            }
            case 13: 
            case 48: 
            case 54: 
            case 62: 
            case 66: 
            case 104: 
            case 133: 
            case 151: 
            case 164: 
            case 165: 
            case 187: 
            case 193: 
            case 49214: 
            case 49215: 
            case 49240: 
            case 49241: 
            case 49282: 
            case 49283: {
                return 7;
            }
            case 16: 
            case 49: 
            case 55: 
            case 63: 
            case 67: 
            case 105: 
            case 134: 
            case 152: 
            case 160: 
            case 161: 
            case 188: 
            case 194: 
            case 49216: 
            case 49217: 
            case 49236: 
            case 49237: 
            case 49278: 
            case 49279: {
                return 9;
            }
            case 19: 
            case 50: 
            case 56: 
            case 64: 
            case 68: 
            case 106: 
            case 135: 
            case 153: 
            case 162: 
            case 163: 
            case 189: 
            case 195: 
            case 49218: 
            case 49219: 
            case 49238: 
            case 49239: 
            case 49280: 
            case 49281: {
                return 3;
            }
            case 45: 
            case 143: 
            case 144: 
            case 145: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 49254: 
            case 49255: 
            case 49260: 
            case 49261: 
            case 49296: 
            case 49297: 
            case 49302: 
            case 49303: 
            case 49318: 
            case 49319: 
            case 49322: 
            case 49323: 
            case 52397: {
                return 14;
            }
            case 22: 
            case 51: 
            case 57: 
            case 69: 
            case 103: 
            case 107: 
            case 136: 
            case 154: 
            case 158: 
            case 159: 
            case 190: 
            case 196: 
            case 49220: 
            case 49221: 
            case 49234: 
            case 49235: 
            case 49276: 
            case 49277: 
            case 49310: 
            case 49311: 
            case 49314: 
            case 49315: 
            case 52394: {
                return 5;
            }
            case 49173: 
            case 49175: 
            case 49176: 
            case 49177: {
                return 20;
            }
            case 49153: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49189: 
            case 49190: 
            case 49197: 
            case 49198: 
            case 49226: 
            case 49227: 
            case 49246: 
            case 49247: 
            case 49268: 
            case 49269: 
            case 49288: 
            case 49289: {
                return 16;
            }
            case 49163: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49193: 
            case 49194: 
            case 49201: 
            case 49202: 
            case 49230: 
            case 49231: 
            case 49250: 
            case 49251: 
            case 49272: 
            case 49273: 
            case 49292: 
            case 49293: {
                return 18;
            }
            case 49158: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49187: 
            case 49188: 
            case 49195: 
            case 49196: 
            case 49224: 
            case 49225: 
            case 49244: 
            case 49245: 
            case 49266: 
            case 49267: 
            case 49286: 
            case 49287: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52393: {
                return 17;
            }
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 49264: 
            case 49265: 
            case 49306: 
            case 49307: 
            case 52396: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: {
                return 24;
            }
            case 49168: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49191: 
            case 49192: 
            case 49199: 
            case 49200: 
            case 49228: 
            case 49229: 
            case 49248: 
            case 49249: 
            case 49270: 
            case 49271: 
            case 49290: 
            case 49291: 
            case 52392: {
                return 19;
            }
            case 198: 
            case 199: 
            case 4865: 
            case 4866: 
            case 4867: 
            case 4868: 
            case 4869: {
                return 0;
            }
            case 57363: {
                return 25;
            }
            case 44: 
            case 139: 
            case 140: 
            case 141: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 49252: 
            case 49253: 
            case 49258: 
            case 49259: 
            case 49294: 
            case 49295: 
            case 49300: 
            case 49301: 
            case 49316: 
            case 49317: 
            case 49320: 
            case 49321: 
            case 52395: {
                return 13;
            }
            case 2: 
            case 10: 
            case 47: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 132: 
            case 150: 
            case 156: 
            case 157: 
            case 186: 
            case 192: 
            case 49212: 
            case 49213: 
            case 49232: 
            case 49233: 
            case 49274: 
            case 49275: 
            case 49308: 
            case 49309: 
            case 49312: 
            case 49313: {
                return 1;
            }
            case 46: 
            case 147: 
            case 148: 
            case 149: 
            case 172: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 49256: 
            case 49257: 
            case 49262: 
            case 49263: 
            case 49298: 
            case 49299: 
            case 49304: 
            case 49305: 
            case 52398: {
                return 15;
            }
            case 49178: 
            case 49181: 
            case 49184: {
                return 21;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return 22;
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return 23;
            }
        }
        return -1;
    }

    public static Vector getKeyExchangeAlgorithms(int[] cipherSuites) {
        Vector result = new Vector();
        if (cipherSuites != null) {
            int i = 0;
            while (i < cipherSuites.length) {
                TlsUtils.addToSet(result, TlsUtils.getKeyExchangeAlgorithm(cipherSuites[i]));
                ++i;
            }
            result.removeElement(Integers.valueOf(-1));
        }
        return result;
    }

    public static int getMACAlgorithm(int cipherSuite) {
        switch (cipherSuite) {
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 198: 
            case 199: 
            case 4865: 
            case 4866: 
            case 4867: 
            case 4868: 
            case 4869: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: {
                return 0;
            }
            case 57363: {
                return 256;
            }
            case 2: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 49153: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49178: 
            case 49179: 
            case 49180: 
            case 49181: 
            case 49182: 
            case 49183: 
            case 49184: 
            case 49185: 
            case 49186: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49209: {
                return 2;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 174: 
            case 176: 
            case 178: 
            case 180: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49207: 
            case 49210: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49300: 
            case 49302: 
            case 49304: 
            case 49306: {
                return 3;
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49208: 
            case 49211: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                return 4;
            }
        }
        return -1;
    }

    public static ProtocolVersion getMinimumVersion(int cipherSuite) {
        switch (cipherSuite) {
            case 198: 
            case 199: 
            case 4865: 
            case 4866: 
            case 4867: 
            case 4868: 
            case 4869: {
                return ProtocolVersion.TLSv13;
            }
            case 57363: {
                return ProtocolVersion.SMv11;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: 
            case 49212: 
            case 49213: 
            case 49214: 
            case 49215: 
            case 49216: 
            case 49217: 
            case 49218: 
            case 49219: 
            case 49220: 
            case 49221: 
            case 49222: 
            case 49223: 
            case 49224: 
            case 49225: 
            case 49226: 
            case 49227: 
            case 49228: 
            case 49229: 
            case 49230: 
            case 49231: 
            case 49232: 
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: 
            case 49237: 
            case 49238: 
            case 49239: 
            case 49240: 
            case 49241: 
            case 49242: 
            case 49243: 
            case 49244: 
            case 49245: 
            case 49246: 
            case 49247: 
            case 49248: 
            case 49249: 
            case 49250: 
            case 49251: 
            case 49252: 
            case 49253: 
            case 49254: 
            case 49255: 
            case 49256: 
            case 49257: 
            case 49258: 
            case 49259: 
            case 49260: 
            case 49261: 
            case 49262: 
            case 49263: 
            case 49264: 
            case 49265: 
            case 49266: 
            case 49267: 
            case 49268: 
            case 49269: 
            case 49270: 
            case 49271: 
            case 49272: 
            case 49273: 
            case 49274: 
            case 49275: 
            case 49276: 
            case 49277: 
            case 49278: 
            case 49279: 
            case 49280: 
            case 49281: 
            case 49282: 
            case 49283: 
            case 49284: 
            case 49285: 
            case 49286: 
            case 49287: 
            case 49288: 
            case 49289: 
            case 49290: 
            case 49291: 
            case 49292: 
            case 49293: 
            case 49294: 
            case 49295: 
            case 49296: 
            case 49297: 
            case 49298: 
            case 49299: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53250: 
            case 53251: 
            case 53253: {
                return ProtocolVersion.TLSv12;
            }
        }
        return ProtocolVersion.SSLv3;
    }

    public static Vector getNamedGroupRoles(int[] cipherSuites) {
        return TlsUtils.getNamedGroupRoles(TlsUtils.getKeyExchangeAlgorithms(cipherSuites));
    }

    public static Vector getNamedGroupRoles(Vector keyExchangeAlgorithms) {
        Vector result = new Vector();
        int i = 0;
        while (i < keyExchangeAlgorithms.size()) {
            int keyExchangeAlgorithm = (Integer)keyExchangeAlgorithms.elementAt(i);
            switch (keyExchangeAlgorithm) {
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: {
                    TlsUtils.addToSet(result, 1);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 24: {
                    TlsUtils.addToSet(result, 2);
                    break;
                }
                case 16: 
                case 17: {
                    TlsUtils.addToSet(result, 2);
                    TlsUtils.addToSet(result, 3);
                    break;
                }
                case 0: {
                    TlsUtils.addToSet(result, 1);
                    TlsUtils.addToSet(result, 2);
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean isAEADCipherSuite(int cipherSuite) throws IOException {
        return 2 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isBlockCipherSuite(int cipherSuite) throws IOException {
        return 1 == TlsUtils.getCipherType(cipherSuite);
    }

    public static boolean isStreamCipherSuite(int cipherSuite) throws IOException {
        return TlsUtils.getCipherType(cipherSuite) == 0;
    }

    public static boolean isValidCipherSuiteForSignatureAlgorithms(int cipherSuite, Vector sigAlgs) {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        switch (keyExchangeAlgorithm) {
            case 0: 
            case 3: 
            case 5: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 25: {
                return sigAlgs.contains(Shorts.valueOf((short)187));
            }
            default: {
                return true;
            }
        }
        int count = sigAlgs.size();
        int i = 0;
        while (i < count) {
            short signatureAlgorithm;
            Short sigAlg = (Short)sigAlgs.elementAt(i);
            if (sigAlg != null && TlsUtils.isValidSignatureAlgorithmForServerKeyExchange(signatureAlgorithm = sigAlg.shortValue(), keyExchangeAlgorithm)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidCipherSuiteForVersion(int cipherSuite, ProtocolVersion version) {
        return TlsUtils.isValidVersionForCipherSuite(cipherSuite, version);
    }

    static boolean isValidCipherSuiteSelection(int[] offeredCipherSuites, int cipherSuite) {
        return offeredCipherSuites != null && Arrays.contains(offeredCipherSuites, cipherSuite) && cipherSuite != 0 && !CipherSuite.isSCSV(cipherSuite);
    }

    static boolean isValidKeyShareSelection(ProtocolVersion negotiatedVersion, int[] clientSupportedGroups, Hashtable clientAgreements, int keyShareGroup) {
        return clientSupportedGroups != null && Arrays.contains(clientSupportedGroups, keyShareGroup) && !clientAgreements.containsKey(Integers.valueOf(keyShareGroup)) && NamedGroup.canBeNegotiated(keyShareGroup, negotiatedVersion);
    }

    static boolean isValidSignatureAlgorithmForCertificateVerify(short signatureAlgorithm, short[] clientCertificateTypes) {
        short clientCertificateType = SignatureAlgorithm.getClientCertificateType(signatureAlgorithm);
        return clientCertificateType >= 0 && Arrays.contains(clientCertificateTypes, clientCertificateType);
    }

    static boolean isValidSignatureAlgorithmForServerKeyExchange(short signatureAlgorithm, int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 5: 
            case 19: 
            case 23: {
                switch (signatureAlgorithm) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 3: 
            case 22: {
                return 2 == signatureAlgorithm;
            }
            case 17: {
                switch (signatureAlgorithm) {
                    case 3: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return signatureAlgorithm != 0;
            }
        }
        return false;
    }

    public static boolean isValidSignatureSchemeForServerKeyExchange(int signatureScheme, int keyExchangeAlgorithm) {
        short signatureAlgorithm = SignatureScheme.getSignatureAlgorithm(signatureScheme);
        return TlsUtils.isValidSignatureAlgorithmForServerKeyExchange(signatureAlgorithm, keyExchangeAlgorithm);
    }

    public static boolean isValidVersionForCipherSuite(int cipherSuite, ProtocolVersion version) {
        version = version.getEquivalentTLSVersion();
        ProtocolVersion minimumVersion = TlsUtils.getMinimumVersion(cipherSuite);
        if (minimumVersion == version) {
            return true;
        }
        if (!minimumVersion.isEarlierVersionOf(version)) {
            return false;
        }
        return ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(minimumVersion) || ProtocolVersion.TLSv13.isLaterVersionOf(version);
    }

    public static SignatureAndHashAlgorithm chooseSignatureAndHashAlgorithm(TlsContext context, Vector sigHashAlgs, short signatureAlgorithm) throws IOException {
        return TlsUtils.chooseSignatureAndHashAlgorithm(context.getServerVersion(), sigHashAlgs, signatureAlgorithm);
    }

    public static SignatureAndHashAlgorithm chooseSignatureAndHashAlgorithm(ProtocolVersion negotiatedVersion, Vector sigHashAlgs, short signatureAlgorithm) throws IOException {
        if (!TlsUtils.isTLSv12(negotiatedVersion)) {
            return null;
        }
        if (sigHashAlgs == null) {
            sigHashAlgs = TlsUtils.getDefaultSignatureAlgorithms(signatureAlgorithm);
        }
        SignatureAndHashAlgorithm result = null;
        int i = 0;
        while (i < sigHashAlgs.size()) {
            short hash;
            SignatureAndHashAlgorithm sigHashAlg = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i);
            if (sigHashAlg.getSignature() == signatureAlgorithm && (hash = sigHashAlg.getHash()) >= 2) {
                if (result == null) {
                    result = sigHashAlg;
                } else {
                    short current = result.getHash();
                    if (current < 4) {
                        if (hash > current) {
                            result = sigHashAlg;
                        }
                    } else if (hash >= 4 && hash < current) {
                        result = sigHashAlg;
                    }
                }
            }
            ++i;
        }
        if (result == null) {
            throw new TlsFatalAlert(80);
        }
        return result;
    }

    public static Vector getUsableSignatureAlgorithms(Vector sigHashAlgs) {
        if (sigHashAlgs == null) {
            Vector<Short> v = new Vector<Short>(3);
            v.addElement(Shorts.valueOf((short)1));
            v.addElement(Shorts.valueOf((short)2));
            v.addElement(Shorts.valueOf((short)3));
            v.addElement(Shorts.valueOf((short)187));
            return v;
        }
        Vector<Short> v = new Vector<Short>();
        int i = 0;
        while (i < sigHashAlgs.size()) {
            Short sigAlg;
            SignatureAndHashAlgorithm sigHashAlg = (SignatureAndHashAlgorithm)sigHashAlgs.elementAt(i);
            if (sigHashAlg.getHash() >= 2 && !v.contains(sigAlg = Shorts.valueOf(sigHashAlg.getSignature()))) {
                v.addElement(sigAlg);
            }
            ++i;
        }
        return v;
    }

    public static int getCommonCipherSuite13(ProtocolVersion negotiatedVersion, int[] peerCipherSuites, int[] localCipherSuites, boolean useLocalOrder) {
        int[] ordered = peerCipherSuites;
        int[] unordered = localCipherSuites;
        if (useLocalOrder) {
            ordered = localCipherSuites;
            unordered = peerCipherSuites;
        }
        int i = 0;
        while (i < ordered.length) {
            int candidate = ordered[i];
            if (Arrays.contains(unordered, candidate) && TlsUtils.isValidVersionForCipherSuite(candidate, negotiatedVersion)) {
                return candidate;
            }
            ++i;
        }
        return -1;
    }

    public static int[] getCommonCipherSuites(int[] peerCipherSuites, int[] localCipherSuites, boolean useLocalOrder) {
        int[] ordered = peerCipherSuites;
        int[] unordered = localCipherSuites;
        if (useLocalOrder) {
            ordered = localCipherSuites;
            unordered = peerCipherSuites;
        }
        int count = 0;
        int limit = Math.min(ordered.length, unordered.length);
        int[] candidates = new int[limit];
        int i = 0;
        while (i < ordered.length) {
            int candidate = ordered[i];
            if (!TlsUtils.contains(candidates, 0, count, candidate) && Arrays.contains(unordered, candidate)) {
                candidates[count++] = candidate;
            }
            ++i;
        }
        if (count < limit) {
            candidates = Arrays.copyOf(candidates, count);
        }
        return candidates;
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] suites) {
        return TlsUtils.getSupportedCipherSuites(crypto, suites, 0, suites.length);
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] suites, int suitesCount) {
        return TlsUtils.getSupportedCipherSuites(crypto, suites, 0, suitesCount);
    }

    public static int[] getSupportedCipherSuites(TlsCrypto crypto, int[] suites, int suitesOff, int suitesCount) {
        int[] supported = new int[suitesCount];
        int count = 0;
        int i = 0;
        while (i < suitesCount) {
            int suite = suites[suitesOff + i];
            if (TlsUtils.isSupportedCipherSuite(crypto, suite)) {
                supported[count++] = suite;
            }
            ++i;
        }
        if (count < suitesCount) {
            supported = Arrays.copyOf(supported, count);
        }
        return supported;
    }

    public static boolean isSupportedCipherSuite(TlsCrypto crypto, int cipherSuite) {
        return TlsUtils.isSupportedKeyExchange(crypto, TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) && crypto.hasEncryptionAlgorithm(TlsUtils.getEncryptionAlgorithm(cipherSuite)) && crypto.hasMacAlgorithm(TlsUtils.getMACAlgorithm(cipherSuite));
    }

    public static boolean isSupportedKeyExchange(TlsCrypto crypto, int keyExchangeAlgorithm) {
        switch (keyExchangeAlgorithm) {
            case 25: {
                return crypto.hasSM2Agreement();
            }
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                return crypto.hasDHAgreement();
            }
            case 3: {
                return crypto.hasDHAgreement() && crypto.hasSignatureAlgorithm((short)2);
            }
            case 5: {
                return crypto.hasDHAgreement() && TlsUtils.hasAnyRSASigAlgs(crypto);
            }
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                return crypto.hasECDHAgreement();
            }
            case 17: {
                return crypto.hasECDHAgreement() && (crypto.hasSignatureAlgorithm((short)3) || crypto.hasSignatureAlgorithm((short)7) || crypto.hasSignatureAlgorithm((short)8));
            }
            case 19: {
                return crypto.hasECDHAgreement() && TlsUtils.hasAnyRSASigAlgs(crypto);
            }
            case 0: 
            case 13: {
                return true;
            }
            case 1: 
            case 15: {
                return crypto.hasRSAEncryption();
            }
            case 21: {
                return crypto.hasSRPAuthentication();
            }
            case 22: {
                return crypto.hasSRPAuthentication() && crypto.hasSignatureAlgorithm((short)2);
            }
            case 23: {
                return crypto.hasSRPAuthentication() && TlsUtils.hasAnyRSASigAlgs(crypto);
            }
        }
        return false;
    }

    static boolean hasAnyRSASigAlgs(TlsCrypto crypto) {
        return crypto.hasSignatureAlgorithm((short)1) || crypto.hasSignatureAlgorithm((short)4) || crypto.hasSignatureAlgorithm((short)5) || crypto.hasSignatureAlgorithm((short)6) || crypto.hasSignatureAlgorithm((short)9) || crypto.hasSignatureAlgorithm((short)10) || crypto.hasSignatureAlgorithm((short)11);
    }

    static byte[] getCurrentPRFHash(TlsHandshakeHash handshakeHash) {
        return handshakeHash.forkPRFHash().calculateHash();
    }

    static void sealHandshakeHash(TlsContext context, TlsHandshakeHash handshakeHash, boolean forceBuffering) {
        if (forceBuffering || !context.getCrypto().hasAllRawSignatureAlgorithms()) {
            handshakeHash.forceBuffering();
        }
        handshakeHash.sealHashAlgorithms();
    }

    private static TlsHash createHash(TlsCrypto crypto, short hashAlgorithm) {
        int cryptoHashAlgorithm = TlsCryptoUtils.getHash(hashAlgorithm);
        return crypto.createHash(cryptoHashAlgorithm);
    }

    private static TlsKeyExchange createKeyExchangeClient(TlsClient client, int keyExchange) throws IOException {
        TlsKeyExchangeFactory factory = client.getKeyExchangeFactory();
        switch (keyExchange) {
            case 11: {
                return factory.createDHanonKeyExchangeClient(keyExchange, client.getDHGroupVerifier());
            }
            case 7: 
            case 9: {
                return factory.createDHKeyExchange(keyExchange);
            }
            case 3: 
            case 5: {
                return factory.createDHEKeyExchangeClient(keyExchange, client.getDHGroupVerifier());
            }
            case 20: {
                return factory.createECDHanonKeyExchangeClient(keyExchange);
            }
            case 16: 
            case 18: {
                return factory.createECDHKeyExchange(keyExchange);
            }
            case 17: 
            case 19: {
                return factory.createECDHEKeyExchangeClient(keyExchange);
            }
            case 1: {
                return factory.createRSAKeyExchange(keyExchange);
            }
            case 14: {
                return factory.createPSKKeyExchangeClient(keyExchange, client.getPSKIdentity(), client.getDHGroupVerifier());
            }
            case 13: 
            case 15: 
            case 24: {
                return factory.createPSKKeyExchangeClient(keyExchange, client.getPSKIdentity(), null);
            }
            case 21: 
            case 22: 
            case 23: {
                return factory.createSRPKeyExchangeClient(keyExchange, client.getSRPIdentity(), client.getSRPConfigVerifier());
            }
            case 25: {
                return factory.createSM2KeyExchange(keyExchange);
            }
        }
        throw new TlsFatalAlert(80);
    }

    private static TlsKeyExchange createKeyExchangeServer(TlsServer server, int keyExchange) throws IOException {
        TlsKeyExchangeFactory factory = server.getKeyExchangeFactory();
        switch (keyExchange) {
            case 11: {
                return factory.createDHanonKeyExchangeServer(keyExchange, server.getDHConfig());
            }
            case 7: 
            case 9: {
                return factory.createDHKeyExchange(keyExchange);
            }
            case 3: 
            case 5: {
                return factory.createDHEKeyExchangeServer(keyExchange, server.getDHConfig());
            }
            case 20: {
                return factory.createECDHanonKeyExchangeServer(keyExchange, server.getECDHConfig());
            }
            case 16: 
            case 18: {
                return factory.createECDHKeyExchange(keyExchange);
            }
            case 17: 
            case 19: {
                return factory.createECDHEKeyExchangeServer(keyExchange, server.getECDHConfig());
            }
            case 1: {
                return factory.createRSAKeyExchange(keyExchange);
            }
            case 14: {
                return factory.createPSKKeyExchangeServer(keyExchange, server.getPSKIdentityManager(), server.getDHConfig(), null);
            }
            case 24: {
                return factory.createPSKKeyExchangeServer(keyExchange, server.getPSKIdentityManager(), null, server.getECDHConfig());
            }
            case 13: 
            case 15: {
                return factory.createPSKKeyExchangeServer(keyExchange, server.getPSKIdentityManager(), null, null);
            }
            case 21: 
            case 22: 
            case 23: {
                return factory.createSRPKeyExchangeServer(keyExchange, server.getSRPLoginParameters());
            }
        }
        throw new TlsFatalAlert(80);
    }

    static TlsKeyExchange initKeyExchangeClient(TlsClientContext clientContext, TlsClient client) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        TlsKeyExchange keyExchange = TlsUtils.createKeyExchangeClient(client, securityParameters.getKeyExchangeAlgorithm());
        keyExchange.init(clientContext);
        return keyExchange;
    }

    static TlsKeyExchange initKeyExchangeServer(TlsServerContext serverContext, TlsServer server) throws IOException {
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        TlsKeyExchange keyExchange = TlsUtils.createKeyExchangeServer(server, securityParameters.getKeyExchangeAlgorithm());
        keyExchange.init(serverContext);
        return keyExchange;
    }

    static TlsCipher initCipher(TlsContext context) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        int cipherSuite = securityParameters.getCipherSuite();
        int encryptionAlgorithm = TlsUtils.getEncryptionAlgorithm(cipherSuite);
        int macAlgorithm = TlsUtils.getMACAlgorithm(cipherSuite);
        if (encryptionAlgorithm < 0 || macAlgorithm < 0) {
            throw new TlsFatalAlert(80);
        }
        return context.getCrypto().createCipher(new TlsCryptoParameters(context), encryptionAlgorithm, macAlgorithm);
    }

    public static void checkPeerSigAlgs(TlsContext context, TlsCertificate[] peerCertPath) throws IOException {
        if (context.isServer()) {
            TlsUtils.checkSigAlgOfClientCerts(context, peerCertPath);
        } else {
            TlsUtils.checkSigAlgOfServerCerts(context, peerCertPath);
        }
    }

    private static void checkSigAlgOfClientCerts(TlsContext context, TlsCertificate[] clientCertPath) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        short[] clientCertTypes = securityParameters.getClientCertTypes();
        Vector serverSigAlgsCert = securityParameters.getServerSigAlgsCert();
        int trustAnchorPos = clientCertPath.length - 1;
        int i = 0;
        while (i < trustAnchorPos) {
            TlsCertificate subjectCert = clientCertPath[i];
            TlsCertificate issuerCert = clientCertPath[i + 1];
            SignatureAndHashAlgorithm sigAndHashAlg = TlsUtils.getCertSigAndHashAlg(subjectCert, issuerCert);
            boolean valid = false;
            if (sigAndHashAlg != null) {
                if (serverSigAlgsCert == null) {
                    if (clientCertTypes != null) {
                        int j = 0;
                        while (j < clientCertTypes.length) {
                            short signatureAlgorithm = TlsUtils.getLegacySignatureAlgorithmClientCert(clientCertTypes[j]);
                            if (sigAndHashAlg.getSignature() == signatureAlgorithm) {
                                valid = true;
                                break;
                            }
                            ++j;
                        }
                    }
                } else {
                    valid = TlsUtils.containsSignatureAlgorithm(serverSigAlgsCert, sigAndHashAlg);
                }
            }
            if (!valid) {
                throw new TlsFatalAlert(42);
            }
            ++i;
        }
    }

    private static void checkSigAlgOfServerCerts(TlsContext context, TlsCertificate[] serverCertPath) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        Vector clientSigAlgsCert = securityParameters.getClientSigAlgsCert();
        Vector clientSigAlgs = securityParameters.getClientSigAlgs();
        if (clientSigAlgs == clientSigAlgsCert || TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            clientSigAlgs = null;
        }
        int trustAnchorPos = serverCertPath.length - 1;
        int i = 0;
        while (i < trustAnchorPos) {
            TlsCertificate subjectCert = serverCertPath[i];
            TlsCertificate issuerCert = serverCertPath[i + 1];
            SignatureAndHashAlgorithm sigAndHashAlg = TlsUtils.getCertSigAndHashAlg(subjectCert, issuerCert);
            boolean valid = false;
            if (sigAndHashAlg != null) {
                if (clientSigAlgsCert == null) {
                    short signatureAlgorithm = TlsUtils.getLegacySignatureAlgorithmServerCert(securityParameters.getKeyExchangeAlgorithm());
                    valid = signatureAlgorithm == sigAndHashAlg.getSignature();
                } else {
                    boolean bl = valid = TlsUtils.containsSignatureAlgorithm(clientSigAlgsCert, sigAndHashAlg) || clientSigAlgs != null && TlsUtils.containsSignatureAlgorithm(clientSigAlgs, sigAndHashAlg);
                }
            }
            if (!valid) {
                throw new TlsFatalAlert(42);
            }
            ++i;
        }
    }

    static void checkTlsFeatures(Certificate serverCertificate, Hashtable clientExtensions, Hashtable serverExtensions) throws IOException {
        byte[] tlsFeatures = serverCertificate.getCertificateAt(0).getExtension(TlsObjectIdentifiers.id_pe_tlsfeature);
        if (tlsFeatures != null) {
            ASN1Sequence tlsFeaturesSeq = (ASN1Sequence)TlsUtils.readASN1Object(tlsFeatures);
            int i = 0;
            while (i < tlsFeaturesSeq.size()) {
                if (!(tlsFeaturesSeq.getObjectAt(i) instanceof ASN1Integer)) {
                    throw new TlsFatalAlert(42);
                }
                ++i;
            }
            TlsUtils.requireDEREncoding(tlsFeaturesSeq, tlsFeatures);
            i = 0;
            while (i < tlsFeaturesSeq.size()) {
                Integer extensionType;
                BigInteger tlsExtension = ((ASN1Integer)tlsFeaturesSeq.getObjectAt(i)).getPositiveValue();
                if (tlsExtension.bitLength() <= 16 && clientExtensions.containsKey(extensionType = Integers.valueOf(tlsExtension.intValue())) && !serverExtensions.containsKey(extensionType)) {
                    throw new TlsFatalAlert(46);
                }
                ++i;
            }
        }
    }

    static void processClientCertificate(TlsServerContext serverContext, Certificate clientCertificate, TlsKeyExchange keyExchange, TlsServer server) throws IOException {
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        if (securityParameters.getPeerCertificate() != null) {
            throw new TlsFatalAlert(10);
        }
        boolean isTLSv13 = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        if (!isTLSv13) {
            if (clientCertificate.isEmpty()) {
                keyExchange.skipClientCredentials();
            } else {
                keyExchange.processClientCertificate(clientCertificate);
            }
        }
        securityParameters.peerCertificate = clientCertificate;
        server.notifyClientCertificate(clientCertificate);
    }

    static void processServerCertificate(TlsClientContext clientContext, CertificateStatus serverCertificateStatus, TlsKeyExchange keyExchange, TlsAuthentication clientAuthentication, Hashtable clientExtensions, Hashtable serverExtensions) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        boolean isTLSv13 = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        if (clientAuthentication == null) {
            if (isTLSv13) {
                throw new TlsFatalAlert(80);
            }
            if (securityParameters.isRenegotiating()) {
                throw new TlsFatalAlert(40);
            }
            keyExchange.skipServerCredentials();
            securityParameters.tlsServerEndPoint = EMPTY_BYTES;
            return;
        }
        Certificate serverCertificate = securityParameters.getPeerCertificate();
        TlsUtils.checkTlsFeatures(serverCertificate, clientExtensions, serverExtensions);
        if (!isTLSv13) {
            keyExchange.processServerCertificate(serverCertificate);
        }
        clientAuthentication.notifyServerCertificate(new TlsServerCertificateImpl(serverCertificate, serverCertificateStatus));
    }

    static SignatureAndHashAlgorithm getCertSigAndHashAlg(TlsCertificate subjectCert, TlsCertificate issuerCert) throws IOException {
        String sigAlgOID = subjectCert.getSigAlgOID();
        if (sigAlgOID != null) {
            if (!PKCSObjectIdentifiers.id_RSASSA_PSS.getId().equals(sigAlgOID)) {
                return (SignatureAndHashAlgorithm)CERT_SIG_ALG_OIDS.get(sigAlgOID);
            }
            RSASSAPSSparams pssParams = RSASSAPSSparams.getInstance(subjectCert.getSigAlgParams());
            if (pssParams != null) {
                ASN1ObjectIdentifier hashOID = pssParams.getHashAlgorithm().getAlgorithm();
                if (NISTObjectIdentifiers.id_sha256.equals(hashOID)) {
                    if (issuerCert.supportsSignatureAlgorithmCA((short)9)) {
                        return SignatureAndHashAlgorithm.rsa_pss_pss_sha256;
                    }
                    if (issuerCert.supportsSignatureAlgorithmCA((short)4)) {
                        return SignatureAndHashAlgorithm.rsa_pss_rsae_sha256;
                    }
                } else if (NISTObjectIdentifiers.id_sha384.equals(hashOID)) {
                    if (issuerCert.supportsSignatureAlgorithmCA((short)10)) {
                        return SignatureAndHashAlgorithm.rsa_pss_pss_sha384;
                    }
                    if (issuerCert.supportsSignatureAlgorithmCA((short)5)) {
                        return SignatureAndHashAlgorithm.rsa_pss_rsae_sha384;
                    }
                } else if (NISTObjectIdentifiers.id_sha512.equals(hashOID)) {
                    if (issuerCert.supportsSignatureAlgorithmCA((short)11)) {
                        return SignatureAndHashAlgorithm.rsa_pss_pss_sha512;
                    }
                    if (issuerCert.supportsSignatureAlgorithmCA((short)6)) {
                        return SignatureAndHashAlgorithm.rsa_pss_rsae_sha512;
                    }
                }
            }
        }
        return null;
    }

    static CertificateRequest validateCertificateRequest(CertificateRequest certificateRequest, TlsKeyExchange keyExchange) throws IOException {
        short[] validClientCertificateTypes = keyExchange.getClientCertificateTypes();
        if (TlsUtils.isNullOrEmpty(validClientCertificateTypes)) {
            throw new TlsFatalAlert(10);
        }
        if (!Arrays.contains(validClientCertificateTypes, (short)256)) {
            certificateRequest = TlsUtils.normalizeCertificateRequest(certificateRequest, validClientCertificateTypes);
        }
        if (certificateRequest == null) {
            throw new TlsFatalAlert(47);
        }
        return certificateRequest;
    }

    static CertificateRequest normalizeCertificateRequest(CertificateRequest certificateRequest, short[] validClientCertificateTypes) {
        if (TlsUtils.containsAll(validClientCertificateTypes, certificateRequest.getCertificateTypes())) {
            return certificateRequest;
        }
        short[] retained = TlsUtils.retainAll(certificateRequest.getCertificateTypes(), validClientCertificateTypes);
        if (retained.length < 1) {
            return null;
        }
        return new CertificateRequest(retained, certificateRequest.getSupportedSignatureAlgorithms(), certificateRequest.getCertificateAuthorities());
    }

    static boolean contains(int[] buf, int off, int len, int value) {
        int i = 0;
        while (i < len) {
            if (value == buf[off + i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean containsAll(short[] container, short[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!Arrays.contains(container, elements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static short[] retainAll(short[] retainer, short[] elements) {
        short[] retained = new short[Math.min(retainer.length, elements.length)];
        int count = 0;
        int i = 0;
        while (i < elements.length) {
            if (Arrays.contains(retainer, elements[i])) {
                retained[count++] = elements[i];
            }
            ++i;
        }
        return TlsUtils.truncate(retained, count);
    }

    static short[] truncate(short[] a, int n) {
        if (n >= a.length) {
            return a;
        }
        short[] t = new short[n];
        System.arraycopy(a, 0, t, 0, n);
        return t;
    }

    static int[] truncate(int[] a, int n) {
        if (n >= a.length) {
            return a;
        }
        int[] t = new int[n];
        System.arraycopy(a, 0, t, 0, n);
        return t;
    }

    static TlsCredentialedAgreement requireAgreementCredentials(TlsCredentials credentials) throws IOException {
        if (!(credentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedAgreement)credentials;
    }

    static TlsCredentialedDecryptor requireDecryptorCredentials(TlsCredentials credentials) throws IOException {
        if (!(credentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedDecryptor)credentials;
    }

    static TlsCredentialedSigner requireSignerCredentials(TlsCredentials credentials) throws IOException {
        if (!(credentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedSigner)credentials;
    }

    private static void checkDowngradeMarker(byte[] randomBlock, byte[] downgradeMarker) throws IOException {
        int len = downgradeMarker.length;
        if (TlsUtils.constantTimeAreEqual(len, downgradeMarker, 0, randomBlock, randomBlock.length - len)) {
            throw new TlsFatalAlert(47);
        }
    }

    static void checkDowngradeMarker(ProtocolVersion version, byte[] randomBlock) throws IOException {
        if ((version = version.getEquivalentTLSVersion()).isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            TlsUtils.checkDowngradeMarker(randomBlock, DOWNGRADE_TLS11);
        }
        if (version.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv12)) {
            TlsUtils.checkDowngradeMarker(randomBlock, DOWNGRADE_TLS12);
        }
    }

    static void writeDowngradeMarker(ProtocolVersion version, byte[] randomBlock) throws IOException {
        byte[] marker;
        if (ProtocolVersion.TLSv12 == (version = version.getEquivalentTLSVersion())) {
            marker = DOWNGRADE_TLS12;
        } else if (version.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            marker = DOWNGRADE_TLS11;
        } else {
            throw new TlsFatalAlert(80);
        }
        System.arraycopy(marker, 0, randomBlock, randomBlock.length - marker.length, marker.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean areCertificatesEqual(Certificate a, Certificate b) {
        int length = a.getLength();
        if (b.getLength() == length) {
            try {
                int i = 0;
                while (true) {
                    if (i >= length) {
                        return true;
                    }
                    TlsCertificate ai = a.getCertificateAt(i);
                    TlsCertificate bi = b.getCertificateAt(i);
                    if (!Arrays.areEqual(ai.getEncoded(), bi.getEncoded())) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isSafeRenegotiationServerCertificate(TlsClientContext clientContext, Certificate serverCertificate) {
        Certificate previousCertificate;
        SecurityParameters securityParametersConnection = clientContext.getSecurityParametersConnection();
        if (securityParametersConnection != null && (previousCertificate = securityParametersConnection.getPeerCertificate()) != null) {
            return TlsUtils.areCertificatesEqual(previousCertificate, serverCertificate);
        }
        return false;
    }

    static TlsAuthentication receiveServerCertificate(TlsClientContext clientContext, TlsClient client, ByteArrayInputStream buf) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        if (securityParameters.getPeerCertificate() != null) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayOutputStream endPointHash = new ByteArrayOutputStream();
        Certificate.ParseOptions options = new Certificate.ParseOptions().setMaxChainLength(client.getMaxCertificateChainLength());
        Certificate serverCertificate = Certificate.parse(options, clientContext, buf, endPointHash);
        TlsProtocol.assertEmpty(buf);
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(50);
        }
        if (securityParameters.isRenegotiating() && !TlsUtils.isSafeRenegotiationServerCertificate(clientContext, serverCertificate)) {
            throw new TlsFatalAlert(46, "Server certificate changed unsafely in renegotiation handshake");
        }
        securityParameters.peerCertificate = serverCertificate;
        securityParameters.tlsServerEndPoint = endPointHash.toByteArray();
        TlsAuthentication authentication = client.getAuthentication();
        if (authentication == null) {
            throw new TlsFatalAlert(80);
        }
        return authentication;
    }

    static TlsAuthentication receive13ServerCertificate(TlsClientContext clientContext, TlsClient client, ByteArrayInputStream buf) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        if (securityParameters.getPeerCertificate() != null) {
            throw new TlsFatalAlert(10);
        }
        Certificate.ParseOptions options = new Certificate.ParseOptions().setMaxChainLength(client.getMaxCertificateChainLength());
        Certificate serverCertificate = Certificate.parse(options, clientContext, buf, null);
        TlsProtocol.assertEmpty(buf);
        if (serverCertificate.getCertificateRequestContext().length > 0) {
            throw new TlsFatalAlert(47);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(50);
        }
        securityParameters.peerCertificate = serverCertificate;
        securityParameters.tlsServerEndPoint = null;
        TlsAuthentication authentication = client.getAuthentication();
        if (authentication == null) {
            throw new TlsFatalAlert(80);
        }
        return authentication;
    }

    static TlsAuthentication skip13ServerCertificate(TlsClientContext clientContext) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        if (securityParameters.getPeerCertificate() != null) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.peerCertificate = null;
        securityParameters.tlsServerEndPoint = null;
        return null;
    }

    public static boolean containsNonAscii(byte[] bs) {
        int i = 0;
        while (i < bs.length) {
            int c = bs[i] & 0xFF;
            if (c >= 128) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsNonAscii(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\u0080') {
                return true;
            }
            ++i;
        }
        return false;
    }

    static Hashtable addKeyShareToClientHello(TlsClientContext clientContext, TlsClient client, Hashtable clientExtensions) throws IOException {
        if (!TlsUtils.isTLSv13(clientContext.getClientVersion()) || !clientExtensions.containsKey(TlsExtensionsUtils.EXT_supported_groups)) {
            return null;
        }
        int[] supportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(clientExtensions);
        Vector keyShareGroups = client.getEarlyKeyShareGroups();
        Hashtable clientAgreements = new Hashtable(3);
        Vector clientShares = new Vector(2);
        TlsUtils.collectKeyShares(clientContext.getCrypto(), supportedGroups, keyShareGroups, clientAgreements, clientShares);
        TlsExtensionsUtils.addKeyShareClientHello(clientExtensions, clientShares);
        return clientAgreements;
    }

    static Hashtable addKeyShareToClientHelloRetry(TlsClientContext clientContext, Hashtable clientExtensions, int keyShareGroup) throws IOException {
        int[] supportedGroups = new int[]{keyShareGroup};
        Vector keyShareGroups = TlsUtils.vectorOfOne(Integers.valueOf(keyShareGroup));
        Hashtable clientAgreements = new Hashtable(1, 1.0f);
        Vector clientShares = new Vector(1);
        TlsUtils.collectKeyShares(clientContext.getCrypto(), supportedGroups, keyShareGroups, clientAgreements, clientShares);
        TlsExtensionsUtils.addKeyShareClientHello(clientExtensions, clientShares);
        if (clientAgreements.isEmpty() || clientShares.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        return clientAgreements;
    }

    private static void collectKeyShares(TlsCrypto crypto, int[] supportedGroups, Vector keyShareGroups, Hashtable clientAgreements, Vector clientShares) throws IOException {
        if (TlsUtils.isNullOrEmpty(supportedGroups)) {
            return;
        }
        if (keyShareGroups == null || keyShareGroups.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < supportedGroups.length) {
            int supportedGroup = supportedGroups[i];
            Integer supportedGroupElement = Integers.valueOf(supportedGroup);
            if (keyShareGroups.contains(supportedGroupElement) && !clientAgreements.containsKey(supportedGroupElement) && crypto.hasNamedGroup(supportedGroup)) {
                TlsAgreement agreement = null;
                if (NamedGroup.refersToASpecificCurve(supportedGroup)) {
                    if (crypto.hasECDHAgreement()) {
                        agreement = crypto.createECDomain(new TlsECConfig(supportedGroup)).createECDH();
                    }
                } else if (NamedGroup.refersToASpecificFiniteField(supportedGroup) && crypto.hasDHAgreement()) {
                    agreement = crypto.createDHDomain(new TlsDHConfig(supportedGroup, true)).createDH();
                }
                if (agreement != null) {
                    byte[] key_exchange = agreement.generateEphemeral();
                    KeyShareEntry clientShare = new KeyShareEntry(supportedGroup, key_exchange);
                    clientShares.addElement(clientShare);
                    clientAgreements.put(supportedGroupElement, agreement);
                }
            }
            ++i;
        }
    }

    static KeyShareEntry selectKeyShare(Vector clientShares, int keyShareGroup) {
        KeyShareEntry clientShare;
        if (clientShares != null && 1 == clientShares.size() && (clientShare = (KeyShareEntry)clientShares.elementAt(0)) != null && clientShare.getNamedGroup() == keyShareGroup) {
            return clientShare;
        }
        return null;
    }

    static KeyShareEntry selectKeyShare(TlsCrypto crypto, ProtocolVersion negotiatedVersion, Vector clientShares, int[] clientSupportedGroups, int[] serverSupportedGroups) {
        if (clientShares != null && !TlsUtils.isNullOrEmpty(clientSupportedGroups) && !TlsUtils.isNullOrEmpty(serverSupportedGroups)) {
            int i = 0;
            while (i < clientShares.size()) {
                KeyShareEntry clientShare = (KeyShareEntry)clientShares.elementAt(i);
                int group = clientShare.getNamedGroup();
                if (NamedGroup.canBeNegotiated(group, negotiatedVersion) && Arrays.contains(serverSupportedGroups, group) && Arrays.contains(clientSupportedGroups, group) && crypto.hasNamedGroup(group) && (!NamedGroup.refersToASpecificCurve(group) || crypto.hasECDHAgreement()) && (!NamedGroup.refersToASpecificFiniteField(group) || crypto.hasDHAgreement())) {
                    return clientShare;
                }
                ++i;
            }
        }
        return null;
    }

    static int selectKeyShareGroup(TlsCrypto crypto, ProtocolVersion negotiatedVersion, int[] clientSupportedGroups, int[] serverSupportedGroups) {
        if (!TlsUtils.isNullOrEmpty(clientSupportedGroups) && !TlsUtils.isNullOrEmpty(serverSupportedGroups)) {
            int i = 0;
            while (i < clientSupportedGroups.length) {
                int group = clientSupportedGroups[i];
                if (NamedGroup.canBeNegotiated(group, negotiatedVersion) && Arrays.contains(serverSupportedGroups, group) && crypto.hasNamedGroup(group) && (!NamedGroup.refersToASpecificCurve(group) || crypto.hasECDHAgreement()) && (!NamedGroup.refersToASpecificFiniteField(group) || crypto.hasDHAgreement())) {
                    return group;
                }
                ++i;
            }
        }
        return -1;
    }

    static byte[] readEncryptedPMS(TlsContext context, InputStream input) throws IOException {
        if (TlsUtils.isSSL(context)) {
            return SSL3Utils.readEncryptedPMS(input);
        }
        return TlsUtils.readOpaque16(input);
    }

    static void writeEncryptedPMS(TlsContext context, byte[] encryptedPMS, OutputStream output) throws IOException {
        if (TlsUtils.isSSL(context)) {
            SSL3Utils.writeEncryptedPMS(encryptedPMS, output);
        } else {
            TlsUtils.writeOpaque16(encryptedPMS, output);
        }
    }

    static byte[] getSessionID(TlsSession tlsSession) {
        byte[] sessionID;
        if (tlsSession != null && (sessionID = tlsSession.getSessionID()) != null && sessionID.length > 0 && sessionID.length <= 32) {
            return sessionID;
        }
        return EMPTY_BYTES;
    }

    static void adjustTranscriptForRetry(TlsHandshakeHash handshakeHash) throws IOException {
        byte[] clientHelloHash = TlsUtils.getCurrentPRFHash(handshakeHash);
        handshakeHash.reset();
        int length = clientHelloHash.length;
        TlsUtils.checkUint8(length);
        byte[] synthetic = new byte[4 + length];
        TlsUtils.writeUint8((short)254, synthetic, 0);
        TlsUtils.writeUint24(length, synthetic, 1);
        System.arraycopy(clientHelloHash, 0, synthetic, 4, length);
        handshakeHash.update(synthetic, 0, synthetic.length);
    }

    static TlsCredentials establishClientCredentials(TlsAuthentication clientAuthentication, CertificateRequest certificateRequest) throws IOException {
        return TlsUtils.validateCredentials(clientAuthentication.getClientCredentials(certificateRequest));
    }

    static TlsCredentialedSigner establish13ClientCredentials(TlsAuthentication clientAuthentication, CertificateRequest certificateRequest) throws IOException {
        return TlsUtils.validate13Credentials(clientAuthentication.getClientCredentials(certificateRequest));
    }

    static void establishClientSigAlgs(SecurityParameters securityParameters, Hashtable clientExtensions) throws IOException {
        securityParameters.clientSigAlgs = TlsExtensionsUtils.getSignatureAlgorithmsExtension(clientExtensions);
        securityParameters.clientSigAlgsCert = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(clientExtensions);
    }

    static TlsCredentials establishServerCredentials(TlsServer server) throws IOException {
        return TlsUtils.validateCredentials(server.getCredentials());
    }

    static TlsCredentialedSigner establish13ServerCredentials(TlsServer server) throws IOException {
        return TlsUtils.validate13Credentials(server.getCredentials());
    }

    static void establishServerSigAlgs(SecurityParameters securityParameters, CertificateRequest certificateRequest) throws IOException {
        securityParameters.clientCertTypes = certificateRequest.getCertificateTypes();
        securityParameters.serverSigAlgs = certificateRequest.getSupportedSignatureAlgorithms();
        securityParameters.serverSigAlgsCert = certificateRequest.getSupportedSignatureAlgorithmsCert();
        if (securityParameters.getServerSigAlgsCert() == null) {
            securityParameters.serverSigAlgsCert = securityParameters.getServerSigAlgs();
        }
    }

    static TlsCredentials validateCredentials(TlsCredentials credentials) throws IOException {
        if (credentials != null) {
            int count = 0;
            count += credentials instanceof TlsCredentialedAgreement ? 1 : 0;
            count += credentials instanceof TlsCredentialedDecryptor ? 1 : 0;
            if ((count += credentials instanceof TlsCredentialedSigner ? 1 : 0) != 1) {
                throw new TlsFatalAlert(80);
            }
        }
        return credentials;
    }

    static TlsCredentialedSigner validate13Credentials(TlsCredentials credentials) throws IOException {
        if (credentials == null) {
            return null;
        }
        if (!(credentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        return (TlsCredentialedSigner)credentials;
    }

    static void negotiatedCipherSuite(SecurityParameters securityParameters, int cipherSuite) throws IOException {
        int prfAlgorithm;
        securityParameters.cipherSuite = cipherSuite;
        securityParameters.keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        securityParameters.prfAlgorithm = prfAlgorithm = TlsUtils.getPRFAlgorithm(securityParameters, cipherSuite);
        switch (prfAlgorithm) {
            case 0: 
            case 1: {
                securityParameters.prfCryptoHashAlgorithm = -1;
                securityParameters.prfHashAlgorithm = (short)-1;
                securityParameters.prfHashLength = -1;
                break;
            }
            default: {
                int prfCryptoHashAlgorithm;
                securityParameters.prfCryptoHashAlgorithm = prfCryptoHashAlgorithm = TlsCryptoUtils.getHashForPRF(prfAlgorithm);
                securityParameters.prfHashAlgorithm = TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm);
                securityParameters.prfHashLength = TlsCryptoUtils.getHashOutputSize(prfCryptoHashAlgorithm);
            }
        }
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        securityParameters.verifyDataLength = TlsUtils.isTLSv13(negotiatedVersion) ? securityParameters.getPRFHashLength() : (negotiatedVersion.isSSL() ? 36 : 12);
    }

    static void negotiatedVersion(SecurityParameters securityParameters) throws IOException {
        if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(securityParameters.getNegotiatedVersion())) {
            securityParameters.clientSigAlgs = null;
            securityParameters.clientSigAlgsCert = null;
            return;
        }
        if (securityParameters.getClientSigAlgs() == null) {
            securityParameters.clientSigAlgs = TlsUtils.getLegacySupportedSignatureAlgorithms();
        }
        if (securityParameters.getClientSigAlgsCert() == null) {
            securityParameters.clientSigAlgsCert = securityParameters.getClientSigAlgs();
        }
    }

    static void negotiatedVersionDTLSClient(TlsClientContext clientContext, TlsClient client) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (!ProtocolVersion.isSupportedDTLSVersionClient(negotiatedVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedVersion(securityParameters);
        client.notifyServerVersion(negotiatedVersion);
    }

    static void negotiatedVersionDTLSServer(TlsServerContext serverContext) throws IOException {
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (!ProtocolVersion.isSupportedDTLSVersionServer(negotiatedVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedVersion(securityParameters);
    }

    static void negotiatedVersionTLSClient(TlsClientContext clientContext, TlsClient client) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (!ProtocolVersion.isSupportedTLSVersionClient(negotiatedVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedVersion(securityParameters);
        client.notifyServerVersion(negotiatedVersion);
    }

    static void negotiatedVersionTLSServer(TlsServerContext serverContext) throws IOException {
        SecurityParameters securityParameters = serverContext.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (!ProtocolVersion.isSupportedTLSVersionServer(negotiatedVersion)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.negotiatedVersion(securityParameters);
    }

    static TlsSecret deriveSecret(SecurityParameters securityParameters, TlsSecret secret, String label, byte[] transcriptHash) throws IOException {
        int prfCryptoHashAlgorithm = securityParameters.getPRFCryptoHashAlgorithm();
        int prfHashLength = securityParameters.getPRFHashLength();
        return TlsUtils.deriveSecret(prfCryptoHashAlgorithm, prfHashLength, secret, label, transcriptHash);
    }

    static TlsSecret deriveSecret(int prfCryptoHashAlgorithm, int prfHashLength, TlsSecret secret, String label, byte[] transcriptHash) throws IOException {
        if (transcriptHash.length != prfHashLength) {
            throw new TlsFatalAlert(80);
        }
        return TlsCryptoUtils.hkdfExpandLabel(secret, prfCryptoHashAlgorithm, label, transcriptHash, prfHashLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TlsSecret getSessionMasterSecret(TlsCrypto crypto, TlsSecret masterSecret) {
        if (masterSecret != null) {
            TlsSecret tlsSecret = masterSecret;
            synchronized (tlsSecret) {
                if (masterSecret.isAlive()) {
                    return crypto.adoptSecret(masterSecret);
                }
            }
        }
        return null;
    }

    static boolean isPermittedExtensionType13(int handshakeType, int extensionType) {
        switch (extensionType) {
            case 0: 
            case 1: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                switch (handshakeType) {
                    case 1: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 5: 
            case 18: {
                switch (handshakeType) {
                    case 1: 
                    case 11: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 13: 
            case 47: 
            case 50: {
                switch (handshakeType) {
                    case 1: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 21: 
            case 45: 
            case 49: {
                switch (handshakeType) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
            case 43: 
            case 51: {
                switch (handshakeType) {
                    case 1: 
                    case 2: 
                    case 6: {
                        return true;
                    }
                }
                return false;
            }
            case 41: {
                switch (handshakeType) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                }
                return false;
            }
            case 42: {
                switch (handshakeType) {
                    case 1: 
                    case 4: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 44: {
                switch (handshakeType) {
                    case 1: 
                    case 6: {
                        return true;
                    }
                }
                return false;
            }
            case 48: {
                switch (handshakeType) {
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
        }
        return !ExtensionType.isRecognized(extensionType);
    }

    static void checkExtensionData13(Hashtable extensions, int handshakeType, short alertDescription) throws IOException {
        Enumeration e = extensions.keys();
        while (e.hasMoreElements()) {
            Integer extensionType = (Integer)e.nextElement();
            if (extensionType != null && TlsUtils.isPermittedExtensionType13(handshakeType, extensionType)) continue;
            throw new TlsFatalAlert(alertDescription, "Invalid extension: " + ExtensionType.getText(extensionType));
        }
    }

    public static TlsSecret generateEncryptedPreMasterSecret(TlsContext context, TlsEncryptor encryptor, OutputStream output) throws IOException {
        ProtocolVersion version = context.getRSAPreMasterSecretVersion();
        TlsSecret preMasterSecret = context.getCrypto().generateRSAPreMasterSecret(version);
        byte[] encryptedPreMasterSecret = preMasterSecret.encrypt(encryptor);
        TlsUtils.writeEncryptedPMS(context, encryptedPreMasterSecret, output);
        return preMasterSecret;
    }

    static void addPreSharedKeyToClientExtensions(TlsPSK[] psks, Hashtable clientExtensions) throws IOException {
        Vector<PskIdentity> identities = new Vector<PskIdentity>(psks.length);
        int i = 0;
        while (i < psks.length) {
            TlsPSK psk = psks[i];
            identities.add(new PskIdentity(psk.getIdentity(), 0L));
            ++i;
        }
        TlsExtensionsUtils.addPreSharedKeyClientHello(clientExtensions, new OfferedPsks(identities));
    }

    static OfferedPsks.BindersConfig addPreSharedKeyToClientHello(TlsClientContext clientContext, TlsClient client, Hashtable clientExtensions, int[] offeredCipherSuites) throws IOException {
        if (!TlsUtils.isTLSv13(clientContext.getClientVersion())) {
            return null;
        }
        TlsPSK[] pskExternals = TlsUtils.getPSKExternalsClient(client, offeredCipherSuites);
        if (pskExternals == null) {
            return null;
        }
        short[] pskKeyExchangeModes = client.getPskKeyExchangeModes();
        if (TlsUtils.isNullOrEmpty(pskKeyExchangeModes)) {
            throw new TlsFatalAlert(80, "External PSKs configured but no PskKeyExchangeMode available");
        }
        TlsSecret[] pskEarlySecrets = TlsUtils.getPSKEarlySecrets(clientContext.getCrypto(), pskExternals);
        int bindersSize = OfferedPsks.getBindersSize(pskExternals);
        TlsUtils.addPreSharedKeyToClientExtensions(pskExternals, clientExtensions);
        TlsExtensionsUtils.addPSKKeyExchangeModesExtension(clientExtensions, pskKeyExchangeModes);
        return new OfferedPsks.BindersConfig(pskExternals, pskKeyExchangeModes, pskEarlySecrets, bindersSize);
    }

    static OfferedPsks.BindersConfig addPreSharedKeyToClientHelloRetry(TlsClientContext clientContext, OfferedPsks.BindersConfig clientBinders, Hashtable clientExtensions) throws IOException {
        SecurityParameters securityParameters = clientContext.getSecurityParametersHandshake();
        int prfAlgorithm = TlsUtils.getPRFAlgorithm13(securityParameters.getCipherSuite());
        Vector pskIndices = TlsUtils.getPSKIndices(clientBinders.psks, prfAlgorithm);
        if (pskIndices.isEmpty()) {
            return null;
        }
        OfferedPsks.BindersConfig result = clientBinders;
        int count = pskIndices.size();
        if (count < clientBinders.psks.length) {
            TlsPSK[] psks = new TlsPSK[count];
            TlsSecret[] earlySecrets = new TlsSecret[count];
            int i = 0;
            while (i < count) {
                int j = (Integer)pskIndices.elementAt(i);
                psks[i] = clientBinders.psks[j];
                earlySecrets[i] = clientBinders.earlySecrets[j];
                ++i;
            }
            int bindersSize = OfferedPsks.getBindersSize(psks);
            result = new OfferedPsks.BindersConfig(psks, clientBinders.pskKeyExchangeModes, earlySecrets, bindersSize);
        }
        TlsUtils.addPreSharedKeyToClientExtensions(result.psks, clientExtensions);
        return result;
    }

    static OfferedPsks.SelectedConfig selectPreSharedKey(TlsServerContext serverContext, TlsServer server, Hashtable clientHelloExtensions, HandshakeMessageInput clientHelloMessage, TlsHandshakeHash handshakeHash, boolean afterHelloRetryRequest) throws IOException {
        boolean handshakeHashUpdated = false;
        OfferedPsks offeredPsks = TlsExtensionsUtils.getPreSharedKeyClientHello(clientHelloExtensions);
        if (offeredPsks != null) {
            int index;
            TlsPSKExternal psk;
            short[] pskKeyExchangeModes = TlsExtensionsUtils.getPSKKeyExchangeModesExtension(clientHelloExtensions);
            if (TlsUtils.isNullOrEmpty(pskKeyExchangeModes)) {
                throw new TlsFatalAlert(109);
            }
            if (Arrays.contains(pskKeyExchangeModes, (short)1) && (psk = server.getExternalPSK(offeredPsks.getIdentities())) != null && (index = offeredPsks.getIndexOfIdentity(new PskIdentity(psk.getIdentity(), 0L))) >= 0) {
                byte[] transcriptHash;
                byte[] binder = (byte[])offeredPsks.getBinders().elementAt(index);
                TlsCrypto crypto = serverContext.getCrypto();
                TlsSecret earlySecret = TlsUtils.getPSKEarlySecret(crypto, psk);
                boolean isExternalPSK = true;
                int pskCryptoHashAlgorithm = TlsCryptoUtils.getHashForPRF(psk.getPRFAlgorithm());
                handshakeHashUpdated = true;
                int bindersSize = offeredPsks.getBindersSize();
                clientHelloMessage.updateHashPrefix(handshakeHash, bindersSize);
                if (afterHelloRetryRequest) {
                    transcriptHash = handshakeHash.getFinalHash(pskCryptoHashAlgorithm);
                } else {
                    TlsHash hash = crypto.createHash(pskCryptoHashAlgorithm);
                    handshakeHash.copyBufferTo(new TlsHashOutputStream(hash));
                    transcriptHash = hash.calculateHash();
                }
                clientHelloMessage.updateHashSuffix(handshakeHash, bindersSize);
                byte[] calculatedBinder = TlsUtils.calculatePSKBinder(crypto, isExternalPSK, pskCryptoHashAlgorithm, earlySecret, transcriptHash);
                if (Arrays.constantTimeAreEqual(calculatedBinder, binder)) {
                    return new OfferedPsks.SelectedConfig(index, psk, pskKeyExchangeModes, earlySecret);
                }
            }
        }
        if (!handshakeHashUpdated) {
            clientHelloMessage.updateHash(handshakeHash);
        }
        return null;
    }

    static TlsSecret getPSKEarlySecret(TlsCrypto crypto, TlsPSK psk) {
        int cryptoHashAlgorithm = TlsCryptoUtils.getHashForPRF(psk.getPRFAlgorithm());
        return crypto.hkdfInit(cryptoHashAlgorithm).hkdfExtract(cryptoHashAlgorithm, psk.getKey());
    }

    static TlsSecret[] getPSKEarlySecrets(TlsCrypto crypto, TlsPSK[] psks) {
        int count = psks.length;
        TlsSecret[] earlySecrets = new TlsSecret[count];
        int i = 0;
        while (i < count) {
            earlySecrets[i] = TlsUtils.getPSKEarlySecret(crypto, psks[i]);
            ++i;
        }
        return earlySecrets;
    }

    static TlsPSKExternal[] getPSKExternalsClient(TlsClient client, int[] offeredCipherSuites) throws IOException {
        Vector externalPSKs = client.getExternalPSKs();
        if (TlsUtils.isNullOrEmpty(externalPSKs)) {
            return null;
        }
        int[] prfAlgorithms = TlsUtils.getPRFAlgorithms13(offeredCipherSuites);
        int count = externalPSKs.size();
        TlsPSKExternal[] result = new TlsPSKExternal[count];
        int i = 0;
        while (i < count) {
            Object element = externalPSKs.elementAt(i);
            if (!(element instanceof TlsPSKExternal)) {
                throw new TlsFatalAlert(80, "External PSKs element is not a TlsPSKExternal");
            }
            TlsPSKExternal pskExternal = (TlsPSKExternal)element;
            if (!Arrays.contains(prfAlgorithms, pskExternal.getPRFAlgorithm())) {
                throw new TlsFatalAlert(80, "External PSK incompatible with offered cipher suites");
            }
            result[i] = pskExternal;
            ++i;
        }
        return result;
    }

    static Vector getPSKIndices(TlsPSK[] psks, int prfAlgorithm) {
        Vector<Integer> v = new Vector<Integer>(psks.length);
        int i = 0;
        while (i < psks.length) {
            if (psks[i].getPRFAlgorithm() == prfAlgorithm) {
                v.add(Integers.valueOf(i));
            }
            ++i;
        }
        return v;
    }
}

