/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto;

import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.jcajce.util.JcaJceHelper;
import cn.win_trust_erpc.bouncycastle.tls.DigitallySigned;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCipher;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsDHConfig;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsDHDomain;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsECConfig;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsECDomain;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHMAC;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHash;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsNonceGenerator;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSRP6Client;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSRP6Server;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSRPConfig;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamVerifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;

public interface TlsCrypto {
    public boolean hasAllRawSignatureAlgorithms();

    public boolean hasDHAgreement();

    public boolean hasECDHAgreement();

    public boolean hasSM2Agreement();

    public boolean hasEncryptionAlgorithm(int var1);

    public boolean hasCryptoHashAlgorithm(int var1);

    public boolean hasCryptoSignatureAlgorithm(int var1);

    public boolean hasMacAlgorithm(int var1);

    public boolean hasNamedGroup(int var1);

    public boolean hasRSAEncryption();

    public boolean hasSignatureAlgorithm(short var1);

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm var1);

    public boolean hasSignatureScheme(int var1);

    public boolean hasSRPAuthentication();

    public TlsSecret createSecret(byte[] var1);

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion var1);

    public SecureRandom getSecureRandom();

    public TlsCertificate createCertificate(byte[] var1) throws IOException;

    public TlsCipher createCipher(TlsCryptoParameters var1, int var2, int var3) throws IOException;

    public TlsDHDomain createDHDomain(TlsDHConfig var1);

    public TlsECDomain createECDomain(TlsECConfig var1);

    public TlsSecret adoptSecret(TlsSecret var1);

    public TlsHash createHash(int var1);

    public TlsHMAC createHMAC(int var1);

    public TlsHMAC createHMACForHash(int var1);

    public TlsNonceGenerator createNonceGenerator(byte[] var1);

    public TlsSRP6Client createSRP6Client(TlsSRPConfig var1);

    public TlsSRP6Server createSRP6Server(TlsSRPConfig var1, BigInteger var2);

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig var1);

    public TlsSecret hkdfInit(int var1);

    public String getDigestName(int var1);

    public JcaJceHelper getHelper();

    public TlsStreamSigner createVerifyingStreamSigner(SignatureAndHashAlgorithm var1, PrivateKey var2, boolean var3, PublicKey var4) throws IOException;

    public Cipher createRSAEncryptionCipher() throws GeneralSecurityException;

    public TlsStreamSigner createStreamSigner(SignatureAndHashAlgorithm var1, PrivateKey var2, boolean var3) throws IOException;

    public TlsStreamSigner createStreamSigner(String var1, Object var2, PrivateKey var3, boolean var4);

    public TlsStreamVerifier createStreamVerifier(DigitallySigned var1, PublicKey var2) throws IOException;

    public TlsStreamVerifier createStreamVerifier(String var1, Object var2, byte[] var3, PublicKey var4);

    public AlgorithmParameters getNamedGroupAlgorithmParameters(int var1) throws GeneralSecurityException;

    public AlgorithmParameters getSignatureSchemeAlgorithmParameters(int var1) throws GeneralSecurityException;

    public Digest createDigest(int var1);
}

