/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.engines.ChaCha7539Engine;
import cn.win_trust_erpc.bouncycastle.crypto.macs.Poly1305;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithIV;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.Pack;
import java.io.IOException;

public class BcChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final byte[] ZEROES = new byte[15];
    protected final ChaCha7539Engine cipher = new ChaCha7539Engine();
    protected final Poly1305 mac = new Poly1305();
    protected final boolean isEncrypting;
    protected int additionalDataLength;

    public BcChaCha20Poly1305(boolean isEncrypting) {
        this.isEncrypting = isEncrypting;
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        boolean badMac;
        if (this.isEncrypting) {
            int ciphertextLength = inputLength;
            int outputLength = this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
            if (ciphertextLength != outputLength) {
                throw new IllegalStateException();
            }
            this.updateMAC(output, outputOffset, ciphertextLength);
            byte[] lengths = new byte[16];
            Pack.longToLittleEndian((long)this.additionalDataLength & 0xFFFFFFFFL, lengths, 0);
            Pack.longToLittleEndian((long)ciphertextLength & 0xFFFFFFFFL, lengths, 8);
            this.mac.update(lengths, 0, 16);
            this.mac.doFinal(output, outputOffset + ciphertextLength);
            return ciphertextLength + 16;
        }
        int ciphertextLength = inputLength - 16;
        this.updateMAC(input, inputOffset, ciphertextLength);
        byte[] expectedMac = new byte[16];
        Pack.longToLittleEndian((long)this.additionalDataLength & 0xFFFFFFFFL, expectedMac, 0);
        Pack.longToLittleEndian((long)ciphertextLength & 0xFFFFFFFFL, expectedMac, 8);
        this.mac.update(expectedMac, 0, 16);
        this.mac.doFinal(expectedMac, 0);
        boolean bl = badMac = !TlsUtils.constantTimeAreEqual(16, expectedMac, 0, input, inputOffset + ciphertextLength);
        if (badMac) {
            throw new TlsFatalAlert(20);
        }
        int outputLength = this.cipher.processBytes(input, inputOffset, ciphertextLength, output, outputOffset);
        if (ciphertextLength != outputLength) {
            throw new IllegalStateException();
        }
        return ciphertextLength;
    }

    @Override
    public int getOutputSize(int inputLength) {
        return this.isEncrypting ? inputLength + 16 : inputLength - 16;
    }

    @Override
    public void init(byte[] nonce, int macSize, byte[] additionalData) throws IOException {
        if (nonce == null || nonce.length != 12 || macSize != 16) {
            throw new TlsFatalAlert(80);
        }
        this.cipher.init(this.isEncrypting, new ParametersWithIV(null, nonce));
        this.initMAC();
        if (additionalData == null) {
            this.additionalDataLength = 0;
        } else {
            this.additionalDataLength = additionalData.length;
            this.updateMAC(additionalData, 0, additionalData.length);
        }
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) throws IOException {
        KeyParameter cipherKey = new KeyParameter(key, keyOff, keyLen);
        this.cipher.init(this.isEncrypting, new ParametersWithIV(cipherKey, ZEROES, 0, 12));
    }

    protected void initMAC() {
        byte[] firstBlock = new byte[64];
        this.cipher.processBytes(firstBlock, 0, 64, firstBlock, 0);
        this.mac.init(new KeyParameter(firstBlock, 0, 32));
        Arrays.fill(firstBlock, (byte)0);
    }

    protected void updateMAC(byte[] buf, int off, int len) {
        this.mac.update(buf, off, len);
        int partial = len % 16;
        if (partial != 0) {
            this.mac.update(ZEROES, 0, 16 - partial);
        }
    }
}

