/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.crypto.ExtendedDigest;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHMAC;
import cn.win_trust_erpc.bouncycastle.util.Arrays;

class BcSSL3HMAC
implements TlsHMAC {
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static final byte[] IPAD = BcSSL3HMAC.genPad((byte)54, 48);
    private static final byte[] OPAD = BcSSL3HMAC.genPad((byte)92, 48);
    private Digest digest;
    private int padLength;
    private byte[] secret;

    BcSSL3HMAC(Digest digest) {
        this.digest = digest;
        this.padLength = digest.getDigestSize() == 20 ? 40 : 48;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.secret = TlsUtils.copyOfRangeExact(key, keyOff, keyOff + keyLen);
        this.reset();
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public byte[] calculateMAC() {
        byte[] result = new byte[this.digest.getDigestSize()];
        this.doFinal(result, 0);
        return result;
    }

    @Override
    public void calculateMAC(byte[] output, int outOff) {
        this.doFinal(output, outOff);
    }

    @Override
    public int getInternalBlockSize() {
        return ((ExtendedDigest)this.digest).getByteLength();
    }

    @Override
    public int getMacLength() {
        return this.digest.getDigestSize();
    }

    @Override
    public void reset() {
        this.digest.reset();
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(IPAD, 0, this.padLength);
    }

    private void doFinal(byte[] out, int outOff) {
        byte[] tmp = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(tmp, 0);
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(OPAD, 0, this.padLength);
        this.digest.update(tmp, 0, tmp.length);
        this.digest.doFinal(out, outOff);
        this.reset();
    }

    private static byte[] genPad(byte b, int count) {
        byte[] padding = new byte[count];
        Arrays.fill(padding, b);
        return padding;
    }
}

