/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsAgreement;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import java.io.IOException;

public class BcTlsDH
implements TlsAgreement {
    protected final BcTlsDHDomain domain;
    protected AsymmetricCipherKeyPair localKeyPair;
    protected DHPublicKeyParameters peerPublicKey;

    public BcTlsDH(BcTlsDHDomain domain) {
        this.domain = domain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((DHPublicKeyParameters)this.localKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(peerValue);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        return this.domain.calculateDHAgreement((DHPrivateKeyParameters)this.localKeyPair.getPrivate(), this.peerPublicKey);
    }
}

