/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.signers.Ed448Signer;
import cn.win_trust_erpc.bouncycastle.tls.DigitallySigned;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureScheme;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamVerifier;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsStreamVerifier;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import java.io.IOException;

public class BcTlsEd448Verifier
extends BcTlsVerifier {
    public BcTlsEd448Verifier(TlsCrypto crypto, Ed448PublicKeyParameters publicKey) {
        super(crypto, publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || SignatureScheme.from(algorithm) != 2056) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        Ed448Signer verifier = new Ed448Signer(TlsUtils.EMPTY_BYTES);
        verifier.init(false, this.publicKey);
        return new BcTlsStreamVerifier(verifier, signature.getSignature());
    }
}

