/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsHash;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

final class BcTlsHash
implements TlsHash {
    private final BcTlsCrypto crypto;
    private final int cryptoHashAlgorithm;
    private final Digest digest;

    BcTlsHash(BcTlsCrypto crypto, int cryptoHashAlgorithm) {
        this(crypto, cryptoHashAlgorithm, crypto.createDigest(cryptoHashAlgorithm));
    }

    private BcTlsHash(BcTlsCrypto crypto, int cryptoHashAlgorithm, Digest digest) {
        this.crypto = crypto;
        this.cryptoHashAlgorithm = cryptoHashAlgorithm;
        this.digest = digest;
    }

    @Override
    public void update(byte[] data, int offSet, int length) {
        this.digest.update(data, offSet, length);
    }

    @Override
    public byte[] calculateHash() {
        byte[] rv = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(rv, 0);
        return rv;
    }

    @Override
    public TlsHash cloneHash() {
        return new BcTlsHash(this.crypto, this.cryptoHashAlgorithm, this.crypto.cloneDigest(this.cryptoHashAlgorithm, this.digest));
    }

    @Override
    public void reset() {
        this.digest.reset();
    }
}

