/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.DEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.crypto.InvalidCipherTextException;
import cn.win_trust_erpc.bouncycastle.crypto.engines.SM2Engine;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsEncryptor;
import java.io.IOException;
import java.math.BigInteger;

final class BcTlsSM2Encryptor
implements TlsEncryptor {
    private final TlsCrypto crypto;
    private final ECPublicKeyParameters pubKeyEC;

    private static ECPublicKeyParameters checkPublicKey(ECPublicKeyParameters pubKeyEC) {
        if (pubKeyEC == null || pubKeyEC.isPrivate()) {
            throw new IllegalArgumentException("No public RSA key provided");
        }
        return pubKeyEC;
    }

    BcTlsSM2Encryptor(TlsCrypto crypto, ECPublicKeyParameters pubKeyEC) {
        this.crypto = crypto;
        this.pubKeyEC = BcTlsSM2Encryptor.checkPublicKey(pubKeyEC);
    }

    @Override
    public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
        try {
            SM2Engine encoding = new SM2Engine();
            encoding.init(true, new ParametersWithRandom(this.pubKeyEC, this.crypto.getSecureRandom()));
            byte[] c1c2c3 = encoding.processBlock(input, inOff, length);
            byte[] c1 = new byte[65];
            int c2Len = c1c2c3.length - 97;
            byte[] c2 = new byte[c2Len];
            byte[] c3 = new byte[32];
            byte[] c1_x = new byte[32];
            byte[] c1_y = new byte[32];
            System.arraycopy(c1c2c3, 0, c1, 0, 65);
            System.arraycopy(c1c2c3, 65, c2, 0, c2.length);
            System.arraycopy(c1c2c3, 65 + c2.length, c3, 0, 32);
            System.arraycopy(c1, 1, c1_x, 0, 32);
            System.arraycopy(c1, 33, c1_y, 0, 32);
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new ASN1Integer(new BigInteger(1, c1_x)));
            v.add(new ASN1Integer(new BigInteger(1, c1_y)));
            v.add(new DEROctetString(c3));
            v.add(new DEROctetString(c2));
            byte[] asn1 = new DERSequence(v).getEncoded("DER");
            return asn1;
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

