/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithID;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.crypto.signers.SM2Signer;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsStreamSigner;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;

public class BcTlsSM2Signer
extends BcTlsSigner {
    protected final byte[] identifier;

    public BcTlsSM2Signer(BcTlsCrypto crypto, ECPrivateKeyParameters privateKey, byte[] identifier) {
        super(crypto, privateKey);
        this.identifier = Arrays.clone(identifier);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) {
        if (algorithm == null) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom());
        ParametersWithID parametersWithID = new ParametersWithID(parametersWithRandom, this.identifier);
        SM2Signer signer = new SM2Signer();
        signer.init(true, parametersWithID);
        return new BcTlsStreamSigner(signer);
    }
}

