/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.CryptoException;
import cn.win_trust_erpc.bouncycastle.crypto.Signer;
import cn.win_trust_erpc.bouncycastle.crypto.io.SignerOutputStream;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamSigner;
import cn.win_trust_erpc.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class BcVerifyingStreamSigner
implements TlsStreamSigner {
    private final Signer signer;
    private final Signer verifier;
    private final TeeOutputStream output;

    BcVerifyingStreamSigner(Signer signer, Signer verifier) {
        SignerOutputStream outputSigner = new SignerOutputStream(signer);
        SignerOutputStream outputVerifier = new SignerOutputStream(verifier);
        this.signer = signer;
        this.verifier = verifier;
        this.output = new TeeOutputStream(outputSigner, outputVerifier);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    @Override
    public byte[] getSignature() throws IOException {
        try {
            byte[] signature = this.signer.generateSignature();
            if (this.verifier.verifySignature(signature)) {
                return signature;
            }
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        throw new TlsFatalAlert(80);
    }
}

