/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.math.ec.rfc7748.X448;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsAgreement;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;

public class BcX448
implements TlsAgreement {
    protected final BcTlsCrypto crypto;
    protected final byte[] privateKey = new byte[56];
    protected final byte[] peerPublicKey = new byte[56];

    public BcX448(BcTlsCrypto crypto) {
        this.crypto = crypto;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.crypto.getSecureRandom().nextBytes(this.privateKey);
        byte[] publicKey = new byte[56];
        X448.scalarMultBase(this.privateKey, 0, publicKey, 0);
        return publicKey;
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (peerValue == null || peerValue.length != 56) {
            throw new TlsFatalAlert(47);
        }
        System.arraycopy(peerValue, 0, this.peerPublicKey, 0, 56);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] secret = new byte[56];
            if (!X448.calculateAgreement(this.privateKey, 0, this.peerPublicKey, 0, secret, 0)) {
                throw new TlsFatalAlert(40);
            }
            BcTlsSecret bcTlsSecret = this.crypto.adoptLocalSecret(secret);
            return bcTlsSecret;
        }
        finally {
            Arrays.fill(this.privateKey, (byte)0);
            Arrays.fill(this.peerPublicKey, (byte)0);
        }
    }
}

