/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.DefaultTlsCredentialedSigner;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureScheme;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSASigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSA13Signer;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSASigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd25519Signer;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd448Signer;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAPSSSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSASigner;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;

public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static JcaTlsCertificate getEndEntity(TlsCrypto crypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("No certificate");
        }
        return JcaTlsCertificate.convert(crypto, certificate.getCertificateAt(0));
    }

    private static TlsSigner makeSigner(TlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsSigner signer;
        String algorithm = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(algorithm) || "RSASSA-PSS".equalsIgnoreCase(algorithm)) {
            PublicKey publicKey;
            int signatureScheme;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsRSAPSSSigner(crypto, privateKey, signatureScheme);
            }
            try {
                publicKey = JcaDefaultTlsCredentialedSigner.getEndEntity(crypto, certificate).getPubKeyRSA();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            signer = new JcaTlsRSASigner(crypto, privateKey, publicKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsDSASigner(crypto, privateKey);
        } else if (ECUtil.isECPrivateKey(privateKey)) {
            int signatureScheme;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsECDSA13Signer(crypto, privateKey, signatureScheme);
            }
            signer = new JcaTlsECDSASigner(crypto, privateKey);
        } else if ("Ed25519".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsEd25519Signer(crypto, privateKey);
        } else if ("Ed448".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsEd448Signer(crypto, privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, TlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, JcaDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

