/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamSigner;
import java.io.IOException;
import java.security.PrivateKey;

public abstract class JcaTlsEdDSASigner
implements TlsSigner {
    protected final TlsCrypto crypto;
    protected final PrivateKey privateKey;
    protected final short algorithmType;
    protected final String algorithmName;

    public JcaTlsEdDSASigner(TlsCrypto crypto2, PrivateKey privateKey, short algorithmType, String algorithmName) {
        if (crypto2 == null) {
            throw new NullPointerException("crypto");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey");
        }
        this.crypto = crypto2;
        this.privateKey = privateKey;
        this.algorithmType = algorithmType;
        this.algorithmName = algorithmName;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        if (algorithm == null || algorithm.getSignature() != this.algorithmType || algorithm.getHash() != 8) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        return this.crypto.createStreamSigner(this.algorithmName, null, this.privateKey, false);
    }
}

