/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureScheme;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;

public class JcaTlsRSAPSSSigner
implements TlsSigner {
    private final TlsCrypto crypto;
    private final PrivateKey privateKey;
    private final int signatureScheme;

    public JcaTlsRSAPSSSigner(TlsCrypto crypto, PrivateKey privateKey, int signatureScheme) {
        if (crypto == null) {
            throw new NullPointerException("crypto");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey");
        }
        if (!SignatureScheme.isRSAPSS(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.crypto = crypto;
        this.privateKey = privateKey;
        this.signatureScheme = signatureScheme;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        String digestName = this.crypto.getDigestName(cryptoHashAlgorithm);
        String sigName = String.valueOf(RSAUtil.getDigestSigAlgName(digestName)) + "WITHRSAANDMGF1";
        AlgorithmParameterSpec pssSpec = RSAUtil.getPSSParameterSpec(cryptoHashAlgorithm, digestName, this.crypto.getHelper());
        return this.crypto.createStreamSigner(sigName, pssSpec, this.privateKey, true);
    }
}

