/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.jcajce.io.OutputStreamFactory;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsStreamSigner;
import cn.win_trust_erpc.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;

class JcaVerifyingStreamSigner
implements TlsStreamSigner {
    private final Signature signer;
    private final Signature verifier;
    private final OutputStream output;

    JcaVerifyingStreamSigner(Signature signer, Signature verifier) {
        OutputStream outputSigner = OutputStreamFactory.createStream(signer);
        OutputStream outputVerifier = OutputStreamFactory.createStream(verifier);
        this.signer = signer;
        this.verifier = verifier;
        this.output = new TeeOutputStream(outputSigner, outputVerifier);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    @Override
    public byte[] getSignature() throws IOException {
        try {
            byte[] signature = this.signer.sign();
            if (this.verifier.verify(signature)) {
                return signature;
            }
        }
        catch (SignatureException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        throw new TlsFatalAlert(80);
    }
}

