/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedAgreement;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoException;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.interfaces.DHPrivateKey;

public class JceDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    private final JcaTlsCrypto crypto;
    private final Certificate certificate;
    private final PrivateKey privateKey;
    private final String agreementAlgorithm;

    public static String getAgreementAlgorithm(PrivateKey privateKey) {
        if (privateKey instanceof DHPrivateKey) {
            return "DH";
        }
        if (ECUtil.isECPrivateKey(privateKey)) {
            return "ECDH";
        }
        throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
    }

    public JceDefaultTlsCredentialedAgreement(JcaTlsCrypto crypto, Certificate certificate, PrivateKey privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.agreementAlgorithm = JceDefaultTlsCredentialedAgreement.getAgreementAlgorithm(privateKey);
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
        try {
            PublicKey publicKey = JcaTlsCertificate.convert(this.crypto, peerCertificate).getPublicKey();
            byte[] secret = this.crypto.calculateKeyAgreement(this.agreementAlgorithm, this.privateKey, publicKey, "TlsPremasterSecret");
            return this.crypto.adoptLocalSecret(secret);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to perform agreement", e);
        }
    }
}

