/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.jcajce;

import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedDecryptor;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.TlsImplUtils;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;

public class JceDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected TlsCrypto crypto;
    protected Certificate certificate;
    protected PrivateKey privateKey;

    public JceDefaultTlsCredentialedDecryptor(TlsCrypto crypto, Certificate certificate, PrivateKey privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!(privateKey instanceof RSAPrivateKey) && !"RSA".equals(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        return this.safeDecryptPreMasterSecret(cryptoParams, this.privateKey, ciphertext);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters cryptoParams, PrivateKey rsaServerPrivateKey, byte[] encryptedPreMasterSecret) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion expectedVersion = cryptoParams.getRSAPreMasterSecretVersion();
        boolean versionNumberCheckDisabled = false;
        byte[] fallback = new byte[48];
        secureRandom.nextBytes(fallback);
        byte[] M = Arrays.clone(fallback);
        try {
            Cipher c = this.crypto.createRSAEncryptionCipher();
            c.init(2, (Key)rsaServerPrivateKey, secureRandom);
            byte[] m = c.doFinal(encryptedPreMasterSecret);
            if (m != null && m.length == 48) {
                M = m;
            }
        }
        catch (Exception c) {
            // empty catch block
        }
        if (!versionNumberCheckDisabled || TlsImplUtils.isTLSv11(expectedVersion)) {
            int mask = expectedVersion.getMajorVersion() ^ M[0] & 0xFF | expectedVersion.getMinorVersion() ^ M[1] & 0xFF;
            mask = mask - 1 >> 31;
            int i = 0;
            while (i < 48) {
                M[i] = (byte)(M[i] & mask | fallback[i] & ~mask);
                ++i;
            }
        }
        return this.crypto.createSecret(M);
    }
}

